/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wcs.responses.coverage;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.ZipOutputStream;
import org.geoserver.platform.ServiceException;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.gce.gtopo30.GTopo30Writer;
import org.opengis.coverage.grid.GridCoverage;
import org.vfny.geoserver.wcs.responses.CoverageResponseDelegate;

public class GTopo30CoverageResponseDelegate
implements CoverageResponseDelegate {
    private static final Set<String> FORMATS = new HashSet<String>(Arrays.asList("application/gtopo30"));
    private GridCoverage2D sourceCoverage;

    public boolean canProduce(String outputFormat) {
        return outputFormat != null && (outputFormat.equalsIgnoreCase("GTopo30") || FORMATS.contains(outputFormat.toLowerCase()));
    }

    public String getMimeFormatFor(String outputFormat) {
        if (this.canProduce(outputFormat)) {
            return "application/gtopo30";
        }
        return null;
    }

    public void prepare(String outputFormat, GridCoverage2D coverage) throws IOException {
        this.sourceCoverage = coverage;
    }

    public String getContentType() {
        return "application/x-zip";
    }

    public String getContentEncoding() {
        return null;
    }

    public String getContentDisposition() {
        return new StringBuffer("attachment;filename=").append((CharSequence)this.sourceCoverage.getName()).append(".zip").toString();
    }

    public String getFileExtension() {
        return "zip";
    }

    public void encode(OutputStream output) throws ServiceException, IOException {
        ZipOutputStream outZ = new ZipOutputStream(output);
        output = outZ;
        GTopo30Writer writer = new GTopo30Writer((Object)outZ);
        writer.write((GridCoverage)this.sourceCoverage, null);
        writer.dispose();
        this.sourceCoverage.dispose(false);
        this.sourceCoverage = null;
    }
}

