/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wcs.responses.coverage;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.geoserver.platform.ServiceException;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.gce.image.WorldImageWriter;
import org.opengis.coverage.grid.Format;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.vfny.geoserver.wcs.responses.CoverageResponseDelegate;

public class IMGCoverageResponseDelegate
implements CoverageResponseDelegate {
    private static final Set<String> FORMATS = new HashSet<String>(Arrays.asList("image/bmp", "image/gif", "image/tiff", "image/png", "image/jpeg"));
    private GridCoverage2D sourceCoverage;
    private String outputFormat;

    public boolean canProduce(String outputFormat) {
        return outputFormat != null && (FORMATS.contains(outputFormat.toLowerCase()) || FORMATS.contains("image/" + outputFormat.toLowerCase()));
    }

    public String getMimeFormatFor(String outputFormat) {
        if (!this.canProduce(outputFormat)) {
            return null;
        }
        if (FORMATS.contains(outputFormat.toLowerCase())) {
            return outputFormat;
        }
        String mime = "image/" + outputFormat.toLowerCase();
        if (FORMATS.contains(mime)) {
            return mime;
        }
        return null;
    }

    public void prepare(String outputFormat, GridCoverage2D coverage) throws IOException {
        this.outputFormat = outputFormat.startsWith("image/") ? outputFormat.substring(6) : outputFormat;
        this.sourceCoverage = coverage;
    }

    public String getContentType() {
        return new StringBuffer("image/").append(this.outputFormat.toLowerCase()).toString();
    }

    public String getContentEncoding() {
        return null;
    }

    public String getContentDisposition() {
        return this.outputFormat.equalsIgnoreCase("tiff") || this.outputFormat.equalsIgnoreCase("tif") ? new StringBuffer("attachment;filename=").append((CharSequence)this.sourceCoverage.getName()).append(".").append(this.outputFormat).toString() : null;
    }

    public String getFileExtension() {
        return "outputFormat";
    }

    public void encode(OutputStream output) throws ServiceException, IOException {
        if (this.sourceCoverage == null) {
            throw new IllegalStateException("It seems prepare() has not been called or has not succeed");
        }
        WorldImageWriter writer = new WorldImageWriter((Object)output);
        Format writerParams = writer.getFormat();
        ParameterValueGroup writeParameters = writerParams.getWriteParameters();
        ParameterValue format = writeParameters.parameter("Format");
        format.setValue((Object)this.outputFormat.toLowerCase());
        try {
            writer.write((GridCoverage)this.sourceCoverage, new GeneralParameterValue[]{format});
            output.flush();
        }
        finally {
            IOUtils.closeQuietly((OutputStream)output);
            try {
                writer.dispose();
            }
            catch (Throwable throwable) {}
            this.sourceCoverage.dispose(false);
            this.sourceCoverage = null;
        }
    }
}

