/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wcs.responses.coverage;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.GZIPOutputStream;
import org.geoserver.platform.ServiceException;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.gce.arcgrid.ArcGridWriter;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.parameter.ParameterValueGroup;
import org.vfny.geoserver.wcs.WcsException;
import org.vfny.geoserver.wcs.responses.CoverageResponseDelegate;

public class AscCoverageResponseDelegate
implements CoverageResponseDelegate {
    private static final Set<String> FORMATS = new HashSet<String>(Arrays.asList("application/arcgrid", "application/arcgrid;zipped=\"true\""));
    private GridCoverage2D sourceCoverage;
    private boolean compressOutput = false;

    @Override
    public boolean canProduce(String outputFormat) {
        return outputFormat != null && ("ArcGrid".equalsIgnoreCase(outputFormat) || "ArcGrid-GZIP".equalsIgnoreCase(outputFormat) || FORMATS.contains(outputFormat.toLowerCase()));
    }

    @Override
    public String getMimeFormatFor(String outputFormat) {
        if ("ArcGrid".equalsIgnoreCase(outputFormat)) {
            return "application/arcgrid";
        }
        if ("ArcGrid-GZIP".equalsIgnoreCase(outputFormat)) {
            return "application/arcgrid;zipped=\"true\"";
        }
        if (FORMATS.contains(outputFormat)) {
            return outputFormat;
        }
        return null;
    }

    @Override
    public void prepare(String outputFormat, GridCoverage2D coverage) throws IOException {
        this.compressOutput = "ArcGrid-GZIP".equalsIgnoreCase(outputFormat);
        this.sourceCoverage = coverage;
    }

    @Override
    public String getContentType() {
        return this.compressOutput ? "application/x-gzip" : "text/plain";
    }

    @Override
    public String getContentEncoding() {
        return null;
    }

    @Override
    public String getContentDisposition() {
        return this.compressOutput ? "attachment;filename=" + this.sourceCoverage.getName() + ".asc.gz" : null;
    }

    @Override
    public String getFileExtension() {
        return this.compressOutput ? "asc.gz" : "asc";
    }

    @Override
    public void encode(OutputStream output) throws ServiceException, IOException {
        if (this.sourceCoverage == null) {
            throw new IllegalStateException(new StringBuffer("It seems prepare() has not been called").append(" or has not succeed").toString());
        }
        GZIPOutputStream gzipOut = null;
        if (this.compressOutput) {
            gzipOut = new GZIPOutputStream(output);
            output = gzipOut;
        }
        try {
            ArcGridWriter writer = new ArcGridWriter((Object)output);
            ParameterValueGroup params = writer.getFormat().getWriteParameters();
            writer.write((GridCoverage)this.sourceCoverage, null);
            if (gzipOut != null) {
                gzipOut.finish();
                gzipOut.flush();
            }
            writer.dispose();
            this.sourceCoverage.dispose(false);
            this.sourceCoverage = null;
        }
        catch (Exception e) {
            throw new WcsException(new StringBuffer("Problems Rendering Image").append(e.getMessage()).toString(), e);
        }
    }
}

