/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs.xml;

import java.io.Reader;
import java.io.StringReader;
import junit.framework.TestCase;
import net.opengis.wcs11.GetCapabilitiesType;
import org.geoserver.wcs.xml.v1_1_1.WCSConfiguration;
import org.geoserver.wcs.xml.v1_1_1.WcsXmlReader;

public class GetCapabilitiesXmlParserTest
extends TestCase {
    private WCSConfiguration configuration;
    private WcsXmlReader reader;

    protected void setUp() throws Exception {
        super.setUp();
        this.configuration = new WCSConfiguration();
        this.reader = new WcsXmlReader("GetCapabilities", "1.1.1", this.configuration);
    }

    public void testBasic() throws Exception {
        String request = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><wcs:GetCapabilities service=\"WCS\" xmlns:ows=\"http://www.opengis.net/ows/1.1\" xmlns:wcs=\"http://www.opengis.net/wcs/1.1.1\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"/>";
        GetCapabilitiesType cap = (GetCapabilitiesType)this.reader.read(null, (Reader)new StringReader(request), null);
        GetCapabilitiesXmlParserTest.assertEquals((String)"WCS", (String)cap.getService());
    }

    public void testFull() throws Exception {
        String request = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><wcs:GetCapabilities service=\"WCS\" xmlns:ows=\"http://www.opengis.net/ows/1.1\" xmlns:wcs=\"http://www.opengis.net/wcs/1.1.1\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><ows:AcceptVersions>  <ows:Version>1.0.0</ows:Version></ows:AcceptVersions><ows:Sections>  <ows:Section>Section1</ows:Section></ows:Sections><ows:AcceptFormats>  <ows:OutputFormat>text/xml</ows:OutputFormat></ows:AcceptFormats></wcs:GetCapabilities>";
        GetCapabilitiesType cap = (GetCapabilitiesType)this.reader.read(null, (Reader)new StringReader(request), null);
        GetCapabilitiesXmlParserTest.assertEquals((String)"WCS", (String)cap.getService());
        GetCapabilitiesXmlParserTest.assertEquals((int)1, (int)cap.getAcceptVersions().getVersion().size());
        GetCapabilitiesXmlParserTest.assertEquals((String)"1.0.0", (String)((String)cap.getAcceptVersions().getVersion().get(0)));
        GetCapabilitiesXmlParserTest.assertEquals((int)1, (int)cap.getSections().getSection().size());
        GetCapabilitiesXmlParserTest.assertEquals((String)"Section1", (String)((String)cap.getSections().getSection().get(0)));
        GetCapabilitiesXmlParserTest.assertEquals((int)1, (int)cap.getAcceptFormats().getOutputFormat().size());
        GetCapabilitiesXmlParserTest.assertEquals((String)"text/xml", (String)((String)cap.getAcceptFormats().getOutputFormat().get(0)));
    }
}

