/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.filters;

import com.mockrunner.mock.web.MockFilterChain;
import com.mockrunner.mock.web.MockFilterConfig;
import com.mockrunner.mock.web.MockHttpServletRequest;
import com.mockrunner.mock.web.MockHttpServletResponse;
import com.mockrunner.mock.web.MockHttpSession;
import com.mockrunner.mock.web.MockServletContext;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpSession;
import junit.framework.TestCase;
import org.apache.wicket.spring.test.ApplicationContextMock;
import org.geoserver.config.GeoServer;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.config.impl.GeoServerImpl;
import org.geoserver.config.impl.GeoServerInfoImpl;
import org.geoserver.filters.ReverseProxyFilter;
import org.geoserver.platform.GeoServerExtensions;
import org.springframework.context.ApplicationContext;

public class ReverseProxyFilterTest
extends TestCase {
    private static final String DEFAULT_MIME_TYPES_REGEX = "text/html.*,text/css.*,text/javascript.*,application/x-javascript.*";
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    ReverseProxyFilter filter;

    protected void setUp() throws Exception {
        super.setUp();
        this.filter = new ReverseProxyFilter();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.filter = null;
    }

    protected GeoServer getMockGeoServer(String proxyBaseUrl) {
        GeoServerImpl config = new GeoServerImpl();
        GeoServerInfoImpl geoserver = new GeoServerInfoImpl((GeoServer)config);
        geoserver.setProxyBaseUrl(proxyBaseUrl);
        config.setGlobal((GeoServerInfo)geoserver);
        return config;
    }

    public void testInit() throws ServletException {
        String proxyBaseUrl = "https://localhost/geoserver/tools";
        GeoServer geoserver = this.getMockGeoServer("https://localhost/geoserver/tools");
        String mimeTypesInitParam = "*wrong*expression*";
        try {
            ReverseProxyFilter.parsePatterns((GeoServerInfo)geoserver.getGlobal(), (String)mimeTypesInitParam);
            ReverseProxyFilterTest.fail((String)"expected ServletException with an illegal regular expression to match mime types");
        }
        catch (ServletException e) {
            ReverseProxyFilterTest.assertTrue((boolean)true);
        }
        mimeTypesInitParam = DEFAULT_MIME_TYPES_REGEX;
        ReverseProxyFilter.parsePatterns((GeoServerInfo)geoserver.getGlobal(), (String)mimeTypesInitParam);
    }

    public void testDoFilterDisabled() throws ServletException, IOException {
        String proxyBaseUrl = "https://proxy.server:9090/applications/geoserver";
        String requestBaseUrl = "http://localhost:8080/geoserver";
        String requestResource = "/www/resource.html";
        String content = "<a href=\"http://localhost:8080/geoserver/linked.html\">link</a>" + LINE_SEPARATOR;
        String contentType = "text/html";
        String result = this.testDoFilter("https://proxy.server:9090/applications/geoserver", "http://localhost:8080/geoserver", "/www/resource.html", content, "text/html", false);
        ReverseProxyFilterTest.assertEquals((String)content, (String)result);
    }

    public void testDoFilterExtraProxyContext() throws ServletException, IOException {
        String proxyBaseUrl = "https://proxy.server:9090/applications/geoserver";
        String requestBaseUrl = "http://localhost:8080/geoserver";
        String requestResource = "/www/resource.html";
        String content = "<a href=\"http://localhost:8080/geoserver/linked.html\">link</a>" + LINE_SEPARATOR;
        String contentType = "text/html";
        String result = this.testDoFilter("https://proxy.server:9090/applications/geoserver", "http://localhost:8080/geoserver", "/www/resource.html", content, "text/html", true);
        String expected = "<a href=\"https://proxy.server:9090/applications/geoserver/linked.html\">link</a>" + LINE_SEPARATOR;
        ReverseProxyFilterTest.assertEquals((String)expected, (String)result);
    }

    public void testDoFilterNonMatchingMime() throws ServletException, IOException {
        String proxyBaseUrl = "https://proxy.server:9090/applications/geoserver";
        String requestBaseUrl = "http://localhost:8080/geoserver";
        String requestResource = "/www/resource.bin";
        String content = "<a href=\"http://localhost:8080/geoserver/linked.html\">link</a>" + LINE_SEPARATOR;
        String contentType = "application/octect-stream";
        String result = this.testDoFilter("https://proxy.server:9090/applications/geoserver", "http://localhost:8080/geoserver", "/www/resource.bin", content, "application/octect-stream", true);
        ReverseProxyFilterTest.assertEquals((String)content, (String)result);
    }

    public void testDoFilterRelativeUrl() throws ServletException, IOException {
        String proxyBaseUrl = "https://proxy.server:9090/applications/geoserver";
        String requestBaseUrl = "http://localhost:8080/geoserver";
        String requestResource = "/resource.js";
        String content = "var=\"/geoserver/wms?\";";
        String contentType = "application/x-javascript";
        String result = this.testDoFilter("https://proxy.server:9090/applications/geoserver", "http://localhost:8080/geoserver", "/resource.js", "var=\"/geoserver/wms?\";", "application/x-javascript", true);
        String expected = "var=\"/applications/geoserver/wms?\";" + LINE_SEPARATOR;
        ReverseProxyFilterTest.assertEquals((String)expected, (String)result);
    }

    public void testDoFilterProxyRoot() throws ServletException, IOException {
        String proxyBaseUrl = "https://proxy.server";
        String requestBaseUrl = "http://localhost:8080/geoserver";
        String requestResource = "/resource.js";
        String content = "<a href=\"http://localhost:8080/geoserver/linked.html\">link</a>" + LINE_SEPARATOR + "<a href=\"/geoserver/style.css\"></a>" + LINE_SEPARATOR;
        String contentType = "text/html; charset=UTF-8";
        String result = this.testDoFilter("https://proxy.server", "http://localhost:8080/geoserver", "/resource.js", content, "text/html; charset=UTF-8", true);
        String expected = "<a href=\"https://proxy.server/linked.html\">link</a>" + LINE_SEPARATOR + "<a href=\"/style.css\"></a>" + LINE_SEPARATOR;
        ReverseProxyFilterTest.assertEquals((String)expected, (String)result);
    }

    public void testDoFilterContentContainsProxifiedUrl() throws ServletException, IOException {
        String proxyBaseUrl = "https://localhost/geoserver/tools";
        String requestBaseUrl = "http://localhost:8080/geoserver";
        String requestResource = "/resource.js";
        String content = "<input type=text value=\"https://localhost/geoserver/tools/proxified\">link</a>" + LINE_SEPARATOR;
        String contentType = "text/html; charset=UTF-8";
        String result = this.testDoFilter("https://localhost/geoserver/tools", "http://localhost:8080/geoserver", "/resource.js", content, "text/html; charset=UTF-8", true);
        ReverseProxyFilterTest.assertEquals((String)content, (String)result);
    }

    public void testDoFilterNoContent() throws ServletException, IOException {
        String proxyBaseUrl = "https://localhost/geoserver/tools";
        String requestBaseUrl = "http://localhost:8080/geoserver";
        String requestResource = "/resource.js";
        String content = "";
        String contentType = "text/html; charset=UTF-8";
        String result = this.testDoFilter("https://localhost/geoserver/tools", "http://localhost:8080/geoserver", "/resource.js", "", "text/html; charset=UTF-8", true);
        ReverseProxyFilterTest.assertEquals((String)"", (String)result);
    }

    private String testDoFilter(String proxyBaseUrl, String requestBaseUrl, String requestResource, final String content, final String contentType, final boolean filterIsEnabled) throws MalformedURLException, ServletException, IOException {
        GeoServer mockGeoServer = this.getMockGeoServer(proxyBaseUrl);
        ApplicationContextMock context = new ApplicationContextMock();
        context.putBean((Object)mockGeoServer);
        GeoServerExtensions ext = new GeoServerExtensions();
        ext.setApplicationContext((ApplicationContext)context);
        MockFilterConfig config = new MockFilterConfig(){

            public String getInitParameter(String name) {
                if ("mime-types".equals(name)) {
                    return ReverseProxyFilterTest.DEFAULT_MIME_TYPES_REGEX;
                }
                if ("enabled".equals(name)) {
                    return String.valueOf(filterIsEnabled);
                }
                return null;
            }
        };
        MockHttpServletRequest req = new MockHttpServletRequest();
        req.setRequestURL(requestBaseUrl + requestResource);
        URL url = new URL(requestBaseUrl);
        req.setServerName(url.getHost());
        req.setScheme(url.getProtocol());
        req.setServerPort(url.getPort() == -1 ? 80 : url.getPort());
        req.setContextPath(url.getPath());
        MockHttpServletResponse res = new MockHttpServletResponse();
        MockFilterChain chain = new MockFilterChain();
        MockHttpSession session = new MockHttpSession();
        req.setSession((HttpSession)session);
        MockServletContext servletContext = new MockServletContext();
        session.setupServletContext((ServletContext)servletContext);
        this.filter.init((FilterConfig)config);
        HttpServlet servlet = new HttpServlet(){

            public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
                String line;
                res.setContentType(contentType);
                PrintWriter writer = res.getWriter();
                BufferedReader reader = new BufferedReader(new StringReader(content));
                while ((line = reader.readLine()) != null) {
                    writer.println(line);
                }
                writer.flush();
            }
        };
        chain.setServlet((Servlet)servlet);
        this.filter.doFilter((ServletRequest)req, (ServletResponse)res, (FilterChain)chain);
        String result = res.getOutputStreamContent();
        return result;
    }
}

