/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.demo;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.wicket.model.IModel;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.web.demo.PreviewLayer;
import org.geoserver.web.demo.PreviewLayerModel;
import org.geoserver.web.wicket.GeoServerDataProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreviewLayerProvider
extends GeoServerDataProvider<PreviewLayer> {
    public static final GeoServerDataProvider.Property<PreviewLayer> TYPE = new GeoServerDataProvider.BeanProperty("type", "type");
    public static final GeoServerDataProvider.Property<PreviewLayer> NAME = new GeoServerDataProvider.BeanProperty("name", "name");
    public static final GeoServerDataProvider.Property<PreviewLayer> TITLE = new GeoServerDataProvider.BeanProperty("title", "title");
    public static final GeoServerDataProvider.Property<PreviewLayer> ABSTRACT = new GeoServerDataProvider.BeanProperty("abstract", "abstract", false);
    public static final GeoServerDataProvider.Property<PreviewLayer> KEYWORDS = new GeoServerDataProvider.BeanProperty("keywords", "keywords", false);
    public static final GeoServerDataProvider.Property<PreviewLayer> COMMON = new GeoServerDataProvider.PropertyPlaceholder("commonFormats");
    public static final GeoServerDataProvider.Property<PreviewLayer> ALL = new GeoServerDataProvider.PropertyPlaceholder("allFormats");
    public static final List<GeoServerDataProvider.Property<PreviewLayer>> PROPERTIES = Arrays.asList(TYPE, NAME, TITLE, ABSTRACT, KEYWORDS, COMMON, ALL);

    protected List<PreviewLayer> getItems() {
        ArrayList<PreviewLayer> result = new ArrayList<PreviewLayer>();
        List layers = this.getCatalog().getLayers();
        for (LayerInfo layer : layers) {
            if (!layer.enabled()) continue;
            result.add(new PreviewLayer(layer));
        }
        List layerGroups = this.getCatalog().getLayerGroups();
        for (LayerGroupInfo group : layerGroups) {
            boolean enabled = true;
            layers = group.getLayers();
            for (LayerInfo layer : layers) {
                enabled &= layer.enabled();
            }
            if (!enabled) continue;
            result.add(new PreviewLayer(group));
        }
        return result;
    }

    protected List<GeoServerDataProvider.Property<PreviewLayer>> getProperties() {
        return PROPERTIES;
    }

    public IModel newModel(Object object) {
        return new PreviewLayerModel((PreviewLayer)object);
    }
}

