/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc.web;

import java.util.ArrayList;
import org.apache.wicket.Component;
import org.geoserver.gwc.GWC;
import org.geoserver.gwc.config.GWCConfig;
import org.geoserver.web.CapabilitiesHomePageLinkProvider;
import org.geoserver.web.CapabilitiesHomePagePanel;
import org.geoserver.web.GeoServerApplication;
import org.geotools.util.Version;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;

public class GWCCapabilitiesHomePageProvider
implements CapabilitiesHomePageLinkProvider {
    private final GWC gwcFacade;

    public GWCCapabilitiesHomePageProvider(GWC gwc) {
        this.gwcFacade = gwc;
    }

    public Component getCapabilitiesComponent(String id) {
        ArrayList<CapabilitiesHomePagePanel.CapsInfo> gwcCaps = new ArrayList<CapabilitiesHomePagePanel.CapsInfo>();
        GeoServerApplication app = GeoServerApplication.get();
        GWCConfig gwcConfig = this.gwcFacade.getConfig();
        try {
            if (gwcConfig.isWMSCEnabled() && app.getBean("gwcServiceWMS") != null) {
                gwcCaps.add(new CapabilitiesHomePagePanel.CapsInfo("WMS-C", new Version("1.1.1"), "../gwc/service/wms?request=GetCapabilities&version=1.1.1&tiled=true"));
            }
        }
        catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
            // empty catch block
        }
        try {
            if (gwcConfig.isWMTSEnabled() && app.getBean("gwcServiceWMTS") != null) {
                gwcCaps.add(new CapabilitiesHomePagePanel.CapsInfo("WMTS", new Version("1.0.0"), "../gwc/service/wmts?REQUEST=GetCapabilities"));
            }
        }
        catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
            // empty catch block
        }
        try {
            if (gwcConfig.isTMSEnabled() && app.getBean("gwcServiceTMS") != null) {
                gwcCaps.add(new CapabilitiesHomePagePanel.CapsInfo("TMS", new Version("1.0.0"), "../gwc/service/tms/1.0.0"));
            }
        }
        catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
            // empty catch block
        }
        return new CapabilitiesHomePagePanel(id, gwcCaps);
    }
}

