/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.security.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.SubmitLink;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.security.AccessMode;
import org.geoserver.security.impl.DataAccessRule;
import org.geoserver.web.GeoServerSecuredPage;
import org.geoserver.web.security.RolesFormComponent;
import org.geoserver.web.security.data.DataAccessRulePage;
import org.geoserver.web.wicket.ParamResourceModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDataAccessRulePage
extends GeoServerSecuredPage {
    List<AccessMode> MODES = Arrays.asList(AccessMode.READ, AccessMode.WRITE);
    DropDownChoice workspace;
    DropDownChoice layer;
    DropDownChoice accessMode;
    RolesFormComponent rolesForComponent;
    Form form;

    public AbstractDataAccessRulePage(DataAccessRule rule) {
        this.setDefaultModel((IModel)new CompoundPropertyModel((Object)new DataAccessRule(rule)));
        this.form = new Form("ruleForm");
        this.add(new Component[]{this.form});
        Component[] componentArray = new Component[1];
        this.workspace = new DropDownChoice("workspace", this.getWorkspaceNames());
        componentArray[0] = this.workspace;
        this.form.add(componentArray);
        this.workspace.add(new IBehavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){

            protected void onUpdate(AjaxRequestTarget target) {
                AbstractDataAccessRulePage.this.layer.setChoices((IModel)new Model(AbstractDataAccessRulePage.this.getLayerNames((String)AbstractDataAccessRulePage.this.workspace.getConvertedInput())));
                AbstractDataAccessRulePage.this.layer.modelChanged();
                target.addComponent((Component)AbstractDataAccessRulePage.this.layer);
            }
        }});
        this.setOutputMarkupId(true);
        Component[] componentArray2 = new Component[1];
        this.layer = new DropDownChoice("layer", this.getLayerNames(rule.getWorkspace()));
        componentArray2[0] = this.layer;
        this.form.add(componentArray2);
        this.layer.setOutputMarkupId(true);
        Component[] componentArray3 = new Component[1];
        this.accessMode = new DropDownChoice("accessMode", this.MODES, (IChoiceRenderer)new AccessModeRenderer());
        componentArray3[0] = this.accessMode;
        this.form.add(componentArray3);
        Component[] componentArray4 = new Component[1];
        this.rolesForComponent = new RolesFormComponent("roles", new RolesModel(rule), this.form, true);
        componentArray4[0] = this.rolesForComponent;
        this.form.add(componentArray4);
        this.form.add(new Component[]{new BookmarkablePageLink("cancel", DataAccessRulePage.class)});
        this.form.add(new Component[]{this.saveLink()});
        this.workspace.setRequired(true);
        this.layer.setRequired(true);
        this.accessMode.setRequired(true);
    }

    SubmitLink saveLink() {
        return new SubmitLink("save"){

            public void onSubmit() {
                AbstractDataAccessRulePage.this.onFormSubmit();
            }
        };
    }

    protected abstract void onFormSubmit();

    ArrayList<String> getWorkspaceNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (WorkspaceInfo ws : this.getCatalog().getWorkspaces()) {
            result.add(ws.getName());
        }
        Collections.sort(result);
        result.add(0, "*");
        return result;
    }

    ArrayList<String> getLayerNames(String workspaceName) {
        ArrayList<String> result = new ArrayList<String>();
        if (!workspaceName.equals("*")) {
            for (ResourceInfo r : this.getCatalog().getResources(ResourceInfo.class)) {
                if (!r.getStore().getWorkspace().getName().equals(workspaceName)) continue;
                result.add(r.getName());
            }
            Collections.sort(result);
        }
        result.add(0, "*");
        return result;
    }

    class AccessModeRenderer
    implements IChoiceRenderer {
        AccessModeRenderer() {
        }

        public Object getDisplayValue(Object object) {
            return (String)new ParamResourceModel(((AccessMode)object).name(), (Component)AbstractDataAccessRulePage.this.getPage(), new Object[0]).getObject();
        }

        public String getIdValue(Object object, int index) {
            return ((AccessMode)object).name();
        }
    }

    static class RolesModel
    implements IModel {
        DataAccessRule rule;

        RolesModel(DataAccessRule rule) {
            this.rule = rule;
        }

        public Object getObject() {
            return new ArrayList(this.rule.getRoles());
        }

        public void setObject(Object object) {
            this.rule.getRoles().clear();
            this.rule.getRoles().addAll((List)object);
        }

        public void detach() {
        }
    }
}

