/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.security.data;

import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.Page;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.model.IModel;
import org.geoserver.security.impl.DataAccessRule;
import org.geoserver.web.GeoServerSecuredPage;
import org.geoserver.web.security.SelectionDataRuleRemovalLink;
import org.geoserver.web.security.data.DataAccessRuleProvider;
import org.geoserver.web.security.data.EditDataAccessRulePage;
import org.geoserver.web.security.data.NewDataAccessRulePage;
import org.geoserver.web.wicket.GeoServerDataProvider;
import org.geoserver.web.wicket.GeoServerDialog;
import org.geoserver.web.wicket.GeoServerTablePanel;
import org.geoserver.web.wicket.SimpleAjaxLink;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataAccessRulePage
extends GeoServerSecuredPage {
    private GeoServerTablePanel<DataAccessRule> rules;
    private SelectionDataRuleRemovalLink removal;
    GeoServerDialog dialog;

    public DataAccessRulePage() {
        DataAccessRuleProvider provider = new DataAccessRuleProvider();
        Component[] componentArray = new Component[1];
        this.rules = new GeoServerTablePanel<DataAccessRule>("table", (GeoServerDataProvider)provider, true){

            protected Component getComponentForProperty(String id, IModel itemModel, GeoServerDataProvider.Property<DataAccessRule> property) {
                if (property == DataAccessRuleProvider.RULEKEY) {
                    return DataAccessRulePage.this.editRuleLink(id, itemModel, property);
                }
                if (property == DataAccessRuleProvider.ROLES) {
                    return new Label(id, property.getModel(itemModel));
                }
                throw new RuntimeException("Uknown property " + property);
            }

            protected void onSelectionUpdate(AjaxRequestTarget target) {
                DataAccessRulePage.this.removal.setEnabled(DataAccessRulePage.this.rules.getSelection().size() > 0);
                target.addComponent((Component)DataAccessRulePage.this.removal);
            }
        };
        componentArray[0] = this.rules;
        this.add(componentArray);
        this.rules.setOutputMarkupId(true);
        Component[] componentArray2 = new Component[1];
        this.dialog = new GeoServerDialog("dialog");
        componentArray2[0] = this.dialog;
        this.add(componentArray2);
        this.setHeaderPanel(this.headerPanel());
    }

    Component editRuleLink(String id, IModel itemModel, GeoServerDataProvider.Property<DataAccessRule> property) {
        return new SimpleAjaxLink(id, itemModel, property.getModel(itemModel)){

            protected void onClick(AjaxRequestTarget target) {
                this.setResponsePage((Page)new EditDataAccessRulePage((DataAccessRule)this.getDefaultModelObject()));
            }
        };
    }

    protected Component headerPanel() {
        Fragment header = new Fragment("headerPanel", "header", (MarkupContainer)this);
        header.add(new Component[]{new BookmarkablePageLink("addNew", NewDataAccessRulePage.class)});
        Component[] componentArray = new Component[1];
        this.removal = new SelectionDataRuleRemovalLink("removeSelected", this.rules, this.dialog);
        componentArray[0] = this.removal;
        header.add(componentArray);
        this.removal.setOutputMarkupId(true);
        this.removal.setEnabled(false);
        return header;
    }
}

