/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs.web.demo;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import javax.xml.transform.TransformerException;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.form.AjaxSubmitLink;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.protocol.http.WebRequest;
import org.geoserver.ows.URLMangler;
import org.geoserver.ows.util.ResponseUtils;
import org.geoserver.wcs.web.demo.GetCoverageRequest;
import org.geoserver.wcs.web.demo.WCS10GetCoverageTransformer;
import org.geoserver.wcs.web.demo.WCS11GetCoverageTransformer;
import org.geoserver.wcs.web.demo.WCSRequestBuilderPanel;
import org.geoserver.web.GeoServerBasePage;
import org.geoserver.web.demo.DemoRequest;
import org.geoserver.web.demo.DemoRequestResponse;
import org.geoserver.web.demo.PlainCodePage;
import org.geotools.xml.transform.TransformerBase;

public class WCSRequestBuilder
extends GeoServerBasePage {
    ModalWindow responseWindow;
    WCSRequestBuilderPanel builder;

    public WCSRequestBuilder() {
        Form form = new Form("form");
        this.add(new Component[]{form});
        this.builder = new WCSRequestBuilderPanel("requestBuilder", new GetCoverageRequest());
        form.add(new Component[]{this.builder});
        final ModalWindow xmlWindow = new ModalWindow("xmlWindow");
        this.add(new Component[]{xmlWindow});
        xmlWindow.setPageCreator(new ModalWindow.PageCreator(){

            public Page createPage() {
                return new PlainCodePage(xmlWindow, WCSRequestBuilder.this.responseWindow, WCSRequestBuilder.this.getRequestXML());
            }
        });
        this.responseWindow = new ModalWindow("responseWindow");
        this.add(new Component[]{this.responseWindow});
        this.responseWindow.setPageMapName("demoResponse");
        this.responseWindow.setCookieName("demoResponse");
        this.responseWindow.setPageCreator(new ModalWindow.PageCreator(){

            public Page createPage() {
                DemoRequest request = new DemoRequest(null);
                HttpServletRequest http = ((WebRequest)WCSRequestBuilder.this.getRequest()).getHttpServletRequest();
                String url = ResponseUtils.buildURL((String)ResponseUtils.baseURL((HttpServletRequest)http), (String)"ows", Collections.singletonMap("strict", "true"), (URLMangler.URLType)URLMangler.URLType.SERVICE);
                request.setRequestUrl(url);
                request.setRequestBody((String)WCSRequestBuilder.this.responseWindow.getDefaultModelObject());
                return new DemoRequestResponse((IModel)new Model((Serializable)request));
            }
        });
        form.add(new Component[]{new AjaxSubmitLink("execute"){

            protected void onSubmit(AjaxRequestTarget target, Form form) {
                WCSRequestBuilder.this.responseWindow.setDefaultModel((IModel)new Model((Serializable)((Object)WCSRequestBuilder.this.getRequestXML())));
                WCSRequestBuilder.this.responseWindow.show(target);
            }

            protected void onError(AjaxRequestTarget target, Form form) {
                super.onError(target, form);
                target.addComponent(WCSRequestBuilder.this.builder.getFeedbackPanel());
            }
        }});
        form.add(new Component[]{new AjaxSubmitLink("executeXML"){

            protected void onSubmit(AjaxRequestTarget target, Form form) {
                try {
                    WCSRequestBuilder.this.getRequestXML();
                    xmlWindow.show(target);
                }
                catch (Exception e) {
                    this.error((Serializable)((Object)e.getMessage()));
                    target.addComponent((Component)WCSRequestBuilder.this.getFeedbackPanel());
                }
            }

            protected void onError(AjaxRequestTarget target, Form form) {
                target.addComponent((Component)WCSRequestBuilder.this.getFeedbackPanel());
            }
        }});
    }

    String getRequestXML() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        TransformerBase tx = this.builder.getCoverage.version == GetCoverageRequest.Version.v1_0_0 ? new WCS10GetCoverageTransformer(this.getCatalog()) : new WCS11GetCoverageTransformer(this.getCatalog());
        try {
            tx.setIndentation(2);
            tx.transform((Object)this.builder.getCoverageRequest(), (OutputStream)out);
        }
        catch (TransformerException e) {
            LOGGER.log(Level.SEVERE, "Error generating xml request", e);
            this.error(e);
        }
        return out.toString();
    }
}

