/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs;

import java.io.File;
import org.geoserver.data.test.MockData;
import org.geoserver.wfs.WFSTestSupport;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class GetFeatureMissingTypesTest
extends WFSTestSupport {
    public void testPostMissingType10() throws Exception {
        File root = this.getTestData().getDataDirectoryRoot();
        File nsDirectory = new File(root, MockData.BUILDINGS.getPrefix());
        File buildings = new File(nsDirectory, String.valueOf(MockData.BUILDINGS.getLocalPart()) + ".properties");
        GetFeatureMissingTypesTest.assertTrue((boolean)buildings.delete());
        String xml = "<wfs:GetFeature service=\"WFS\" version=\"1.0.0\" xmlns:cdf=\"http://www.opengis.net/cite/data\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\" > <wfs:Query typeName=\"cdf:Other\"> <ogc:PropertyName>cdf:string2</ogc:PropertyName> </wfs:Query> </wfs:GetFeature>";
        Document doc = this.postAsDOM("wfs", xml);
        GetFeatureMissingTypesTest.assertEquals((String)"wfs:FeatureCollection", (String)doc.getDocumentElement().getNodeName());
        NodeList featureMembers = doc.getElementsByTagName("gml:featureMember");
        GetFeatureMissingTypesTest.assertFalse((featureMembers.getLength() == 0 ? 1 : 0) != 0);
        xml = "<wfs:GetFeature service=\"WFS\" version=\"1.0.0\" xmlns:cdf=\"http://www.opengis.net/cite/data\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\" > <wfs:Query typeName=\"" + this.getLayerId(MockData.BUILDINGS) + "\"/> " + "</wfs:GetFeature>";
        doc = this.postAsDOM("wfs", xml);
        GetFeatureMissingTypesTest.assertEquals((String)"ServiceExceptionReport", (String)doc.getDocumentElement().getNodeName());
    }

    public void testPostMissingType11() throws Exception {
        File root = this.getTestData().getDataDirectoryRoot();
        File nsDirectory = new File(root, MockData.BUILDINGS.getPrefix());
        File buildings = new File(nsDirectory, String.valueOf(MockData.BUILDINGS.getLocalPart()) + ".properties");
        GetFeatureMissingTypesTest.assertTrue((boolean)buildings.delete());
        String xml = "<wfs:GetFeature service=\"WFS\" version=\"1.1.0\" xmlns:cdf=\"http://www.opengis.net/cite/data\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\" > <wfs:Query typeName=\"cdf:Other\"> <wfs:PropertyName>cdf:string2</wfs:PropertyName> </wfs:Query> </wfs:GetFeature>";
        Document doc = this.postAsDOM("wfs", xml);
        GetFeatureMissingTypesTest.assertEquals((String)"wfs:FeatureCollection", (String)doc.getDocumentElement().getNodeName());
        xml = "<wfs:GetFeature service=\"WFS\" version=\"1.1.0\" xmlns:cdf=\"http://www.opengis.net/cite/data\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\" > <wfs:Query typeName=\"" + this.getLayerId(MockData.BUILDINGS) + "\"/> " + "</wfs:GetFeature>";
        doc = this.postAsDOM("wfs", xml);
        GetFeatureMissingTypesTest.assertEquals((String)"ows:ExceptionReport", (String)doc.getDocumentElement().getNodeName());
    }
}

