/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs;

import org.custommonkey.xmlunit.XMLAssert;
import org.geoserver.wfs.WFSTestSupport;
import org.w3c.dom.Document;

public class TransactionTest
extends WFSTestSupport {
    public void testDelete() throws Exception {
        String getFeature = "<wfs:GetFeature service=\"WFS\" version=\"1.0.0\" xmlns:cgf=\"http://www.opengis.net/cite/geometry\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\" > <wfs:Query typeName=\"cgf:Points\"> <ogc:PropertyName>cite:id</ogc:PropertyName> </wfs:Query> </wfs:GetFeature>";
        Document dom = this.postAsDOM("wfs", getFeature);
        TransactionTest.assertEquals((int)1, (int)dom.getElementsByTagName("gml:featureMember").getLength());
        String delete = "<wfs:Transaction service=\"WFS\" version=\"1.0.0\" xmlns:cgf=\"http://www.opengis.net/cite/geometry\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\"> <wfs:Delete typeName=\"cgf:Points\"> <ogc:Filter> <ogc:PropertyIsEqualTo> <ogc:PropertyName>cgf:id</ogc:PropertyName> <ogc:Literal>t0000</ogc:Literal> </ogc:PropertyIsEqualTo> </ogc:Filter> </wfs:Delete> </wfs:Transaction>";
        dom = this.postAsDOM("wfs", delete);
        TransactionTest.assertEquals((String)"WFS_TransactionResponse", (String)dom.getDocumentElement().getLocalName());
        TransactionTest.assertEquals((int)1, (int)dom.getElementsByTagName("wfs:SUCCESS").getLength());
        dom = this.postAsDOM("wfs", getFeature);
        TransactionTest.assertEquals((int)0, (int)dom.getElementsByTagName("gml:featureMember").getLength());
    }

    public void testDoubleDelete() throws Exception {
        String getFeature = "<wfs:GetFeature service=\"WFS\" version=\"1.0.0\" xmlns:cgf=\"http://www.opengis.net/cite/geometry\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\" > <wfs:Query typeName=\"cdf:Fifteen\"/> </wfs:GetFeature>";
        Document dom = this.postAsDOM("wfs", getFeature);
        this.print(dom);
        XMLAssert.assertXpathEvaluatesTo((String)"15", (String)"count(//gml:featureMember)", (Document)dom);
        String delete = "<wfs:Transaction service=\"WFS\" version=\"1.0.0\" xmlns:cgf=\"http://www.opengis.net/cite/geometry\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\"> <wfs:Delete typeName=\"cdf:Fifteen\"> <ogc:Filter> <ogc:FeatureId fid=\"Fifteen.1\"/> </ogc:Filter> </wfs:Delete> <wfs:Delete typeName=\"cdf:Fifteen\"> <ogc:Filter> <ogc:FeatureId fid=\"Fifteen.2\"/> </ogc:Filter> </wfs:Delete> </wfs:Transaction>";
        dom = this.postAsDOM("wfs", delete);
        TransactionTest.assertEquals((String)"WFS_TransactionResponse", (String)dom.getDocumentElement().getLocalName());
        TransactionTest.assertEquals((int)1, (int)dom.getElementsByTagName("wfs:SUCCESS").getLength());
        dom = this.postAsDOM("wfs", getFeature);
        XMLAssert.assertXpathEvaluatesTo((String)"13", (String)"count(//gml:featureMember)", (Document)dom);
    }

    public void testInsert() throws Exception {
        String getFeature = "<wfs:GetFeature service=\"WFS\" version=\"1.0.0\" xmlns:cgf=\"http://www.opengis.net/cite/geometry\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\" > <wfs:Query typeName=\"cgf:Lines\"> <ogc:PropertyName>cite:id</ogc:PropertyName> </wfs:Query> </wfs:GetFeature>";
        Document dom = this.postAsDOM("wfs", getFeature);
        TransactionTest.assertEquals((int)1, (int)dom.getElementsByTagName("gml:featureMember").getLength());
        String insert = "<wfs:Transaction service=\"WFS\" version=\"1.0.0\" xmlns:cgf=\"http://www.opengis.net/cite/geometry\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:gml=\"http://www.opengis.net/gml\"> <wfs:Insert > <cgf:Lines><cgf:lineStringProperty><gml:LineString><gml:coordinates decimal=\".\" cs=\",\" ts=\" \">494475.71056415,5433016.8189323 494982.70115662,5435041.95096618</gml:coordinates></gml:LineString></cgf:lineStringProperty><cgf:id>t0002</cgf:id></cgf:Lines></wfs:Insert></wfs:Transaction>";
        dom = this.postAsDOM("wfs", insert);
        TransactionTest.assertTrue((dom.getElementsByTagName("wfs:SUCCESS").getLength() != 0 ? 1 : 0) != 0);
        TransactionTest.assertTrue((dom.getElementsByTagName("wfs:InsertResult").getLength() != 0 ? 1 : 0) != 0);
        dom = this.postAsDOM("wfs", getFeature);
        TransactionTest.assertEquals((int)2, (int)dom.getElementsByTagName("gml:featureMember").getLength());
    }

    public void testUpdate() throws Exception {
        String getFeature = "<wfs:GetFeature service=\"WFS\" version=\"1.0.0\" xmlns:cgf=\"http://www.opengis.net/cite/geometry\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\" > <wfs:Query typeName=\"cgf:Polygons\"> <ogc:PropertyName>cite:id</ogc:PropertyName> </wfs:Query> </wfs:GetFeature>";
        Document dom = this.postAsDOM("wfs", getFeature);
        TransactionTest.assertEquals((int)1, (int)dom.getElementsByTagName("gml:featureMember").getLength());
        TransactionTest.assertEquals((String)"t0002", (String)dom.getElementsByTagName("cgf:id").item(0).getFirstChild().getNodeValue());
        String insert = "<wfs:Transaction service=\"WFS\" version=\"1.0.0\" xmlns:cgf=\"http://www.opengis.net/cite/geometry\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:gml=\"http://www.opengis.net/gml\"> <wfs:Update typeName=\"cgf:Polygons\" > <wfs:Property><wfs:Name>id</wfs:Name><wfs:Value>t0003</wfs:Value></wfs:Property><ogc:Filter><ogc:PropertyIsEqualTo><ogc:PropertyName>id</ogc:PropertyName><ogc:Literal>t0002</ogc:Literal></ogc:PropertyIsEqualTo></ogc:Filter></wfs:Update></wfs:Transaction>";
        dom = this.postAsDOM("wfs", insert);
        dom = this.postAsDOM("wfs", getFeature);
        TransactionTest.assertEquals((String)"t0003", (String)dom.getElementsByTagName("cgf:id").item(0).getFirstChild().getNodeValue());
    }

    public void testInsertWithBoundedBy() throws Exception {
        String xml = "<wfs:Transaction service=\"WFS\" version=\"1.0.0\"  xmlns:wfs=\"http://www.opengis.net/wfs\"  xmlns:gml=\"http://www.opengis.net/gml\"  xmlns:cite=\"http://www.opengis.net/cite\"><wfs:Insert> <cite:BasicPolygons><gml:boundedBy><gml:Box><gml:coordinates cs=\",\" decimal=\".\" ts=\" \">-2,-1 2,6</gml:coordinates></gml:Box></gml:boundedBy>  <cite:the_geom><gml:MultiPolygon><gml:polygonMember><gml:Polygon><gml:outerBoundaryIs><gml:LinearRing><gml:coordinates cs=\",\" decimal=\".\" ts=\" \">-1,0 0,1 1,0 0,-1 -1,0</gml:coordinates></gml:LinearRing></gml:outerBoundaryIs></gml:Polygon></gml:polygonMember></gml:MultiPolygon>  </cite:the_geom>  <cite:ID>foo</cite:ID> </cite:BasicPolygons></wfs:Insert></wfs:Transaction>";
        Document dom = this.postAsDOM("wfs", xml);
        TransactionTest.assertEquals((String)"wfs:WFS_TransactionResponse", (String)dom.getDocumentElement().getNodeName());
        TransactionTest.assertTrue((dom.getElementsByTagName("ogc:FeatureId").getLength() > 0 ? 1 : 0) != 0);
        TransactionTest.assertTrue((dom.getElementsByTagName("wfs:SUCCESS").getLength() > 0 ? 1 : 0) != 0);
    }

    public void testUpdateWithDifferentPrefix() throws Exception {
        String getFeature = "<wfs:GetFeature service=\"WFS\" version=\"1.0.0\" xmlns:cgf=\"http://www.opengis.net/cite/geometry\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\" > <wfs:Query typeName=\"cgf:Polygons\"> <ogc:PropertyName>cite:id</ogc:PropertyName> </wfs:Query> </wfs:GetFeature>";
        Document dom = this.postAsDOM("wfs", getFeature);
        TransactionTest.assertEquals((int)1, (int)dom.getElementsByTagName("gml:featureMember").getLength());
        TransactionTest.assertEquals((String)"t0002", (String)dom.getElementsByTagName("cgf:id").item(0).getFirstChild().getNodeValue());
        String update = "<wfs:Transaction service=\"WFS\" version=\"1.0.0\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:gml=\"http://www.opengis.net/gml\"> <wfs:Update xmlns:foo=\"http://www.opengis.net/cite/geometry\" typeName=\"foo:Polygons\" > <wfs:Property><wfs:Name>id</wfs:Name><wfs:Value>t0003</wfs:Value></wfs:Property><ogc:Filter><ogc:PropertyIsEqualTo><ogc:PropertyName>id</ogc:PropertyName><ogc:Literal>t0002</ogc:Literal></ogc:PropertyIsEqualTo></ogc:Filter></wfs:Update></wfs:Transaction>";
        dom = this.postAsDOM("wfs", update);
        dom = this.postAsDOM("wfs", getFeature);
        TransactionTest.assertEquals((String)"t0003", (String)dom.getElementsByTagName("cgf:id").item(0).getFirstChild().getNodeValue());
    }
}

