/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.response;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import javax.xml.parsers.DocumentBuilderFactory;
import org.geoserver.wfs.WFSTestSupport;
import org.geoserver.wfs.response.WfsXmlWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class WfsXmlWriterTest
extends WFSTestSupport {
    public void test() throws Exception {
        File tmp = File.createTempFile("wfs", "xml");
        tmp.deleteOnExit();
        WfsXmlWriter.WFS1_0 writer = new WfsXmlWriter.WFS1_0(this.getWFS(), (OutputStream)new FileOutputStream(tmp));
        writer.openTag("wfs", "FeatureCollection");
        writer.openTag("gml", "Feature", new String[]{"id", "foo", "srs", "4326"});
        writer.text("some text");
        writer.closeTag("gml", "Feature");
        writer.closeTag("wfs", "FeatureCollection");
        writer.close();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        Document doc = factory.newDocumentBuilder().parse(tmp);
        WfsXmlWriterTest.assertNotNull((Object)doc);
        WfsXmlWriterTest.assertEquals((String)"wfs:FeatureCollection", (String)doc.getDocumentElement().getNodeName());
        NodeList features = doc.getElementsByTagName("gml:Feature");
        WfsXmlWriterTest.assertEquals((int)1, (int)features.getLength());
        Element feature = (Element)features.item(0);
        WfsXmlWriterTest.assertEquals((String)"foo", (String)feature.getAttribute("id"));
        WfsXmlWriterTest.assertEquals((String)"4326", (String)feature.getAttribute("srs"));
    }
}

