/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.v1_1;

import junit.framework.Test;
import org.custommonkey.xmlunit.XMLAssert;
import org.custommonkey.xmlunit.XMLUnit;
import org.custommonkey.xmlunit.XpathEngine;
import org.geoserver.config.ServiceInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.test.OneTimeSetupTest;
import org.geoserver.wfs.WFSInfo;
import org.geoserver.wfs.WFSTestSupport;
import org.w3c.dom.Document;

public class GetFeatureBboxTest
extends WFSTestSupport {
    public static Test suite() {
        return new OneTimeSetupTest.OneTimeTestSetup((OneTimeSetupTest)new GetFeatureBboxTest());
    }

    public void testFeatureBoudingOn() throws Exception {
        WFSInfo wfs = this.getWFS();
        wfs.setFeatureBounding(true);
        this.getGeoServer().save((ServiceInfo)wfs);
        Document doc = this.getAsDOM("wfs?request=GetFeature&typeName=" + this.getLayerId(MockData.BUILDINGS) + "&version=1.1.0&service=wfs&propertyName=ADDRESS");
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wfs:FeatureCollection)", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wfs:FeatureCollection/gml:boundedBy/gml:Envelope)", (Document)doc);
        XpathEngine xpath = XMLUnit.newXpathEngine();
        GetFeatureBboxTest.assertTrue((xpath.getMatchingNodes("//cite:Buildings/gml:boundedBy/gml:Envelope", doc).getLength() > 0 ? 1 : 0) != 0);
    }

    public void testFeatureBoudingOff() throws Exception {
        WFSInfo wfs = this.getWFS();
        wfs.setFeatureBounding(false);
        this.getGeoServer().save((ServiceInfo)wfs);
        Document doc = this.getAsDOM("wfs?request=GetFeature&typeName=" + this.getLayerId(MockData.BUILDINGS) + "&version=1.1.0&service=wfs&propertyName=ADDRESS");
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wfs:FeatureCollection)", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"count(//wfs:FeatureCollection/gml:boundedBy)", (Document)doc);
    }
}

