/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.v1_1;

import junit.framework.Test;
import net.opengis.ows10.Ows10Factory;
import net.opengis.wfs.GetCapabilitiesType;
import net.opengis.wfs.WfsFactory;
import org.geoserver.test.OneTimeSetupTest;
import org.geoserver.wfs.CapabilitiesTransformer;
import org.geoserver.wfs.GetCapabilities;
import org.geoserver.wfs.WFSTestSupport;

public class VersionNegotiationTest
extends WFSTestSupport {
    static GetCapabilities getCaps;
    static WfsFactory factory;
    static Ows10Factory owsFactory;

    public static Test suite() {
        return new OneTimeSetupTest.OneTimeTestSetup((OneTimeSetupTest)new VersionNegotiationTest());
    }

    protected void oneTimeSetUp() throws Exception {
        super.oneTimeSetUp();
        getCaps = new GetCapabilities(this.getWFS(), this.getCatalog());
        factory = WfsFactory.eINSTANCE;
        owsFactory = Ows10Factory.eINSTANCE;
    }

    public void test0() throws Exception {
        GetCapabilitiesType request = factory.createGetCapabilitiesType();
        request.setService("WFS");
        request.setAcceptVersions(owsFactory.createAcceptVersionsType());
        request.getAcceptVersions().getVersion().add((Object)"1.0.0");
        request.getAcceptVersions().getVersion().add((Object)"1.1.0");
        CapabilitiesTransformer tx = getCaps.run(request);
        VersionNegotiationTest.assertTrue((boolean)(tx instanceof CapabilitiesTransformer.WFS1_1));
    }

    public void test1() throws Exception {
        GetCapabilitiesType request = factory.createGetCapabilitiesType();
        request.setService("WFS");
        request.setAcceptVersions(owsFactory.createAcceptVersionsType());
        request.getAcceptVersions().getVersion().add((Object)"1.0.0");
        CapabilitiesTransformer tx = getCaps.run(request);
        VersionNegotiationTest.assertTrue((boolean)(tx instanceof CapabilitiesTransformer.WFS1_0));
    }

    public void test2() throws Exception {
        GetCapabilitiesType request = factory.createGetCapabilitiesType();
        request.setService("WFS");
        request.setAcceptVersions(owsFactory.createAcceptVersionsType());
        request.getAcceptVersions().getVersion().add((Object)"1.1.0");
        CapabilitiesTransformer tx = getCaps.run(request);
        VersionNegotiationTest.assertTrue((boolean)(tx instanceof CapabilitiesTransformer.WFS1_1));
    }

    public void test5() throws Exception {
        GetCapabilitiesType request = factory.createGetCapabilitiesType();
        request.setService("WFS");
        request.setAcceptVersions(owsFactory.createAcceptVersionsType());
        request.getAcceptVersions().getVersion().add((Object)"0.0.0");
        CapabilitiesTransformer tx = getCaps.run(request);
        VersionNegotiationTest.assertTrue((boolean)(tx instanceof CapabilitiesTransformer.WFS1_0));
    }

    public void test6() throws Exception {
        GetCapabilitiesType request = factory.createGetCapabilitiesType();
        request.setService("WFS");
        request.setAcceptVersions(owsFactory.createAcceptVersionsType());
        request.getAcceptVersions().getVersion().add((Object)"1.1.1");
        CapabilitiesTransformer tx = getCaps.run(request);
        VersionNegotiationTest.assertTrue((boolean)(tx instanceof CapabilitiesTransformer.WFS1_1));
    }

    public void test7() throws Exception {
        GetCapabilitiesType request = factory.createGetCapabilitiesType();
        request.setService("WFS");
        request.setAcceptVersions(owsFactory.createAcceptVersionsType());
        request.getAcceptVersions().getVersion().add((Object)"1.0.5");
        CapabilitiesTransformer tx = getCaps.run(request);
        VersionNegotiationTest.assertTrue((boolean)(tx instanceof CapabilitiesTransformer.WFS1_0));
    }
}

