/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs;

import java.util.Collections;
import javax.xml.namespace.QName;
import junit.framework.Test;
import org.custommonkey.xmlunit.XMLAssert;
import org.custommonkey.xmlunit.XMLUnit;
import org.custommonkey.xmlunit.XpathEngine;
import org.geoserver.config.ServiceInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.test.OneTimeSetupTest;
import org.geoserver.wfs.ReprojectionTest;
import org.geoserver.wfs.WFSInfo;
import org.geoserver.wfs.WFSTestSupport;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class GetFeatureTest
extends WFSTestSupport {
    public static QName NULL_GEOMETRIES = new QName(MockData.CITE_URI, "NullGeometries", MockData.CITE_PREFIX);

    protected void populateDataDirectory(MockData dataDirectory) throws Exception {
        super.populateDataDirectory(dataDirectory);
        dataDirectory.addPropertiesType(NULL_GEOMETRIES, ReprojectionTest.class.getResource("NullGeometries.properties"), Collections.EMPTY_MAP);
    }

    protected void oneTimeSetUp() throws Exception {
        super.oneTimeSetUp();
        WFSInfo wfs = this.getWFS();
        wfs.setFeatureBounding(true);
        this.getGeoServer().save((ServiceInfo)wfs);
    }

    public static Test suite() {
        return new OneTimeSetupTest.OneTimeTestSetup((OneTimeSetupTest)new GetFeatureTest());
    }

    public void testGet() throws Exception {
        this.testGetFifteenAll("wfs?request=GetFeature&typename=cdf:Fifteen&version=1.0.0&service=wfs");
    }

    public void testGetPropertyNameEmpty() throws Exception {
        this.testGetFifteenAll("wfs?request=GetFeature&typename=cdf:Fifteen&version=1.0.0&service=wfs&propertyname=");
    }

    public void testGetPropertyNameStar() throws Exception {
        this.testGetFifteenAll("wfs?request=GetFeature&typename=cdf:Fifteen&version=1.0.0&service=wfs&propertyname=*");
    }

    private void testGetFifteenAll(String request) throws Exception {
        Document doc = this.getAsDOM(request);
        GetFeatureTest.assertEquals((String)"wfs:FeatureCollection", (String)doc.getDocumentElement().getNodeName());
        NodeList featureMembers = doc.getElementsByTagName("gml:featureMember");
        GetFeatureTest.assertEquals((int)15, (int)featureMembers.getLength());
    }

    public void testGetMissingParams() throws Exception {
        Document doc = this.getAsDOM("wfs?request=GetFeature&typeNameWrongParam=cdf:Fifteen&version=1.0.0&service=wfs");
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//ogc:ServiceException)", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"MissingParameterValue", (String)"//ogc:ServiceException/@code", (Document)doc);
    }

    public void testAlienNamespace() throws Exception {
        Document doc = this.getAsDOM("wfs?request=GetFeature&typename=youdontknowme:Fifteen&version=1.0.0&service=wfs");
        GetFeatureTest.assertEquals((String)"ServiceExceptionReport", (String)doc.getDocumentElement().getNodeName());
    }

    public void testGetNullGeometies() throws Exception {
        Document doc = this.getAsDOM("wfs?request=GetFeature&typeName=" + this.getLayerId(NULL_GEOMETRIES) + "&version=1.0.0&service=wfs");
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//cite:NullGeometries[@fid=\"NullGeometries.1107531701010\"]/gml:boundedBy)", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"count(//cite:NullGeometries[@fid=\"NullGeometries.1107531701011\"]/boundedBy)", (Document)doc);
    }

    public void testGetWithFeatureId() throws Exception {
        Document doc = this.getAsDOM("wfs?request=GetFeature&typeName=cdf:Fifteen&version=1.0.0&service=wfs&featureid=Fifteen.2");
        GetFeatureTest.assertEquals((String)"wfs:FeatureCollection", (String)doc.getDocumentElement().getNodeName());
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wfs:FeatureCollection/gml:featureMember)", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"Fifteen.2", (String)"//wfs:FeatureCollection/gml:featureMember/cdf:Fifteen/@fid", (Document)doc);
        doc = this.getAsDOM("wfs?request=GetFeature&typeName=cite:NamedPlaces&version=1.0.0&service=wfs&featureId=NamedPlaces.1107531895891");
        GetFeatureTest.assertEquals((String)"wfs:FeatureCollection", (String)doc.getDocumentElement().getNodeName());
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wfs:FeatureCollection/gml:featureMember)", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"NamedPlaces.1107531895891", (String)"//wfs:FeatureCollection/gml:featureMember/cite:NamedPlaces/@fid", (Document)doc);
    }

    public void testPost() throws Exception {
        String xml = "<wfs:GetFeature service=\"WFS\" version=\"1.0.0\" xmlns:cdf=\"http://www.opengis.net/cite/data\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\" > <wfs:Query typeName=\"cdf:Other\"> <ogc:PropertyName>cdf:string2</ogc:PropertyName> </wfs:Query> </wfs:GetFeature>";
        Document doc = this.postAsDOM("wfs", xml);
        GetFeatureTest.assertEquals((String)"wfs:FeatureCollection", (String)doc.getDocumentElement().getNodeName());
        NodeList featureMembers = doc.getElementsByTagName("gml:featureMember");
        GetFeatureTest.assertFalse((featureMembers.getLength() == 0 ? 1 : 0) != 0);
    }

    public void testPostWithFilter() throws Exception {
        String xml = "<wfs:GetFeature service=\"WFS\" version=\"1.0.0\" outputFormat=\"GML2\" xmlns:cdf=\"http://www.opengis.net/cite/data\" xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:ogc=\"http://www.opengis.net/ogc\" > <wfs:Query typeName=\"cdf:Other\"> <ogc:PropertyName>cdf:string2</ogc:PropertyName> <ogc:Filter> <ogc:PropertyIsEqualTo> <ogc:PropertyName>cdf:integers</ogc:PropertyName> <ogc:Add> <ogc:Literal>4</ogc:Literal> <ogc:Literal>3</ogc:Literal> </ogc:Add> </ogc:PropertyIsEqualTo> </ogc:Filter> </wfs:Query> </wfs:GetFeature>";
        Document doc = this.postAsDOM("wfs", xml);
        GetFeatureTest.assertEquals((String)"wfs:FeatureCollection", (String)doc.getDocumentElement().getNodeName());
        NodeList featureMembers = doc.getElementsByTagName("gml:featureMember");
        GetFeatureTest.assertFalse((featureMembers.getLength() == 0 ? 1 : 0) != 0);
    }

    public void testLax() throws Exception {
        String xml = "<GetFeature xmlns:gml=\"http://www.opengis.net/gml\"> <Query typeName=\"" + MockData.BUILDINGS.getLocalPart() + "\">" + "   <PropertyName>ADDRESS</PropertyName>" + "   <Filter>" + "     <PropertyIsEqualTo>" + "       <PropertyName>ADDRESS</PropertyName>" + "       <Literal>123 Main Street</Literal>" + "     </PropertyIsEqualTo>" + "   </Filter>" + " </Query>" + "</GetFeature>";
        Document doc = this.postAsDOM("wfs", xml);
        GetFeatureTest.assertEquals((String)"wfs:FeatureCollection", (String)doc.getDocumentElement().getNodeName());
        NodeList featureMembers = doc.getElementsByTagName("cite:Buildings");
        GetFeatureTest.assertEquals((int)1, (int)featureMembers.getLength());
    }

    public void testMixed() throws Exception {
        String xml = "<wfs:GetFeature service=\"WFS\" version=\"1.0.0\" xmlns:cdf=\"http://www.opengis.net/cite/data\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\" > <wfs:Query typeName=\"cdf:Other\"> <ogc:PropertyName>cdf:string2</ogc:PropertyName> </wfs:Query> </wfs:GetFeature>";
        Document doc = this.postAsDOM("wfs?request=GetFeature", xml);
        GetFeatureTest.assertEquals((String)"wfs:FeatureCollection", (String)doc.getDocumentElement().getNodeName());
        NodeList featureMembers = doc.getElementsByTagName("gml:featureMember");
        GetFeatureTest.assertFalse((featureMembers.getLength() == 0 ? 1 : 0) != 0);
    }

    public void testLikeMatchCase() throws Exception {
        String xml = "<GetFeature xmlns:gml=\"http://www.opengis.net/gml\"> <Query typeName=\"" + MockData.BUILDINGS.getLocalPart() + "\">" + "   <PropertyName>ADDRESS</PropertyName>" + "   <Filter>" + "     <PropertyIsLike wildCard=\"*\" singleChar=\".\" escapeChar=\"\\\" matchCase=\"false\">" + "       <PropertyName>ADDRESS</PropertyName>" + "       <Literal>* MAIN STREET</Literal>" + "     </PropertyIsLike>" + "   </Filter>" + " </Query>" + "</GetFeature>";
        Document doc = this.postAsDOM("wfs", xml);
        GetFeatureTest.assertEquals((String)"wfs:FeatureCollection", (String)doc.getDocumentElement().getNodeName());
        NodeList featureMembers = doc.getElementsByTagName("cite:Buildings");
        GetFeatureTest.assertEquals((int)2, (int)featureMembers.getLength());
        xml = "<GetFeature xmlns:gml=\"http://www.opengis.net/gml\"> <Query typeName=\"" + MockData.BUILDINGS.getLocalPart() + "\">" + "   <PropertyName>ADDRESS</PropertyName>" + "   <Filter>" + "     <PropertyIsLike wildCard=\"*\" singleChar=\".\" escapeChar=\"\\\" matchCase=\"true\">" + "       <PropertyName>ADDRESS</PropertyName>" + "       <Literal>* MAIN STREET</Literal>" + "     </PropertyIsLike>" + "   </Filter>" + " </Query>" + "</GetFeature>";
        doc = this.postAsDOM("wfs", xml);
        GetFeatureTest.assertEquals((String)"wfs:FeatureCollection", (String)doc.getDocumentElement().getNodeName());
        featureMembers = doc.getElementsByTagName("cite:Buildings");
        GetFeatureTest.assertEquals((int)0, (int)featureMembers.getLength());
    }

    public void testWorkspaceQualified() throws Exception {
        this.testGetFifteenAll("cdf/wfs?request=GetFeature&typename=cdf:Fifteen&version=1.0.0&service=wfs");
        this.testGetFifteenAll("cdf/wfs?request=GetFeature&typename=Fifteen&version=1.0.0&service=wfs");
        Document doc = this.getAsDOM("sf/wfs?request=GetFeature&typename=cdf:Fifteen&version=1.0.0&service=wfs");
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//ogc:ServiceException)", (Document)doc);
    }

    public void testLayerQualified() throws Exception {
        this.testGetFifteenAll("cdf/Fifteen/wfs?request=GetFeature&typename=cdf:Fifteen&version=1.0.0&service=wfs");
        this.testGetFifteenAll("cdf/Fifteen/wfs?request=GetFeature&typename=Fifteen&version=1.0.0&service=wfs");
        Document doc = this.getAsDOM("sf/Fifteen/wfs?request=GetFeature&typename=cdf:Seven&version=1.0.0&service=wfs");
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//ogc:ServiceException)", (Document)doc);
    }

    public void testMultiLayer() throws Exception {
        Document doc = this.getAsDOM("/wfs?request=GetFeature&typename=" + this.getLayerId(MockData.BASIC_POLYGONS) + "," + this.getLayerId(MockData.BRIDGES) + "&version=1.0.0&service=wfs");
        XpathEngine engine = XMLUnit.newXpathEngine();
        String schemaLocation = engine.evaluate("wfs:FeatureCollection/@xsi:schemaLocation", doc);
        GetFeatureTest.assertNotNull((Object)schemaLocation);
        String[] parsedLocations = schemaLocation.split("\\s+");
        int i = 0;
        while (i < parsedLocations.length) {
            if (parsedLocations[i].equals("http://www.opengis.net/cite")) {
                GetFeatureTest.assertEquals((String)"http://localhost:8080/geoserver/wfs?service=WFS&version=1.0.0&request=DescribeFeatureType&typeName=cite%3ABasicPolygons,cite%3ABridges", (String)parsedLocations[i + 1]);
                break;
            }
            i += 2;
        }
        if (i >= parsedLocations.length) {
            GetFeatureTest.fail((String)"Could not find the http://www.opengis.net/cite schema location!");
        }
    }
}

