/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.xml;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.opengis.wfs.BaseRequestType;
import net.opengis.wfs.FeatureCollectionType;
import net.opengis.wfs.GetFeatureType;
import net.opengis.wfs.QueryType;
import org.eclipse.emf.common.util.EList;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.ows.URLMangler;
import org.geoserver.ows.util.OwsUtils;
import org.geoserver.ows.util.ResponseUtils;
import org.geoserver.platform.Operation;
import org.geoserver.platform.ServiceException;
import org.geoserver.wfs.WFSException;
import org.geoserver.wfs.WFSGetFeatureOutputFormat;
import org.geoserver.wfs.WFSInfo;
import org.geoserver.wfs.xml.v1_1_0.WFS;
import org.geoserver.wfs.xml.v1_1_0.WFSConfiguration;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.NameImpl;
import org.geotools.feature.simple.SimpleFeatureTypeImpl;
import org.geotools.gml3.GMLConfiguration;
import org.geotools.xml.Configuration;
import org.geotools.xml.Encoder;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.Name;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GML3OutputFormat
extends WFSGetFeatureOutputFormat {
    GeoServer geoServer;
    Catalog catalog;
    GeoServerInfo global;
    WFSConfiguration configuration;
    protected static DOMSource xslt;

    static {
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        docFactory.setNamespaceAware(true);
        Document xsdDocument = null;
        try {
            xsdDocument = docFactory.newDocumentBuilder().parse(GML3OutputFormat.class.getResourceAsStream("/ChangeNumberOfFeature.xslt"));
            xslt = new DOMSource(xsdDocument);
        }
        catch (Exception e) {
            xslt = null;
        }
    }

    public GML3OutputFormat(GeoServer geoServer, WFSConfiguration configuration) {
        this(new HashSet<Object>(Arrays.asList("gml3", "text/xml; subtype=gml/3.1.1")), geoServer, configuration);
    }

    public GML3OutputFormat(Set<String> outputFormats, GeoServer geoServer, WFSConfiguration configuration) {
        super(geoServer, outputFormats);
        this.geoServer = geoServer;
        this.catalog = geoServer.getCatalog();
        this.global = geoServer.getGlobal();
        this.configuration = configuration;
    }

    @Override
    public String getMimeType(Object value, Operation operation) {
        return "text/xml; subtype=gml/3.1.1";
    }

    @Override
    public String getCapabilitiesElementName() {
        return "GML3";
    }

    @Override
    protected void write(FeatureCollectionType results, OutputStream output, Operation getFeature) throws ServiceException, IOException, UnsupportedEncodingException {
        Set<FeatureTypeInfo> metas;
        EList featureCollections = results.getFeature();
        HashMap<String, Set<FeatureTypeInfo>> ns2metas = new HashMap<String, Set<FeatureTypeInfo>>();
        int fcIndex = 0;
        while (fcIndex < featureCollections.size()) {
            if (getFeature.getParameters()[0] instanceof GetFeatureType) {
                GetFeatureType request = (GetFeatureType)OwsUtils.parameter((Object[])getFeature.getParameters(), GetFeatureType.class);
                QueryType queryType = (QueryType)request.getQuery().get(fcIndex);
                for (QName name : queryType.getTypeName()) {
                    NameImpl featureTypeName = new NameImpl(name.getNamespaceURI(), name.getLocalPart());
                    FeatureTypeInfo meta = this.catalog.getFeatureTypeByName((Name)featureTypeName);
                    if (meta == null) {
                        throw new WFSException("Could not find feature type " + featureTypeName + " in the GeoServer catalog");
                    }
                    metas = ns2metas.get(featureTypeName.getNamespaceURI());
                    if (metas == null) {
                        metas = new HashSet<FeatureTypeInfo>();
                        ns2metas.put(featureTypeName.getNamespaceURI(), metas);
                    }
                    metas.add(meta);
                }
            } else {
                FeatureType featureType = ((FeatureCollection)featureCollections.get(fcIndex)).getSchema();
                String namespaceURI = featureType.getName().getNamespaceURI();
                FeatureTypeInfo meta = this.catalog.getFeatureTypeByName(featureType.getName());
                if (meta == null) {
                    throw new WFSException("Could not find feature type " + featureType.getName() + " in the GeoServer catalog");
                }
                HashSet<FeatureTypeInfo> metas2 = (HashSet<FeatureTypeInfo>)ns2metas.get(namespaceURI);
                if (metas2 == null) {
                    metas2 = new HashSet<FeatureTypeInfo>();
                    ns2metas.put(namespaceURI, metas2);
                }
                metas2.add(meta);
            }
            ++fcIndex;
        }
        WFSInfo wfs = this.getInfo();
        if (wfs.isFeatureBounding()) {
            this.configuration.getProperties().remove(GMLConfiguration.NO_FEATURE_BOUNDS);
        } else {
            this.configuration.getProperties().add(GMLConfiguration.NO_FEATURE_BOUNDS);
        }
        if (wfs.isEncodeFeatureMember()) {
            this.configuration.getProperties().add(GMLConfiguration.ENCODE_FEATURE_MEMBER);
        } else {
            this.configuration.getProperties().remove(GMLConfiguration.ENCODE_FEATURE_MEMBER);
        }
        BaseRequestType gft = (BaseRequestType)getFeature.getParameters()[0];
        Encoder encoder = this.createEncoder(this.configuration, ns2metas, gft);
        encoder.setEncoding(Charset.forName(this.global.getCharset()));
        if (wfs.isCanonicalSchemaLocation()) {
            encoder.setSchemaLocation("http://www.opengis.net/wfs", "http://schemas.opengis.net/wfs/1.1.0/wfs.xsd");
        } else {
            encoder.setSchemaLocation("http://www.opengis.net/wfs", ResponseUtils.buildSchemaURL((String)gft.getBaseUrl(), (String)"wfs/1.1.0/wfs.xsd"));
        }
        Map params = ResponseUtils.params((String[])new String[]{"service", "WFS", "version", "1.1.0", "request", "DescribeFeatureType"});
        for (Map.Entry<String, Set<FeatureTypeInfo>> entry : ns2metas.entrySet()) {
            String namespaceURI = entry.getKey();
            metas = entry.getValue();
            StringBuffer typeNames = new StringBuffer();
            Iterator<FeatureTypeInfo> m = metas.iterator();
            while (m.hasNext()) {
                FeatureTypeInfo meta = m.next();
                FeatureType featureType = meta.getFeatureType();
                Object userSchemaLocation = featureType.getUserData().get("schemaURI");
                if (userSchemaLocation != null && userSchemaLocation instanceof Map) {
                    Map schemaURIs = (Map)userSchemaLocation;
                    for (String namespace : schemaURIs.keySet()) {
                        encoder.setSchemaLocation(namespace, (String)schemaURIs.get(namespace));
                    }
                    continue;
                }
                typeNames.append(meta.getPrefixedName());
                if (!m.hasNext()) continue;
                typeNames.append(",");
            }
            if (typeNames.length() <= 0) continue;
            params.put("typeName", typeNames.toString());
            String schemaLocation = ResponseUtils.buildURL((String)gft.getBaseUrl(), (String)"wfs", (Map)params, (URLMangler.URLType)URLMangler.URLType.SERVICE);
            LOGGER.finer("Unable to find user-defined schema location for: " + namespaceURI + ". Using a built schema location by default: " + schemaLocation);
            encoder.setSchemaLocation(namespaceURI, schemaLocation);
        }
        if (GML3OutputFormat.isComplexFeature(results)) {
            this.complexFeatureStreamIntercept(results, output, encoder);
        } else {
            this.encode(results, output, encoder);
        }
    }

    protected Encoder createEncoder(Configuration configuration, Map<String, Set<FeatureTypeInfo>> featureTypes, BaseRequestType request) {
        return new Encoder(configuration, configuration.schema());
    }

    protected void encode(FeatureCollectionType results, OutputStream output, Encoder encoder) throws IOException {
        encoder.encode((Object)results, WFS.FEATURECOLLECTION, output);
    }

    private void complexFeatureStreamIntercept(FeatureCollectionType results, OutputStream output, Encoder encoder) throws IOException {
        if (xslt == null) {
            throw new IOException("Unable to locate xslt resource file");
        }
        File featureOut = File.createTempFile(String.valueOf(output.hashCode()) + "_dump", ".xml");
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(featureOut));
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(featureOut));
        try {
            try {
                this.encode(results, out, encoder);
                this.transform(in, xslt, output);
            }
            catch (TransformerException e) {
                throw (IOException)new IOException(e.getMessage()).initCause(e);
            }
        }
        finally {
            out.close();
            in.close();
            featureOut.delete();
        }
    }

    public static boolean isComplexFeature(FeatureCollectionType results) {
        boolean hasComplex = false;
        int fcIndex = 0;
        while (fcIndex < results.getFeature().size()) {
            if (!(((FeatureCollection)results.getFeature().get(fcIndex)).getSchema() instanceof SimpleFeatureTypeImpl)) {
                hasComplex = true;
                break;
            }
            ++fcIndex;
        }
        return hasComplex;
    }

    public void transform(InputStream in, DOMSource xslt, OutputStream out) throws TransformerException {
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer transformer = xslt == null ? factory.newTransformer() : factory.newTransformer(xslt);
        transformer.setErrorListener(new TransformerErrorListener());
        transformer.transform(new StreamSource(in), new StreamResult(out));
    }

    private class TransformerErrorListener
    implements ErrorListener {
        private TransformerErrorListener() {
        }

        public void error(TransformerException exception) throws TransformerException {
            throw exception;
        }

        public void fatalError(TransformerException exception) throws TransformerException {
            throw exception;
        }

        public void warning(TransformerException exception) throws TransformerException {
            throw exception;
        }
    }
}

