/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs;

import junit.framework.Test;
import org.geoserver.config.ServiceInfo;
import org.geoserver.test.OneTimeSetupTest;
import org.geoserver.wfs.WFSInfo;
import org.geoserver.wfs.WFSTestSupport;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SrsNameTest
extends WFSTestSupport {
    public static Test suite() {
        return new OneTimeSetupTest.OneTimeTestSetup((OneTimeSetupTest)new SrsNameTest());
    }

    protected void oneTimeSetUp() throws Exception {
        super.oneTimeSetUp();
        WFSInfo wfs = this.getWFS();
        wfs.setFeatureBounding(true);
        this.getGeoServer().save((ServiceInfo)wfs);
    }

    public void testWfs10() throws Exception {
        String q = "wfs?request=getfeature&service=wfs&version=1.0.0&typename=cgf:Points";
        Document d = this.getAsDOM(q);
        SrsNameTest.assertEquals((String)"wfs:FeatureCollection", (String)d.getDocumentElement().getNodeName());
        NodeList boxes = d.getElementsByTagName("gml:Box");
        SrsNameTest.assertFalse((boxes.getLength() == 0 ? 1 : 0) != 0);
        int i = 0;
        while (i < boxes.getLength()) {
            Element box = (Element)boxes.item(i);
            SrsNameTest.assertEquals((String)"http://www.opengis.net/gml/srs/epsg.xml#32615", (String)box.getAttribute("srsName"));
            ++i;
        }
        NodeList points = d.getElementsByTagName("gml:Point");
        SrsNameTest.assertFalse((points.getLength() == 0 ? 1 : 0) != 0);
        int i2 = 0;
        while (i2 < points.getLength()) {
            Element point = (Element)points.item(i2);
            SrsNameTest.assertEquals((String)"http://www.opengis.net/gml/srs/epsg.xml#32615", (String)point.getAttribute("srsName"));
            ++i2;
        }
    }

    public void testWfs11() throws Exception {
        WFSInfo wfs = this.getWFS();
        boolean oldFeatureBounding = wfs.isFeatureBounding();
        wfs.setFeatureBounding(true);
        this.getGeoServer().save((ServiceInfo)wfs);
        try {
            String q = "wfs?request=getfeature&service=wfs&version=1.1.0&typename=cgf:Points";
            Document d = this.getAsDOM(q);
            SrsNameTest.assertEquals((String)"wfs:FeatureCollection", (String)d.getDocumentElement().getNodeName());
            NodeList boxes = d.getElementsByTagName("gml:Envelope");
            SrsNameTest.assertFalse((boxes.getLength() == 0 ? 1 : 0) != 0);
            int i = 0;
            while (i < boxes.getLength()) {
                Element box = (Element)boxes.item(i);
                SrsNameTest.assertEquals((String)"urn:x-ogc:def:crs:EPSG:32615", (String)box.getAttribute("srsName"));
                ++i;
            }
            NodeList points = d.getElementsByTagName("gml:Point");
            SrsNameTest.assertFalse((points.getLength() == 0 ? 1 : 0) != 0);
            int i2 = 0;
            while (i2 < points.getLength()) {
                Element point = (Element)points.item(i2);
                SrsNameTest.assertEquals((String)"urn:x-ogc:def:crs:EPSG:32615", (String)point.getAttribute("srsName"));
                ++i2;
            }
        }
        finally {
            wfs.setFeatureBounding(oldFeatureBounding);
            this.getGeoServer().save((ServiceInfo)wfs);
        }
    }
}

