/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.v1_1;

import java.io.File;
import java.io.InputStream;
import java.net.URLEncoder;
import javax.xml.namespace.QName;
import org.custommonkey.xmlunit.XMLAssert;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.config.ServiceInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.data.util.IOUtils;
import org.geoserver.wfs.GMLInfo;
import org.geoserver.wfs.WFSInfo;
import org.geoserver.wfs.WFSTestSupport;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DescribeFeatureTypeTest
extends WFSTestSupport {
    protected void setUpInternal() throws Exception {
        this.getTestData().disableDataStore(MockData.CITE_PREFIX);
    }

    protected void populateDataDirectory(MockData dataDirectory) throws Exception {
        super.populateDataDirectory(dataDirectory);
        dataDirectory.disableDataStore(MockData.CITE_PREFIX);
        File root = dataDirectory.getDataDirectoryRoot();
        File otherDir = new File(root, "workspaces/cdf/cdf/Other");
        otherDir.mkdirs();
        File otherSchema = new File(otherDir, "schema.xsd");
        IOUtils.copy((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("others.xsd"), (File)otherSchema);
    }

    public void testDateMappings() throws Exception {
        String xml = "<wfs:DescribeFeatureType service=\"WFS\" version=\"1.1.0\" xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:sf=\"" + MockData.PRIMITIVEGEOFEATURE.getNamespaceURI() + "\">" + " <wfs:TypeName>sf:" + MockData.PRIMITIVEGEOFEATURE.getLocalPart() + "</wfs:TypeName>" + "</wfs:DescribeFeatureType>";
        Document doc = this.postAsDOM("wfs", xml);
        DescribeFeatureTypeTest.assertEquals((String)"xsd:schema", (String)doc.getDocumentElement().getNodeName());
        NodeList elements = doc.getElementsByTagName("xsd:element");
        boolean date = false;
        boolean dateTime = false;
        int i = 0;
        while (i < elements.getLength()) {
            Element e = (Element)elements.item(i);
            if ("dateProperty".equals(e.getAttribute("name"))) {
                date = "xsd:date".equals(e.getAttribute("type"));
            }
            if ("dateTimeProperty".equals(e.getAttribute("name"))) {
                dateTime = "xsd:dateTime".equals(e.getAttribute("type"));
            }
            ++i;
        }
        DescribeFeatureTypeTest.assertTrue((boolean)date);
        DescribeFeatureTypeTest.assertTrue((boolean)dateTime);
    }

    public void testNoNamespaceDeclaration() throws Exception {
        String xml = "<wfs:DescribeFeatureType service=\"WFS\" version=\"1.1.0\" xmlns:wfs=\"http://www.opengis.net/wfs\"> <wfs:TypeName>sf:" + MockData.PRIMITIVEGEOFEATURE.getLocalPart() + "</wfs:TypeName>" + "</wfs:DescribeFeatureType>";
        Document doc = this.postAsDOM("wfs", xml);
        DescribeFeatureTypeTest.assertEquals((String)"xsd:schema", (String)doc.getDocumentElement().getNodeName());
    }

    public void testMultipleTypesImport() throws Exception {
        String xml = "<wfs:DescribeFeatureType service=\"WFS\" version=\"1.1.0\" xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:sf=\"" + MockData.PRIMITIVEGEOFEATURE.getNamespaceURI() + "\">" + "<wfs:TypeName>sf:" + MockData.PRIMITIVEGEOFEATURE.getLocalPart() + "</wfs:TypeName>" + "<wfs:TypeName>sf:" + MockData.GENERICENTITY.getLocalPart() + "</wfs:TypeName>" + "</wfs:DescribeFeatureType>";
        Document doc = this.postAsDOM("wfs", xml);
        this.print(doc);
        DescribeFeatureTypeTest.assertEquals((String)"xsd:schema", (String)doc.getDocumentElement().getNodeName());
        NodeList nodes = doc.getDocumentElement().getChildNodes();
        boolean seenComplexType = false;
        int i = 0;
        while (i < nodes.getLength()) {
            Node node = nodes.item(i);
            if (node.getNodeName().equals("xsd:complexType")) {
                seenComplexType = true;
            } else if (seenComplexType && node.getNodeName().equals("xsd:import")) {
                DescribeFeatureTypeTest.fail((String)"All xsd:import must occur before all xsd:complexType");
            }
            ++i;
        }
    }

    public void testUerSuppliedTypeNameNamespace() throws Exception {
        QName typeName = MockData.POLYGONS;
        String path = "ows?service=WFS&version=1.1.0&request=DescribeFeatureType&typeName=myPrefix:" + typeName.getLocalPart() + "&namespace=xmlns(myPrefix%3D" + URLEncoder.encode(typeName.getNamespaceURI(), "UTF-8") + ")";
        Document doc = this.getAsDOM(path);
        DescribeFeatureTypeTest.assertEquals((String)"xsd:schema", (String)doc.getDocumentElement().getNodeName());
    }

    public void testUerSuppliedTypeNameDefaultNamespace() throws Exception {
        QName typeName = MockData.POLYGONS;
        String path = "ows?service=WFS&version=1.1.0&request=DescribeFeatureType&typeName=" + typeName.getLocalPart() + "&namespace=xmlns(" + URLEncoder.encode(typeName.getNamespaceURI(), "UTF-8") + ")";
        Document doc = this.getAsDOM(path);
        DescribeFeatureTypeTest.assertEquals((String)"xsd:schema", (String)doc.getDocumentElement().getNodeName());
    }

    public void testMissingNameNamespacePrefix() throws Exception {
        QName typeName = MockData.POLYGONS;
        String path = "ows?service=WFS&version=1.1.0&request=DescribeFeatureType&typeName=" + typeName.getLocalPart();
        Document doc = this.getAsDOM(path);
        DescribeFeatureTypeTest.assertEquals((String)"xsd:schema", (String)doc.getDocumentElement().getNodeName());
    }

    public void testCiteCompliance() throws Exception {
        QName typeName = MockData.STREAMS;
        Catalog catalog = this.getCatalog();
        catalog.setDefaultNamespace(catalog.getNamespaceByURI(typeName.getNamespaceURI()));
        FeatureTypeInfo typeInfo = catalog.getFeatureTypeByName(typeName.getNamespaceURI(), typeName.getLocalPart());
        typeInfo.setEnabled(true);
        catalog.save((ResourceInfo)typeInfo);
        DataStoreInfo store = typeInfo.getStore();
        store.setEnabled(true);
        catalog.save((StoreInfo)store);
        String path = "ows?service=WFS&version=1.1.0&request=DescribeFeatureType&typeName=" + typeName.getLocalPart();
        GeoServer geoServer = this.getGeoServer();
        WFSInfo service = (WFSInfo)geoServer.getService(WFSInfo.class);
        service.setCiteCompliant(false);
        geoServer.save((ServiceInfo)service);
        Document doc = this.getAsDOM(path);
        DescribeFeatureTypeTest.assertEquals((String)"xsd:schema", (String)doc.getDocumentElement().getNodeName());
        service.setCiteCompliant(true);
        geoServer.save((ServiceInfo)service);
        doc = this.getAsDOM(path);
        DescribeFeatureTypeTest.assertEquals((String)"ows:ExceptionReport", (String)doc.getDocumentElement().getNodeName());
    }

    public void testPrefixedGetStrictCite() throws Exception {
        GeoServer geoServer = this.getGeoServer();
        WFSInfo service = (WFSInfo)geoServer.getService(WFSInfo.class);
        service.setCiteCompliant(true);
        geoServer.save((ServiceInfo)service);
        QName typeName = MockData.POLYGONS;
        String path = "ows?service=WFS&version=1.1.0&request=DescribeFeatureType&typeName=" + this.getLayerId(typeName);
        Document doc = this.getAsDOM(path);
        DescribeFeatureTypeTest.assertEquals((String)"xsd:schema", (String)doc.getDocumentElement().getNodeName());
    }

    public void testGML32OutputFormat() throws Exception {
        Document dom = this.getAsDOM("ows?service=WFS&version=1.1.0&request=DescribeFeatureType&outputFormat=text/xml;+subtype%3Dgml/3.2&typename=" + this.getLayerId(MockData.POLYGONS));
        this.print(dom);
    }

    public void testGMLAttributeMapping() throws Exception {
        WFSInfo wfs = this.getWFS();
        GMLInfo gml = (GMLInfo)wfs.getGML().get(WFSInfo.Version.V_11);
        gml.setOverrideGMLAttributes(Boolean.valueOf(false));
        this.getGeoServer().save((ServiceInfo)wfs);
        Document dom = this.getAsDOM("ows?service=WFS&version=1.1.0&request=DescribeFeatureType&typename=" + this.getLayerId(MockData.PRIMITIVEGEOFEATURE));
        XMLAssert.assertXpathNotExists((String)"//xsd:element[@name = 'name']", (Document)dom);
        XMLAssert.assertXpathNotExists((String)"//xsd:element[@name = 'description']", (Document)dom);
        gml.setOverrideGMLAttributes(Boolean.valueOf(true));
        dom = this.getAsDOM("ows?service=WFS&version=1.1.0&request=DescribeFeatureType&typename=" + this.getLayerId(MockData.PRIMITIVEGEOFEATURE));
        XMLAssert.assertXpathExists((String)"//xsd:element[@name = 'name']", (Document)dom);
        XMLAssert.assertXpathExists((String)"//xsd:element[@name = 'description']", (Document)dom);
    }

    public void testCustomSchema() throws Exception {
        Document dom = this.getAsDOM("ows?request=DescribeFeatureType&version=1.1.0&service=WFS&typeName=cdf:Other");
        XMLAssert.assertXpathExists((String)"//xsd:element[@name = 'pointProperty']", (Document)dom);
        XMLAssert.assertXpathExists((String)"//xsd:element[@name = 'string1']", (Document)dom);
        XMLAssert.assertXpathExists((String)"//xsd:element[@name = 'string2']", (Document)dom);
        XMLAssert.assertXpathNotExists((String)"//xsd:element[@name = 'integers']", (Document)dom);
        XMLAssert.assertXpathNotExists((String)"//xsd:element[@name = 'dataTime']", (Document)dom);
    }
}

