/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.kvp;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import junit.framework.TestCase;
import org.geoserver.wfs.kvp.NamespaceKvpParser;
import org.xml.sax.helpers.NamespaceSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamespaceKvpParserTest
extends TestCase {
    private NamespaceKvpParser parser;

    protected void setUp() throws Exception {
        this.parser = new NamespaceKvpParser("namespace");
    }

    public void testEmpty() throws Exception {
        NamespaceSupport ctx = this.parser.parse("");
        NamespaceKvpParserTest.assertNotNull((Object)ctx);
        List<String> prefixes = this.getPrefixes(ctx);
        NamespaceKvpParserTest.assertTrue((boolean)prefixes.contains("xml"));
        NamespaceKvpParserTest.assertEquals((int)1, (int)prefixes.size());
    }

    public void testFormatError() throws Exception {
        try {
            this.parser.parse("xmlns[bad=format]");
            NamespaceKvpParserTest.fail((String)"Expected IAE");
        }
        catch (IllegalArgumentException e) {
            NamespaceKvpParserTest.assertTrue((boolean)true);
        }
        try {
            this.parser.parse("xmlns(bad=http://format]");
            NamespaceKvpParserTest.fail((String)"Expected IAE");
        }
        catch (IllegalArgumentException e) {
            NamespaceKvpParserTest.assertTrue((boolean)true);
        }
        try {
            this.parser.parse("bad=http://format");
            NamespaceKvpParserTest.fail((String)"Expected IAE");
        }
        catch (IllegalArgumentException e) {
            NamespaceKvpParserTest.assertTrue((boolean)true);
        }
    }

    public void testSingle() throws Exception {
        NamespaceSupport ctx = this.parser.parse("xmlns(foo=http://bar)");
        NamespaceKvpParserTest.assertEquals((String)"http://bar", (String)ctx.getURI("foo"));
    }

    public void testMultiple() throws Exception {
        NamespaceSupport ctx = this.parser.parse("xmlns(foo=http://bar), xmlns(ex=http://example.com),xmlns(gs=http://geoserver.org)");
        NamespaceKvpParserTest.assertEquals((String)"http://bar", (String)ctx.getURI("foo"));
        NamespaceKvpParserTest.assertEquals((String)"http://example.com", (String)ctx.getURI("ex"));
        NamespaceKvpParserTest.assertEquals((String)"http://geoserver.org", (String)ctx.getURI("gs"));
    }

    public void testDefaultNamespace() throws Exception {
        NamespaceSupport ctx = this.parser.parse("xmlns(http://default.namespace.com)");
        NamespaceKvpParserTest.assertEquals((String)"http://default.namespace.com", (String)ctx.getURI(""));
    }

    private List<String> getPrefixes(NamespaceSupport ctx) {
        Enumeration<String> prefixes = ctx.getPrefixes();
        ArrayList<String> l = new ArrayList<String>();
        while (prefixes.hasMoreElements()) {
            l.add(prefixes.nextElement());
        }
        return l;
    }
}

