/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs;

import junit.framework.Test;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.config.ServiceInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.test.OneTimeSetupTest;
import org.geoserver.wfs.WFSInfo;
import org.geoserver.wfs.WFSTestSupport;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class MaxFeaturesTest
extends WFSTestSupport {
    private static Catalog catalog;

    public static Test suite() {
        return new OneTimeSetupTest.OneTimeTestSetup((OneTimeSetupTest)new MaxFeaturesTest());
    }

    @Override
    protected void oneTimeSetUp() throws Exception {
        super.oneTimeSetUp();
        GeoServer gs = this.getGeoServer();
        WFSInfo wfs = this.getWFS();
        wfs.setMaxFeatures(5);
        gs.save((ServiceInfo)wfs);
        catalog = this.getCatalog();
    }

    public void testGlobalMax() throws Exception {
        Document doc = this.getAsDOM("wfs?request=GetFeature&typename=cdf:Fifteen&version=1.0.0&service=wfs");
        MaxFeaturesTest.assertEquals((String)"wfs:FeatureCollection", (String)doc.getDocumentElement().getNodeName());
        NodeList featureMembers = doc.getElementsByTagName("gml:featureMember");
        MaxFeaturesTest.assertEquals((int)5, (int)featureMembers.getLength());
    }

    public void testLocalMax() throws Exception {
        FeatureTypeInfo info = this.getFeatureTypeInfo(MockData.FIFTEEN);
        info.setMaxFeatures(3);
        catalog.save((ResourceInfo)info);
        Document doc = this.getAsDOM("wfs?request=GetFeature&typename=cdf:Fifteen&version=1.0.0&service=wfs");
        MaxFeaturesTest.assertEquals((String)"wfs:FeatureCollection", (String)doc.getDocumentElement().getNodeName());
        NodeList featureMembers = doc.getElementsByTagName("gml:featureMember");
        MaxFeaturesTest.assertEquals((int)3, (int)featureMembers.getLength());
    }

    public void testLocalMaxBigger() throws Exception {
        FeatureTypeInfo info = this.getFeatureTypeInfo(MockData.FIFTEEN);
        info.setMaxFeatures(10);
        catalog.save((ResourceInfo)info);
        Document doc = this.getAsDOM("wfs?request=GetFeature&typename=cdf:Fifteen&version=1.0.0&service=wfs");
        MaxFeaturesTest.assertEquals((String)"wfs:FeatureCollection", (String)doc.getDocumentElement().getNodeName());
        NodeList featureMembers = doc.getElementsByTagName("gml:featureMember");
        MaxFeaturesTest.assertEquals((int)5, (int)featureMembers.getLength());
    }

    public void testCombinedLocalMaxes() throws Exception {
        FeatureTypeInfo info = this.getFeatureTypeInfo(MockData.FIFTEEN);
        info.setMaxFeatures(2);
        catalog.save((ResourceInfo)info);
        info = this.getFeatureTypeInfo(MockData.BASIC_POLYGONS);
        info.setMaxFeatures(2);
        catalog.save((ResourceInfo)info);
        Document doc = this.getAsDOM("wfs?request=GetFeature&typename=cdf:Fifteen,cite:BasicPolygons&version=1.0.0&service=wfs");
        MaxFeaturesTest.assertEquals((String)"wfs:FeatureCollection", (String)doc.getDocumentElement().getNodeName());
        MaxFeaturesTest.assertEquals((int)4, (int)doc.getElementsByTagName("gml:featureMember").getLength());
        MaxFeaturesTest.assertEquals((int)2, (int)doc.getElementsByTagName("cdf:Fifteen").getLength());
        MaxFeaturesTest.assertEquals((int)2, (int)doc.getElementsByTagName("cite:BasicPolygons").getLength());
    }

    public void testCombinedLocalMaxesBigger() throws Exception {
        FeatureTypeInfo info = this.getFeatureTypeInfo(MockData.FIFTEEN);
        info.setMaxFeatures(4);
        catalog.save((ResourceInfo)info);
        info = this.getFeatureTypeInfo(MockData.BASIC_POLYGONS);
        info.setMaxFeatures(2);
        catalog.save((ResourceInfo)info);
        Document doc = this.getAsDOM("wfs?request=GetFeature&typename=cdf:Fifteen,cite:BasicPolygons&version=1.0.0&service=wfs");
        MaxFeaturesTest.assertEquals((String)"wfs:FeatureCollection", (String)doc.getDocumentElement().getNodeName());
        MaxFeaturesTest.assertEquals((int)5, (int)doc.getElementsByTagName("gml:featureMember").getLength());
        MaxFeaturesTest.assertEquals((int)4, (int)doc.getElementsByTagName("cdf:Fifteen").getLength());
        MaxFeaturesTest.assertEquals((int)1, (int)doc.getElementsByTagName("cite:BasicPolygons").getLength());
    }

    public void testCombinedLocalMaxesBiggerRequestOverride() throws Exception {
        FeatureTypeInfo info = this.getFeatureTypeInfo(MockData.FIFTEEN);
        info.setMaxFeatures(3);
        catalog.save((ResourceInfo)info);
        info = this.getFeatureTypeInfo(MockData.BASIC_POLYGONS);
        catalog.save((ResourceInfo)info);
        info.setMaxFeatures(2);
        Document doc = this.getAsDOM("wfs?request=GetFeature&typename=cdf:Fifteen,cite:BasicPolygons&version=1.0.0&service=wfs&maxFeatures=4");
        MaxFeaturesTest.assertEquals((String)"wfs:FeatureCollection", (String)doc.getDocumentElement().getNodeName());
        MaxFeaturesTest.assertEquals((int)4, (int)doc.getElementsByTagName("gml:featureMember").getLength());
        MaxFeaturesTest.assertEquals((int)3, (int)doc.getElementsByTagName("cdf:Fifteen").getLength());
        MaxFeaturesTest.assertEquals((int)1, (int)doc.getElementsByTagName("cite:BasicPolygons").getLength());
    }

    public void testMaxFeaturesBreak() throws Exception {
        FeatureTypeInfo info = this.getFeatureTypeInfo(MockData.FIFTEEN);
        info.setMaxFeatures(3);
        catalog.save((ResourceInfo)info);
        info = this.getFeatureTypeInfo(MockData.BASIC_POLYGONS);
        info.setMaxFeatures(2);
        catalog.save((ResourceInfo)info);
        Document doc = this.getAsDOM("wfs?request=GetFeature&typename=cdf:Fifteen,cite:BasicPolygons&version=1.0.0&service=wfs&maxFeatures=3");
        MaxFeaturesTest.assertEquals((String)"wfs:FeatureCollection", (String)doc.getDocumentElement().getNodeName());
        MaxFeaturesTest.assertEquals((int)3, (int)doc.getElementsByTagName("gml:featureMember").getLength());
        MaxFeaturesTest.assertEquals((int)3, (int)doc.getElementsByTagName("cdf:Fifteen").getLength());
        MaxFeaturesTest.assertEquals((int)0, (int)doc.getElementsByTagName("cite:BasicPolygons").getLength());
    }
}

