/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.response;

import com.mockrunner.mock.web.MockHttpServletResponse;
import java.io.File;
import java.io.InputStream;
import junit.framework.Test;
import junit.textui.TestRunner;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.geoserver.data.util.IOUtils;
import org.geoserver.test.OneTimeSetupTest;
import org.geoserver.wfs.WFSTestSupport;

public class GeoJSONTest
extends WFSTestSupport {
    public static Test suite() {
        return new OneTimeSetupTest.OneTimeTestSetup((OneTimeSetupTest)new GeoJSONTest());
    }

    protected void setUpInternal() throws Exception {
        super.setUpInternal();
        File security = new File(this.getTestData().getDataDirectoryRoot(), "security");
        security.mkdir();
        File layers = new File(security, "layers.properties");
        IOUtils.copy((InputStream)GeoJSONTest.class.getResourceAsStream("layers_ro.properties"), (File)layers);
    }

    public void testGet() throws Exception {
        String out = this.getAsString("wfs?request=GetFeature&version=1.0.0&typename=sf:PrimitiveGeoFeature&maxfeatures=1&outputformat=json");
        JSONObject rootObject = JSONObject.fromObject((Object)out);
        GeoJSONTest.assertEquals((Object)rootObject.get("type"), (Object)"FeatureCollection");
        JSONArray featureCol = rootObject.getJSONArray("features");
        JSONObject aFeature = featureCol.getJSONObject(0);
        GeoJSONTest.assertEquals((String)aFeature.getString("geometry_name"), (String)"surfaceProperty");
    }

    public void testPost() throws Exception {
        String xml = "<wfs:GetFeature service=\"WFS\" outputFormat=\"json\" version=\"1.0.0\" xmlns:cdf=\"http://www.opengis.net/cite/data\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\" > <wfs:Query typeName=\"sf:PrimitiveGeoFeature\"> </wfs:Query> </wfs:GetFeature>";
        String out = this.postAsServletResponse("wfs", xml).getOutputStreamContent();
        JSONObject rootObject = JSONObject.fromObject((Object)out);
        GeoJSONTest.assertEquals((Object)rootObject.get("type"), (Object)"FeatureCollection");
        JSONArray featureCol = rootObject.getJSONArray("features");
        JSONObject aFeature = featureCol.getJSONObject(0);
        GeoJSONTest.assertEquals((String)aFeature.getString("geometry_name"), (String)"surfaceProperty");
    }

    public void testGeometryCollection() throws Exception {
        String out = this.getAsString("wfs?request=GetFeature&version=1.0.0&typename=sf:AggregateGeoFeature&maxfeatures=3&outputformat=json");
        JSONObject rootObject = JSONObject.fromObject((Object)out);
        GeoJSONTest.assertEquals((Object)rootObject.get("type"), (Object)"FeatureCollection");
        JSONArray featureCol = rootObject.getJSONArray("features");
        JSONObject aFeature = featureCol.getJSONObject(1);
        JSONObject aGeometry = aFeature.getJSONObject("geometry");
        GeoJSONTest.assertEquals((String)aGeometry.getString("type"), (String)"MultiLineString");
        JSONArray geomArray = aGeometry.getJSONArray("coordinates");
        geomArray = geomArray.getJSONArray(0);
        geomArray = geomArray.getJSONArray(0);
        GeoJSONTest.assertEquals((String)geomArray.getString(0), (String)"55.174");
    }

    public void testMixedCollection() throws Exception {
        String xml = "<wfs:GetFeature service=\"WFS\" outputFormat=\"json\" version=\"1.0.0\" xmlns:cdf=\"http://www.opengis.net/cite/data\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\" > <wfs:Query typeName=\"sf:PrimitiveGeoFeature\" /> <wfs:Query typeName=\"sf:AggregateGeoFeature\" /> </wfs:GetFeature>";
        String out = this.postAsServletResponse("wfs", xml).getOutputStreamContent();
        JSONObject rootObject = JSONObject.fromObject((Object)out);
        GeoJSONTest.assertEquals((Object)rootObject.get("type"), (Object)"FeatureCollection");
        JSONArray featureCol = rootObject.getJSONArray("features");
        JSONObject aFeature = featureCol.getJSONObject(1);
        GeoJSONTest.assertTrue((boolean)aFeature.getString("id").substring(0, 19).equalsIgnoreCase("PrimitiveGeoFeature"));
        aFeature = featureCol.getJSONObject(6);
        GeoJSONTest.assertTrue((boolean)aFeature.getString("id").substring(0, 19).equalsIgnoreCase("AggregateGeoFeature"));
        JSONObject aGeometry = aFeature.getJSONObject("geometry");
        GeoJSONTest.assertEquals((String)aGeometry.getString("type"), (String)"MultiLineString");
    }

    public void testCallbackFunction() throws Exception {
        MockHttpServletResponse resp = this.getAsServletResponse("wfs?request=GetFeature&version=1.0.0&typename=sf:PrimitiveGeoFeature&maxfeatures=1&outputformat=json&format_options=callback:myFunc");
        String out = resp.getOutputStreamContent();
        GeoJSONTest.assertEquals((String)"text/javascript", (String)resp.getContentType());
        GeoJSONTest.assertTrue((boolean)out.startsWith("myFunc("));
        GeoJSONTest.assertTrue((boolean)out.endsWith(")"));
        out = out.substring(7, out.length() - 1);
        JSONObject rootObject = JSONObject.fromObject((Object)out);
        GeoJSONTest.assertEquals((Object)rootObject.get("type"), (Object)"FeatureCollection");
        JSONArray featureCol = rootObject.getJSONArray("features");
        JSONObject aFeature = featureCol.getJSONObject(0);
        GeoJSONTest.assertEquals((String)aFeature.getString("geometry_name"), (String)"surfaceProperty");
    }

    public static void main(String[] args) {
        TestRunner runner = new TestRunner();
        TestRunner.run(GeoJSONTest.class);
    }
}

