/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.v1_1;

import java.util.StringTokenizer;
import org.geoserver.data.test.MockData;
import org.geoserver.wfs.WFSTestSupport;
import org.geotools.referencing.CRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WFSReprojectionWriteTest
extends WFSTestSupport {
    private static final String TARGET_CRS_CODE = "EPSG:900913";
    MathTransform tx;

    protected void setUpInternal() throws Exception {
        super.setUpInternal();
        CoordinateReferenceSystem epsgTarget = CRS.decode((String)TARGET_CRS_CODE);
        CoordinateReferenceSystem epsg32615 = CRS.decode((String)"urn:x-ogc:def:crs:EPSG:6.11.2:32615");
        this.tx = CRS.findMathTransform((CoordinateReferenceSystem)epsg32615, (CoordinateReferenceSystem)epsgTarget);
    }

    public void testInsertSrsName() throws Exception {
        String q = "wfs?request=getfeature&service=wfs&version=1.1&typeName=" + MockData.POLYGONS.getLocalPart();
        Document dom = this.getAsDOM(q);
        WFSReprojectionWriteTest.assertEquals((int)1, (int)dom.getElementsByTagName(MockData.POLYGONS.getPrefix() + ":" + MockData.POLYGONS.getLocalPart()).getLength());
        Element polygonProperty = this.getFirstElementByTagName(dom, "cgf:polygonProperty");
        Element posList = this.getFirstElementByTagName(polygonProperty, "gml:posList");
        double[] c = this.posList(posList.getFirstChild().getNodeValue());
        double[] cr = new double[c.length];
        this.tx.transform(c, 0, cr, 0, cr.length / 2);
        String xml = "<wfs:Transaction service=\"WFS\" version=\"1.1.0\"  xmlns:wfs=\"http://www.opengis.net/wfs\"  xmlns:gml=\"http://www.opengis.net/gml\"  xmlns:cgf=\"" + MockData.CGF_URI + "\">" + "<wfs:Insert handle=\"insert-1\" srsName=\"" + TARGET_CRS_CODE + "\">" + " <cgf:Polygons>" + "<cgf:polygonProperty>" + "<gml:Polygon >" + "<gml:exterior>" + "<gml:LinearRing>" + "<gml:posList>";
        for (int i = 0; i < cr.length; ++i) {
            xml = xml + cr[i];
            if (i >= cr.length - 1) continue;
            xml = xml + " ";
        }
        xml = xml + "</gml:posList></gml:LinearRing></gml:exterior></gml:Polygon></cgf:polygonProperty> </cgf:Polygons></wfs:Insert></wfs:Transaction>";
        this.postAsDOM("wfs", xml);
        dom = this.getAsDOM(q);
        WFSReprojectionWriteTest.assertEquals((int)2, (int)dom.getElementsByTagName(MockData.POLYGONS.getPrefix() + ":" + MockData.POLYGONS.getLocalPart()).getLength());
    }

    public void testInsertGeomSrsName() throws Exception {
        String q = "wfs?request=getfeature&service=wfs&version=1.1&typeName=" + MockData.POLYGONS.getLocalPart();
        Document dom = this.getAsDOM(q);
        Element polygonProperty = this.getFirstElementByTagName(dom, "cgf:polygonProperty");
        Element posList = this.getFirstElementByTagName(polygonProperty, "gml:posList");
        double[] c = this.posList(posList.getFirstChild().getNodeValue());
        double[] cr = new double[c.length];
        this.tx.transform(c, 0, cr, 0, cr.length / 2);
        String xml = "<wfs:Transaction service=\"WFS\" version=\"1.1.0\"  xmlns:wfs=\"http://www.opengis.net/wfs\"  xmlns:gml=\"http://www.opengis.net/gml\"  xmlns:cgf=\"" + MockData.CGF_URI + "\">" + "<wfs:Insert handle=\"insert-1\">" + " <cgf:Polygons>" + "<cgf:polygonProperty>" + "<gml:Polygon srsName=\"" + TARGET_CRS_CODE + "\">" + "<gml:exterior>" + "<gml:LinearRing>" + "<gml:posList>";
        for (int i = 0; i < cr.length; ++i) {
            xml = xml + cr[i];
            if (i >= cr.length - 1) continue;
            xml = xml + " ";
        }
        xml = xml + "</gml:posList></gml:LinearRing></gml:exterior></gml:Polygon></cgf:polygonProperty> </cgf:Polygons></wfs:Insert></wfs:Transaction>";
        this.postAsDOM("wfs", xml);
        dom = this.getAsDOM(q);
        WFSReprojectionWriteTest.assertEquals((int)2, (int)dom.getElementsByTagName(MockData.POLYGONS.getPrefix() + ":" + MockData.POLYGONS.getLocalPart()).getLength());
    }

    public void testUpdate() throws Exception {
        String q = "wfs?request=getfeature&service=wfs&version=1.1&typeName=" + MockData.POLYGONS.getLocalPart();
        Document dom = this.getAsDOM(q);
        Element polygonProperty = this.getFirstElementByTagName(dom, "cgf:polygonProperty");
        Element posList = this.getFirstElementByTagName(polygonProperty, "gml:posList");
        double[] c = this.posList(posList.getFirstChild().getNodeValue());
        double[] cr = new double[c.length];
        this.tx.transform(c, 0, cr, 0, cr.length / 2);
        String xml = "<wfs:Transaction service=\"WFS\" version=\"1.1.0\" xmlns:cgf=\"http://www.opengis.net/cite/geometry\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:gml=\"http://www.opengis.net/gml\"> <wfs:Update typeName=\"cgf:Polygons\" > <wfs:Property><wfs:Name>polygonProperty</wfs:Name><wfs:Value><gml:Polygon srsName=\"EPSG:900913\"><gml:exterior><gml:LinearRing><gml:posList>";
        for (int i = 0; i < cr.length; ++i) {
            xml = xml + cr[i];
            if (i >= cr.length - 1) continue;
            xml = xml + " ";
        }
        xml = xml + "</gml:posList></gml:LinearRing></gml:exterior></gml:Polygon></wfs:Value></wfs:Property><ogc:Filter><ogc:PropertyIsEqualTo><ogc:PropertyName>id</ogc:PropertyName><ogc:Literal>t0002</ogc:Literal></ogc:PropertyIsEqualTo></ogc:Filter></wfs:Update></wfs:Transaction>";
        dom = this.postAsDOM("wfs", xml);
        WFSReprojectionWriteTest.assertEquals((String)"wfs:TransactionResponse", (String)dom.getDocumentElement().getNodeName());
        Element totalUpdated = this.getFirstElementByTagName(dom, "wfs:totalUpdated");
        WFSReprojectionWriteTest.assertEquals((String)"1", (String)totalUpdated.getFirstChild().getNodeValue());
        dom = this.getAsDOM(q);
        polygonProperty = this.getFirstElementByTagName(dom, "cgf:polygonProperty");
        posList = this.getFirstElementByTagName(polygonProperty, "gml:posList");
        double[] c1 = this.posList(posList.getFirstChild().getNodeValue());
        WFSReprojectionWriteTest.assertEquals((int)c.length, (int)c1.length);
        for (int i = 0; i < c.length; ++i) {
            int x = (int)(c[i] + 0.5);
            int y = (int)(c1[i] + 0.5);
            WFSReprojectionWriteTest.assertEquals((int)x, (int)y);
        }
    }

    public void testUpdateReprojectFilter() throws Exception {
        this.testUpdateReprojectFilter("srsName=\"urn:x-ogc:def:crs:EPSG:6.11.2:4326\"");
    }

    public void testUpdateReprojectFilterDefaultCRS() throws Exception {
        this.testUpdateReprojectFilter("");
    }

    private void testUpdateReprojectFilter(String envelopeSRS) throws Exception {
        String xml = "<wfs:Transaction service=\"WFS\" version=\"1.1.0\" xmlns:cgf=\"http://www.opengis.net/cite/geometry\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:gml=\"http://www.opengis.net/gml\"> <wfs:Update handle=\"upd-1\" typeName=\"sf:GenericEntity\"><wfs:Property>  <wfs:Name>sf:boolProperty</wfs:Name>  <wfs:Value>true</wfs:Value></wfs:Property>  <ogc:Filter>    <ogc:BBOX>      <ogc:PropertyName>sf:attribut.geom</ogc:PropertyName>        <gml:Envelope " + envelopeSRS + ">" + "          <gml:lowerCorner>34.5 -10.0</gml:lowerCorner>" + "          <gml:upperCorner>72.0 32.0</gml:upperCorner>" + "        </gml:Envelope>" + "    </ogc:BBOX>" + "  </ogc:Filter>" + "</wfs:Update> </wfs:Transaction>";
        Document dom = this.postAsDOM("wfs", xml);
        WFSReprojectionWriteTest.assertEquals((String)"wfs:TransactionResponse", (String)dom.getDocumentElement().getNodeName());
        Element totalUpdated = this.getFirstElementByTagName(dom, "wfs:totalUpdated");
        WFSReprojectionWriteTest.assertEquals((String)"3", (String)totalUpdated.getFirstChild().getNodeValue());
    }

    public void testDeleteReprojectFilter() throws Exception {
        this.testDeleteReprojectFilter("srsName=\"urn:x-ogc:def:crs:EPSG:6.11.2:4326\"");
    }

    public void testDeleteReprojectFilterDefaultCRS() throws Exception {
        this.testDeleteReprojectFilter("");
    }

    private void testDeleteReprojectFilter(String envelopeSRS) throws Exception {
        String xml = "<wfs:Transaction service=\"WFS\" version=\"1.1.0\" xmlns:cgf=\"http://www.opengis.net/cite/geometry\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:gml=\"http://www.opengis.net/gml\"> <wfs:Delete typeName=\"sf:GenericEntity\">  <ogc:Filter>    <ogc:BBOX>      <ogc:PropertyName>sf:attribut.geom</ogc:PropertyName>        <gml:Envelope " + envelopeSRS + ">" + "          <gml:lowerCorner>34.5 -10.0</gml:lowerCorner>" + "          <gml:upperCorner>72.0 32.0</gml:upperCorner>" + "        </gml:Envelope>" + "    </ogc:BBOX>" + "  </ogc:Filter>" + "</wfs:Delete> </wfs:Transaction>";
        Document dom = this.postAsDOM("wfs", xml);
        WFSReprojectionWriteTest.assertEquals((String)"wfs:TransactionResponse", (String)dom.getDocumentElement().getNodeName());
        Element totalUpdated = this.getFirstElementByTagName(dom, "wfs:totalDeleted");
        WFSReprojectionWriteTest.assertEquals((String)"3", (String)totalUpdated.getFirstChild().getNodeValue());
    }

    public void testLockReprojectFilter() throws Exception {
        this.testLockReprojectFilter("srsName=\"urn:x-ogc:def:crs:EPSG:6.11.2:4326\"");
    }

    public void testLockReprojectFilterDefaultCRS() throws Exception {
        this.testLockReprojectFilter("");
    }

    private void testLockReprojectFilter(String envelopeSRS) throws Exception {
        String xml = "<wfs:LockFeature xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:sf=\"http://cite.opengeospatial.org/gmlsf\" xmlns:myparsers=\"http://teamengine.sourceforge.net/parsers\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:gml=\"http://www.opengis.net/gml\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" expiry=\"5\" handle=\"LockFeature-tc3\" lockAction=\"ALL\" service=\"WFS\" version=\"1.1.0\"> <wfs:Lock handle=\"lock-1\" typeName=\"sf:GenericEntity\"> <ogc:Filter><ogc:BBOX> <ogc:PropertyName>sf:attribut.geom</ogc:PropertyName> <gml:Envelope " + envelopeSRS + ">" + "    <gml:lowerCorner>34.5 -10.0</gml:lowerCorner>" + "    <gml:upperCorner>72.0 32.0</gml:upperCorner>" + " </gml:Envelope>" + "</ogc:BBOX>" + "</ogc:Filter>" + "</wfs:Lock>" + "</wfs:LockFeature>";
        Document dom = this.postAsDOM("wfs", xml);
        WFSReprojectionWriteTest.assertEquals((String)"wfs:LockFeatureResponse", (String)dom.getDocumentElement().getNodeName());
        WFSReprojectionWriteTest.assertEquals((int)3, (int)dom.getElementsByTagName("ogc:FeatureId").getLength());
    }

    private double[] posList(String string) {
        StringTokenizer st = new StringTokenizer(string, " ");
        double[] coordinates = new double[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            coordinates[i++] = Double.parseDouble(st.nextToken());
        }
        return coordinates;
    }
}

