/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms;

import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.DefaultQuery;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.data.wfs.WFSDataStore;
import org.geotools.data.wfs.WFSDataStoreFactory;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureCollection;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.Expression;

public class RemoteOWSTestSupport {
    public static final String TOPP_STATES = "topp:states";
    public static final String WFS_SERVER_URL = "http://demo.opengeo.org/geoserver/wfs?";
    static Boolean remoteStatesAvailable;

    public static boolean isRemoteStatesAvailable(Logger logger) {
        if (remoteStatesAvailable == null) {
            String value = System.getProperty("remoteOwsTests");
            if (value == null || !"TRUE".equalsIgnoreCase(value)) {
                logger.log(Level.WARNING, "Skipping remote OWS test because they were not enabled via -DremoteOwsTests=true");
                remoteStatesAvailable = Boolean.FALSE;
            } else {
                try {
                    WFSDataStoreFactory factory = new WFSDataStoreFactory();
                    HashMap<String, Serializable> params = new HashMap<String, Serializable>(factory.getImplementationHints());
                    URL url = new URL("http://demo.opengeo.org/geoserver/wfs?service=WFS&request=GetCapabilities");
                    params.put(WFSDataStoreFactory.URL.key, url);
                    params.put(WFSDataStoreFactory.TRY_GZIP.key, Boolean.TRUE);
                    params.put(WFSDataStoreFactory.TIMEOUT.key, Integer.valueOf(5000));
                    WFSDataStore remoteStore = factory.createDataStore(params);
                    FeatureSource fs = remoteStore.getFeatureSource(TOPP_STATES);
                    remoteStatesAvailable = Boolean.TRUE;
                    DefaultQuery dq = new DefaultQuery(TOPP_STATES);
                    FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
                    dq.setFilter((Filter)ff.greater((Expression)ff.property("PERSONS"), (Expression)ff.literal(20000000)));
                    FeatureCollection fc = fs.getFeatures((Query)dq);
                    if (fc.size() != 1) {
                        logger.log(Level.WARNING, "Remote database status invalid, there should be one and only one feature with more than 20M persons in topp:states");
                        remoteStatesAvailable = Boolean.FALSE;
                    }
                    logger.log(Level.WARNING, "Remote OWS tests are enabled, remote server appears to be up");
                }
                catch (IOException e) {
                    logger.log(Level.WARNING, "Skipping remote OWS test, either demo  is down or the topp:states layer is not there", e);
                    remoteStatesAvailable = Boolean.FALSE;
                }
            }
        }
        return remoteStatesAvailable;
    }
}

