/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses.map.kml;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathFactory;
import junit.framework.Test;
import org.custommonkey.xmlunit.XMLAssert;
import org.custommonkey.xmlunit.XMLUnit;
import org.custommonkey.xmlunit.XpathEngine;
import org.geoserver.data.test.MockData;
import org.geoserver.ows.kvp.FormatOptionsKvpParser;
import org.geoserver.test.OneTimeSetupTest;
import org.geoserver.wms.WMSTestSupport;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KMLReflectorTest
extends WMSTestSupport {
    public static Test suite() {
        return new OneTimeSetupTest.OneTimeTestSetup((OneTimeSetupTest)new KMLReflectorTest());
    }

    public void testNoBBOXInHREF() throws Exception {
        String layerName = MockData.BASIC_POLYGONS.getPrefix() + ":" + MockData.BASIC_POLYGONS.getLocalPart();
        XpathEngine xpath = XMLUnit.newXpathEngine();
        String requestURL = "wms/kml?mode=refresh&layers=" + layerName;
        Document dom = this.getAsDOM(requestURL);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(kml/Folder)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(kml/Folder/NetworkLink)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(kml/Folder/LookAt)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)layerName, (String)"kml/Folder/NetworkLink[1]/name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"kml/Folder/NetworkLink[1]/open", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"kml/Folder/NetworkLink[1]/visibility", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"onStop", (String)"kml/Folder/NetworkLink[1]/Url/viewRefreshMode", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"kml/Folder/NetworkLink[1]/Url/viewRefreshTime", (Document)dom);
        Map<String, String> expectedKVP = KMLReflectorTest.toKvp("http://localhost:80/geoserver/wms?format_options=KMPLACEMARK%3Afalse%3BKMATTR%3Atrue%3BKMSCORE%3A40%3BSUPEROVERLAY%3Afalse%3B&service=wms&srs=EPSG%3A4326&width=1024&styles=BasicPolygons&height=1024&transparent=false&request=GetMap&layers=cite%3ABasicPolygons&format=application%2Fvnd.google-earth.kmz%2Bxml&version=1.1.1");
        Map<String, String> resultedKVP = KMLReflectorTest.toKvp(xpath.evaluate("kml/Folder/NetworkLink[1]/Url/href", dom));
        KMLReflectorTest.assertMapsEqual(expectedKVP, resultedKVP);
        String href = xpath.evaluate("kml/Folder/NetworkLink/Link/href", dom);
        Pattern badPattern = Pattern.compile("&bbox=", 2);
        KMLReflectorTest.assertFalse((boolean)badPattern.matcher(href).matches());
    }

    public void testSuperOverlayReflection() throws Exception {
        String layerName = MockData.BASIC_POLYGONS.getPrefix() + ":" + MockData.BASIC_POLYGONS.getLocalPart();
        String requestUrl = "wms/kml?layers=" + layerName + "&styles=&mode=superoverlay";
        Document dom = this.getAsDOM(requestUrl);
        KMLReflectorTest.assertEquals((String)"kml", (String)dom.getDocumentElement().getLocalName());
        XMLAssert.assertXpathExists((String)"kml/Folder/NetworkLink/Link/href", (Document)dom);
        XMLAssert.assertXpathExists((String)"kml/Folder/LookAt/longitude", (Document)dom);
    }

    public void testWmsRepeatedLayerWithNonStandardStyleAndCqlFiler() throws Exception {
        String layerName = MockData.BASIC_POLYGONS.getPrefix() + ":" + MockData.BASIC_POLYGONS.getLocalPart();
        String requestUrl = "wms/kml?mode=refresh&layers=" + layerName + "," + layerName + "&styles=Default,Default&cql_filter=att1<10;att1>1000";
        Document dom = this.getAsDOM(requestUrl);
        KMLReflectorTest.assertEquals((String)"kml", (String)dom.getDocumentElement().getLocalName());
        NodeList folders = dom.getDocumentElement().getElementsByTagName("Folder");
        KMLReflectorTest.assertEquals((int)1, (int)folders.getLength());
        Element folder = (Element)folders.item(0);
        NodeList netLinks = folder.getElementsByTagName("NetworkLink");
        KMLReflectorTest.assertEquals((int)2, (int)netLinks.getLength());
        XMLAssert.assertXpathEvaluatesTo((String)layerName, (String)"kml/Folder/NetworkLink[1]/name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)layerName, (String)"kml/Folder/NetworkLink[2]/name", (Document)dom);
        XPath xpath = XPathFactory.newInstance().newXPath();
        String url1 = xpath.compile("/kml/Folder/NetworkLink[1]/Url/href").evaluate(dom);
        String url2 = xpath.compile("/kml/Folder/NetworkLink[2]/Url/href").evaluate(dom);
        KMLReflectorTest.assertNotNull((Object)url1);
        KMLReflectorTest.assertNotNull((Object)url2);
        Map<String, String> kvp1 = KMLReflectorTest.toKvp(url1);
        Map<String, String> kvp2 = KMLReflectorTest.toKvp(url2);
        KMLReflectorTest.assertEquals((String)layerName, (String)kvp1.get("LAYERS"));
        KMLReflectorTest.assertEquals((String)layerName, (String)kvp2.get("LAYERS"));
        KMLReflectorTest.assertEquals((String)"Default", (String)kvp1.get("STYLES"));
        KMLReflectorTest.assertEquals((String)"Default", (String)kvp2.get("STYLES"));
        KMLReflectorTest.assertEquals((String)"att1<10", (String)kvp1.get("CQL_FILTER"));
        KMLReflectorTest.assertEquals((String)"att1>1000", (String)kvp2.get("CQL_FILTER"));
    }

    static Map<String, String> toKvp(String url) {
        String[] tuples;
        if (url.indexOf(63) > 0) {
            url = url.substring(url.indexOf(63) + 1);
        }
        HashMap<String, String> kvpMap = new HashMap<String, String>();
        for (String tuple : tuples = url.split("&")) {
            String value;
            String[] kvp = tuple.split("=");
            String key = kvp[0].toUpperCase();
            String string = value = kvp.length > 1 ? kvp[1] : null;
            if (value != null) {
                try {
                    value = URLDecoder.decode(value, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
            kvpMap.put(key, value);
        }
        return kvpMap;
    }

    static void assertMapsEqual(Map<String, String> expected, Map<String, String> actual) throws Exception {
        for (Map.Entry<String, String> entry : expected.entrySet()) {
            if (entry.getKey().equalsIgnoreCase("format_options")) {
                FormatOptionsKvpParser parser = new FormatOptionsKvpParser();
                Map expectedFormatOptions = (Map)parser.parse(entry.getValue());
                Map actualFormatOptions = (Map)parser.parse(actual.get(entry.getKey()));
                Iterator i$ = expectedFormatOptions.entrySet().iterator();
                while (i$.hasNext()) {
                    Map.Entry o;
                    Map.Entry formatOption = o = i$.next();
                    KMLReflectorTest.assertEquals(formatOption.getValue(), actualFormatOptions.get(formatOption.getKey()));
                }
                for (Map.Entry key : actualFormatOptions.keySet()) {
                    KMLReflectorTest.assertTrue((String)("found unexpected key " + key + " in format options"), (boolean)expectedFormatOptions.containsKey(key));
                }
                continue;
            }
            KMLReflectorTest.assertEquals((String)entry.getValue(), (String)actual.get(entry.getKey()));
        }
        for (String key : actual.keySet()) {
            KMLReflectorTest.assertTrue((boolean)expected.containsKey(key));
        }
    }
}

