/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses.map.openlayers;

import freemarker.ext.beans.BeansWrapper;
import freemarker.template.Configuration;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import junit.framework.Test;
import org.geoserver.data.test.MockData;
import org.geoserver.test.OneTimeSetupTest;
import org.geoserver.wms.WMSTestSupport;
import org.vfny.geoserver.wms.WMSMapContext;
import org.vfny.geoserver.wms.requests.GetMapRequest;
import org.vfny.geoserver.wms.responses.map.openlayers.OpenLayersMapProducer;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class OpenLayersMapTemplateTest
extends WMSTestSupport {
    public static Test suite() {
        return new OneTimeSetupTest.OneTimeTestSetup((OneTimeSetupTest)new OpenLayersMapTemplateTest());
    }

    public void test() throws Exception {
        Configuration cfg = new Configuration();
        cfg.setClassForTemplateLoading(OpenLayersMapProducer.class, "");
        cfg.setObjectWrapper((ObjectWrapper)new BeansWrapper());
        Template template = cfg.getTemplate("OpenLayersMapTemplate.ftl");
        OpenLayersMapTemplateTest.assertNotNull((Object)template);
        GetMapRequest request = this.createGetMapRequest(MockData.BASIC_POLYGONS);
        WMSMapContext mapContext = new WMSMapContext();
        mapContext.addLayer(this.createMapLayer(MockData.BASIC_POLYGONS));
        mapContext.setRequest(request);
        mapContext.setMapWidth(256);
        mapContext.setMapHeight(256);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("context", mapContext);
        map.put("request", mapContext.getRequest());
        map.put("maxResolution", new Double(5.0E-4));
        map.put("baseUrl", "http://localhost:8080/geoserver/wms");
        map.put("parameters", new ArrayList());
        map.put("layerName", "layer");
        map.put("units", "degrees");
        map.put("pureCoverage", "false");
        map.put("styles", new ArrayList());
        template.process(map, (Writer)new OutputStreamWriter(output));
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setValidating(false);
        dbf.setExpandEntityReferences(false);
        DocumentBuilder docBuilder = dbf.newDocumentBuilder();
        docBuilder.setEntityResolver(new EntityResolver(){

            public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                StringReader reader = new StringReader("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                InputSource source = new InputSource(reader);
                source.setPublicId(publicId);
                source.setSystemId(systemId);
                return source;
            }
        });
        Document document = docBuilder.parse(new ByteArrayInputStream(output.toByteArray()));
        OpenLayersMapTemplateTest.assertNotNull((Object)document);
        OpenLayersMapTemplateTest.assertEquals((String)"html", (String)document.getDocumentElement().getNodeName());
    }
}

