/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses.styles;

import java.io.InputStream;
import junit.framework.Test;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogBuilder;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.test.OneTimeSetupTest;
import org.geoserver.wms.WMSTestSupport;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.styling.NamedLayer;
import org.geotools.styling.SLDParser;
import org.geotools.styling.Style;
import org.geotools.styling.StyledLayerDescriptor;

public class GetStylesTest
extends WMSTestSupport {
    public static Test suite() {
        return new OneTimeSetupTest.OneTimeTestSetup((OneTimeSetupTest)new GetStylesTest());
    }

    protected void oneTimeSetUp() throws Exception {
        super.oneTimeSetUp();
        Catalog catalog = this.getCatalog();
        String lakes = MockData.LAKES.getLocalPart();
        String forests = MockData.FORESTS.getLocalPart();
        String bridges = MockData.BRIDGES.getLocalPart();
        LayerGroupInfo lg = catalog.getFactory().createLayerGroup();
        lg.setName("lakesGroup");
        lg.getLayers().add(catalog.getLayerByName(lakes));
        lg.getStyles().add(catalog.getStyleByName(lakes));
        lg.getLayers().add(catalog.getLayerByName(forests));
        lg.getStyles().add(catalog.getStyleByName(forests));
        lg.getLayers().add(catalog.getLayerByName(bridges));
        lg.getStyles().add(catalog.getStyleByName(bridges));
        CatalogBuilder builder = new CatalogBuilder(catalog);
        builder.calculateLayerGroupBounds(lg);
        catalog.add(lg);
        LayerInfo lakesLayer = catalog.getLayerByName(this.getLayerId(MockData.LAKES));
        lakesLayer.getStyles().add(catalog.getStyleByName(MockData.FORESTS.getLocalPart()));
        catalog.save(lakesLayer);
    }

    public void testSimple() throws Exception {
        InputStream stream = this.get("wms?service=WMS&version=1.1.0&&request=GetStyles&layers=" + this.getLayerId(MockData.BASIC_POLYGONS) + "&sldver=1.0.0");
        SLDParser parser = new SLDParser(CommonFactoryFinder.getStyleFactory(null));
        parser.setInput(stream);
        StyledLayerDescriptor sld = parser.parseSLD();
        GetStylesTest.assertEquals((int)1, (int)sld.getStyledLayers().length);
        NamedLayer layer = (NamedLayer)sld.getStyledLayers()[0];
        GetStylesTest.assertEquals((String)this.getLayerId(MockData.BASIC_POLYGONS), (String)layer.getName());
        GetStylesTest.assertEquals((int)1, (int)layer.styles().size());
        Style style = (Style)layer.styles().get(0);
        GetStylesTest.assertTrue((boolean)style.isDefault());
        GetStylesTest.assertEquals((String)"BasicPolygons", (String)style.getName());
    }

    public void testGroup() throws Exception {
        InputStream stream = this.get("wms?service=WMS&version=1.1.0&request=GetStyles&layers=lakesGroup&sldver=1.0.0");
        SLDParser parser = new SLDParser(CommonFactoryFinder.getStyleFactory(null));
        parser.setInput(stream);
        StyledLayerDescriptor sld = parser.parseSLD();
        GetStylesTest.assertEquals((int)1, (int)sld.getStyledLayers().length);
        NamedLayer layer = (NamedLayer)sld.getStyledLayers()[0];
        GetStylesTest.assertEquals((String)"lakesGroup", (String)layer.getName());
        GetStylesTest.assertEquals((int)0, (int)layer.styles().size());
    }

    public void testMultiStyle() throws Exception {
        InputStream stream = this.get("wms?service=WMS&version=1.1.0&request=GetStyles&layers=" + this.getLayerId(MockData.LAKES) + "&sldver=1.0.0");
        SLDParser parser = new SLDParser(CommonFactoryFinder.getStyleFactory(null));
        parser.setInput(stream);
        StyledLayerDescriptor sld = parser.parseSLD();
        GetStylesTest.assertEquals((int)1, (int)sld.getStyledLayers().length);
        NamedLayer layer = (NamedLayer)sld.getStyledLayers()[0];
        GetStylesTest.assertEquals((String)this.getLayerId(MockData.LAKES), (String)layer.getName());
        GetStylesTest.assertEquals((int)2, (int)layer.styles().size());
        Style style = (Style)layer.styles().get(0);
        GetStylesTest.assertTrue((boolean)style.isDefault());
        GetStylesTest.assertEquals((String)"Lakes", (String)style.getName());
        style = (Style)layer.styles().get(1);
        GetStylesTest.assertFalse((boolean)style.isDefault());
        GetStylesTest.assertEquals((String)"Forests", (String)style.getName());
    }
}

