/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms;

import junit.framework.Test;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.test.OneTimeSetupTest;
import org.geoserver.wms.WMSTestSupport;
import org.w3c.dom.Document;

public class DescribeLayerTest
extends WMSTestSupport {
    public static Test suite() {
        return new OneTimeSetupTest.OneTimeTestSetup((OneTimeSetupTest)new DescribeLayerTest());
    }

    protected void oneTimeSetUp() throws Exception {
        super.oneTimeSetUp();
        GeoServerInfo global = this.getGeoServer().getGlobal();
        global.setProxyBaseUrl("src/test/resources/geoserver");
        this.getGeoServer().save(global);
    }

    public void testDescribeLayerVersion111() throws Exception {
        String layer = String.valueOf(MockData.FORESTS.getPrefix()) + ":" + MockData.FORESTS.getLocalPart();
        String request = "wms?service=wms&version=1.1.1&request=DescribeLayer&layers=" + layer;
        DescribeLayerTest.assertEquals((String)"src/test/resources/geoserver", (String)this.getGeoServer().getGlobal().getProxyBaseUrl());
        Document dom = this.getAsDOM(request, true);
        DescribeLayerTest.assertEquals((String)"1.1.1", (String)dom.getDocumentElement().getAttributes().getNamedItem("version").getNodeValue());
    }
}

