/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses.map.georss;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import junit.framework.Test;
import org.geoserver.data.test.MockData;
import org.geoserver.test.OneTimeSetupTest;
import org.geoserver.wms.WMSTestSupport;
import org.geotools.data.Query;
import org.vfny.geoserver.wms.WMSMapContext;
import org.vfny.geoserver.wms.responses.map.georss.AtomGeoRSSTransformer;
import org.vfny.geoserver.wms.responses.map.georss.GeoRSSTransformerBase;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class AtomGeoRSSTransformerTest
extends WMSTestSupport {
    static WMSMapContext map;

    public static Test suite() {
        return new OneTimeSetupTest.OneTimeTestSetup((OneTimeSetupTest)new AtomGeoRSSTransformerTest());
    }

    protected void oneTimeSetUp() throws Exception {
        super.oneTimeSetUp();
        map = new WMSMapContext(this.createGetMapRequest(MockData.BASIC_POLYGONS));
        map.addLayer(this.createMapLayer(MockData.BASIC_POLYGONS));
    }

    public void testLatLongInternal() throws Exception {
        AtomGeoRSSTransformer tx = new AtomGeoRSSTransformer();
        tx.setGeometryEncoding(GeoRSSTransformerBase.GeometryEncoding.LATLONG);
        tx.setIndentation(2);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        tx.transform((Object)map, (OutputStream)output);
        DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document document = docBuilder.parse(new ByteArrayInputStream(output.toByteArray()));
        Element element = document.getDocumentElement();
        AtomGeoRSSTransformerTest.assertEquals((String)"feed", (String)element.getNodeName());
        NodeList entries = element.getElementsByTagName("entry");
        int n = this.getFeatureSource(MockData.BASIC_POLYGONS).getCount(Query.ALL);
        AtomGeoRSSTransformerTest.assertEquals((int)n, (int)entries.getLength());
        int i = 0;
        while (i < entries.getLength()) {
            Element entry = (Element)entries.item(i);
            AtomGeoRSSTransformerTest.assertEquals((int)1, (int)entry.getElementsByTagName("geo:lat").getLength());
            AtomGeoRSSTransformerTest.assertEquals((int)1, (int)entry.getElementsByTagName("geo:long").getLength());
            ++i;
        }
    }

    public void testLatLongWMS() throws Exception {
        Document document = this.getAsDOM("wms/reflect?format_options=encoding:latlong&format=application/atom+xml&layers=" + MockData.BASIC_POLYGONS.getPrefix() + ":" + MockData.BASIC_POLYGONS.getLocalPart());
        Element element = document.getDocumentElement();
        AtomGeoRSSTransformerTest.assertEquals((String)"feed", (String)element.getNodeName());
        NodeList entries = element.getElementsByTagName("entry");
        int n = this.getFeatureSource(MockData.BASIC_POLYGONS).getCount(Query.ALL);
        AtomGeoRSSTransformerTest.assertEquals((int)n, (int)entries.getLength());
        int i = 0;
        while (i < entries.getLength()) {
            Element entry = (Element)entries.item(i);
            AtomGeoRSSTransformerTest.assertEquals((int)1, (int)entry.getElementsByTagName("geo:lat").getLength());
            AtomGeoRSSTransformerTest.assertEquals((int)1, (int)entry.getElementsByTagName("geo:long").getLength());
            ++i;
        }
    }

    public void testSimpleInternal() throws Exception {
        AtomGeoRSSTransformer tx = new AtomGeoRSSTransformer();
        tx.setGeometryEncoding(GeoRSSTransformerBase.GeometryEncoding.SIMPLE);
        tx.setIndentation(2);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        tx.transform((Object)map, (OutputStream)output);
        DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document document = docBuilder.parse(new ByteArrayInputStream(output.toByteArray()));
        Element element = document.getDocumentElement();
        AtomGeoRSSTransformerTest.assertEquals((String)"feed", (String)element.getNodeName());
        NodeList entries = element.getElementsByTagName("entry");
        int n = this.getFeatureSource(MockData.BASIC_POLYGONS).getCount(Query.ALL);
        AtomGeoRSSTransformerTest.assertEquals((int)n, (int)entries.getLength());
        int i = 0;
        while (i < entries.getLength()) {
            Element entry = (Element)entries.item(i);
            AtomGeoRSSTransformerTest.assertEquals((int)1, (int)entry.getElementsByTagName("georss:where").getLength());
            AtomGeoRSSTransformerTest.assertEquals((int)1, (int)entry.getElementsByTagName("georss:polygon").getLength());
            ++i;
        }
    }

    public void testSimpleWMS() throws Exception {
        Document document = this.getAsDOM("wms/reflect?format_options=encoding:simple&format=application/atom+xml&layers=" + MockData.BASIC_POLYGONS.getPrefix() + ":" + MockData.BASIC_POLYGONS.getLocalPart());
        Element element = document.getDocumentElement();
        AtomGeoRSSTransformerTest.assertEquals((String)"feed", (String)element.getNodeName());
        NodeList entries = element.getElementsByTagName("entry");
        int n = this.getFeatureSource(MockData.BASIC_POLYGONS).getCount(Query.ALL);
        AtomGeoRSSTransformerTest.assertEquals((int)n, (int)entries.getLength());
        int i = 0;
        while (i < entries.getLength()) {
            Element entry = (Element)entries.item(i);
            AtomGeoRSSTransformerTest.assertEquals((int)1, (int)entry.getElementsByTagName("georss:where").getLength());
            AtomGeoRSSTransformerTest.assertEquals((int)1, (int)entry.getElementsByTagName("georss:polygon").getLength());
            ++i;
        }
    }
}

