/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses.map.kml;

import java.io.Serializable;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.data.test.MockData;
import org.vfny.geoserver.wms.responses.map.kml.RegionatingTestSupport;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class GeoSearchKMLTest
extends RegionatingTestSupport {
    public void testOutput() throws Exception {
        String path = "wms?request=getmap&service=wms&version=1.1.1&format=application/vnd.google-earth.kml+xml&layers=" + MockData.BASIC_POLYGONS.getPrefix() + ":" + MockData.BASIC_POLYGONS.getLocalPart() + "&styles=" + MockData.BASIC_POLYGONS.getLocalPart() + "&height=1024&width=1024&bbox=-180,-90,0,90&srs=EPSG:4326" + "&featureid=BasicPolygons.1107531493643";
        Document document = this.getAsDOM(path);
        GeoSearchKMLTest.assertEquals((String)"kml", (String)document.getDocumentElement().getTagName());
    }

    public void testDataRegionator() throws Exception {
        String path = "wms?request=getmap&service=wms&version=1.1.1&format=application/vnd.google-earth.kml+xml&layers=" + MockData.DIVIDED_ROUTES.getPrefix() + ":" + MockData.DIVIDED_ROUTES.getLocalPart() + "&styles=" + MockData.DIVIDED_ROUTES.getLocalPart() + "&height=1024&width=1024&srs=EPSG:4326" + "&format_options=regionateBy:external-sorting;regionateAttr:NUM_LANES";
        Document document = this.getAsDOM(String.valueOf(path) + "&bbox=-180,-90,0,90");
        GeoSearchKMLTest.assertEquals((String)"kml", (String)document.getDocumentElement().getTagName());
        int westCount = document.getDocumentElement().getElementsByTagName("Placemark").getLength();
        this.assertStatusCodeForGet(204, String.valueOf(path) + "&bbox=0,-90,180,90");
        GeoSearchKMLTest.assertEquals((int)1, (int)westCount);
    }

    public void testGeometryRegionator() throws Exception {
        String path = "wms?request=getmap&service=wms&version=1.1.1&format=application/vnd.google-earth.kml+xml&layers=" + MockData.DIVIDED_ROUTES.getPrefix() + ":" + MockData.DIVIDED_ROUTES.getLocalPart() + "&styles=" + MockData.DIVIDED_ROUTES.getLocalPart() + "&height=1024&width=1024&srs=EPSG:4326" + "&format_options=regionateBy:geometry;regionateAttr:the_geom";
        Document document = this.getAsDOM(String.valueOf(path) + "&bbox=-180,-90,0,90");
        GeoSearchKMLTest.assertEquals((String)"kml", (String)document.getDocumentElement().getTagName());
        GeoSearchKMLTest.assertEquals((int)1, (int)document.getDocumentElement().getElementsByTagName("Placemark").getLength());
        this.assertStatusCodeForGet(204, String.valueOf(path) + "&bbox=0,-90,180,90");
    }

    public void testRandomRegionator() throws Exception {
        String path = "wms?request=getmap&service=wms&version=1.1.1&format=application/vnd.google-earth.kml+xml&layers=" + MockData.DIVIDED_ROUTES.getPrefix() + ":" + MockData.DIVIDED_ROUTES.getLocalPart() + "&styles=" + MockData.DIVIDED_ROUTES.getLocalPart() + "&height=1024&width=1024&srs=EPSG:4326" + "&format_options=regionateBy:random";
        Document document = this.getAsDOM(String.valueOf(path) + "&bbox=-180,-90,0,90");
        GeoSearchKMLTest.assertEquals((String)"kml", (String)document.getDocumentElement().getTagName());
        GeoSearchKMLTest.assertEquals((int)1, (int)document.getDocumentElement().getElementsByTagName("Placemark").getLength());
        this.assertStatusCodeForGet(204, String.valueOf(path) + "&bbox=0,-90,180,90");
    }

    public void testBogusRegionator() throws Exception {
        String path = "wms?request=getmap&service=wms&version=1.1.1&format=application/vnd.google-earth.kml+xml&layers=" + MockData.DIVIDED_ROUTES.getPrefix() + ":" + MockData.DIVIDED_ROUTES.getLocalPart() + "&styles=" + MockData.DIVIDED_ROUTES.getLocalPart() + "&height=1024&width=1024&srs=EPSG:4326" + "&format_options=regionateBy:bogus";
        Document document = this.getAsDOM(String.valueOf(path) + "&bbox=0,-90,180,90", true);
        GeoSearchKMLTest.assertEquals((String)"ServiceExceptionReport", (String)document.getDocumentElement().getTagName());
    }

    public void testBigGeometries() throws Exception {
        String path = "wms?request=getmap&service=wms&version=1.1.1&format=application/vnd.google-earth.kml+xml&layers=" + CENTERED_POLY.getPrefix() + ":" + CENTERED_POLY.getLocalPart() + "&styles=" + "&height=1024&width=1024&srs=EPSG:4326" + "&format_options=regionateBy:external-sorting;regionateattr:foo";
        this.assertStatusCodeForGet(204, String.valueOf(path) + "&bbox=-180,-90,0,90");
        Document document = this.getAsDOM(String.valueOf(path) + "&bbox=0,-90,180,90");
        GeoSearchKMLTest.assertEquals((String)"kml", (String)document.getDocumentElement().getTagName());
        GeoSearchKMLTest.assertEquals((int)1, (int)document.getDocumentElement().getElementsByTagName("Placemark").getLength());
    }

    public void testStrategyChangesStuff() throws Exception {
        String path = "wms?request=getmap&service=wms&version=1.1.1&format=application/vnd.google-earth.kml+xml&layers=" + TILE_TESTS.getPrefix() + ":" + TILE_TESTS.getLocalPart() + "&bbox=-180,-90,0,90&styles=" + "&height=1024&width=1024&srs=EPSG:4326";
        FeatureTypeInfo fti = this.getFeatureTypeInfo(TILE_TESTS);
        fti.getMetadata().put("kml.regionateFeatureLimit", (Serializable)Integer.valueOf(2));
        Document geo = this.getAsDOM(String.valueOf(path) + "&format_options=regionateBy:geometry;regionateattr:location");
        GeoSearchKMLTest.assertEquals((String)"kml", (String)geo.getDocumentElement().getTagName());
        NodeList geoPlacemarks = geo.getDocumentElement().getElementsByTagName("Placemark");
        GeoSearchKMLTest.assertEquals((int)2, (int)geoPlacemarks.getLength());
        Document data = this.getAsDOM(String.valueOf(path) + "&format_options=regionateBy:external-sorting;regionateAttr:z");
        GeoSearchKMLTest.assertEquals((String)"kml", (String)data.getDocumentElement().getTagName());
        NodeList dataPlacemarks = data.getDocumentElement().getElementsByTagName("Placemark");
        GeoSearchKMLTest.assertEquals((int)2, (int)dataPlacemarks.getLength());
        int i = 0;
        while (i < geoPlacemarks.getLength()) {
            String geoName = ((Element)geoPlacemarks.item(i)).getAttribute("id");
            String dataName = ((Element)dataPlacemarks.item(i)).getAttribute("id");
            GeoSearchKMLTest.assertTrue((String)(String.valueOf(geoName) + " and " + dataName + " should not be the same!"), (!geoName.equals(dataName) ? 1 : 0) != 0);
            ++i;
        }
    }

    public void testDuplicateAttribute() throws Exception {
        String path = "wms?request=getmap&service=wms&version=1.1.1&format=application/vnd.google-earth.kml+xml&layers=" + TILE_TESTS.getPrefix() + ":" + TILE_TESTS.getLocalPart() + "&bbox=-180,-90,0,90&styles=" + "&height=1024&width=1024&srs=EPSG:4326";
        FeatureTypeInfo fti = this.getFeatureTypeInfo(TILE_TESTS);
        fti.getMetadata().put("kml.regionateFeatureLimit", (Serializable)Integer.valueOf(2));
        Document geo = this.getAsDOM(String.valueOf(path) + "&format_options=regionateBy:best_guess;regionateattr:the_geom");
        GeoSearchKMLTest.assertEquals((String)"kml", (String)geo.getDocumentElement().getTagName());
    }
}

