/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.kml;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Point;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import junit.framework.TestCase;
import org.custommonkey.xmlunit.XMLAssert;
import org.custommonkey.xmlunit.XMLUnit;
import org.custommonkey.xmlunit.XpathEngine;
import org.geoserver.kml.KMLNetworkLinkTransformer;
import org.geoserver.kml.KMLReflectorTest;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.wms.GetMapRequest;
import org.geoserver.wms.MapLayerInfo;
import org.geoserver.wms.WMS;
import org.geoserver.wms.WMSMapContext;
import org.geoserver.wms.WMSMockData;
import org.geoserver.wms.WMSTestSupport;
import org.geotools.xml.transform.TransformerBase;
import org.w3c.dom.Document;

public class KMLNetworkLinkTransformerTest
extends TestCase {
    private WMSMockData mockData;
    private GetMapRequest request;
    private WMSMapContext mapContext;

    protected void setUp() throws Exception {
        this.mockData = new WMSMockData();
        this.mockData.setUp();
        MapLayerInfo layer = this.mockData.addFeatureTypeLayer("TestPoints", Point.class);
        this.mapContext = new WMSMapContext();
        this.request = this.mockData.createRequest();
        this.request.setLayers(Collections.singletonList(layer));
        this.request.setFormatOptions(Collections.singletonMap("relLinks", "true"));
        this.request.setBaseUrl("http://geoserver.org:8181/geoserver");
        this.mapContext.setRequest(this.request);
    }

    protected void tearDown() throws Exception {
        new GeoServerExtensions().setApplicationContext(null);
    }

    public void testEncodeAsRegion() throws Exception {
        XpathEngine xpath = XMLUnit.newXpathEngine();
        WMS wms = this.mockData.getWMS();
        KMLNetworkLinkTransformer transformer = new KMLNetworkLinkTransformer(wms, this.mapContext);
        transformer.setEncodeAsRegion(true);
        transformer.setIndentation(2);
        this.request.setBbox(new Envelope(-1.0, 1.0, -10.0, 10.0));
        Document dom = WMSTestSupport.transform(this.request, (TransformerBase)transformer);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//kml/Folder)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//kml/Folder/NetworkLink)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//kml/Folder/LookAt)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"geos:TestPoints", (String)"//kml/Folder/NetworkLink/name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"//kml/Folder/NetworkLink/open", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"//kml/Folder/NetworkLink/visibility", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"10.0", (String)"//kml/Folder/NetworkLink/Region/LatLonAltBox/north", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"-10.0", (String)"//kml/Folder/NetworkLink/Region/LatLonAltBox/south", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1.0", (String)"//kml/Folder/NetworkLink/Region/LatLonAltBox/east", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"-1.0", (String)"//kml/Folder/NetworkLink/Region/LatLonAltBox/west", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"128", (String)"//kml/Folder/NetworkLink/Region/Lod/minLodPixels", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"-1", (String)"//kml/Folder/NetworkLink/Region/Lod/maxLodPixels", (Document)dom);
        Map<String, String> expectedKvp = KMLReflectorTest.toKvp("http://geoserver.org:8181/geoserver/wms?format_options=relLinks%3Atrue%3B&service=wms&srs=EPSG%3A4326&width=512&styles=Default+Style&height=256&transparent=false&bbox=-1.0%2C-10.0%2C1.0%2C10.0&request=GetMap&layers=geos%3ATestPoints&format=application%2Fvnd.google-earth.kmz&version=1.1.1");
        Map<String, String> actualKvp = KMLReflectorTest.toKvp(xpath.evaluate("//kml/Folder/NetworkLink/Link/href", dom));
        KMLReflectorTest.assertMapsEqual(expectedKvp, actualKvp);
        XMLAssert.assertXpathEvaluatesTo((String)"180.0", (String)"//kml/Folder/LookAt/longitude", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"0.0", (String)"//kml/Folder/LookAt/latitude", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"//kml/Folder/LookAt/altitude", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"//kml/Folder/LookAt/tilt", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"//kml/Folder/LookAt/heading", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"clampToGround", (String)"//kml/Folder/LookAt/altitudeMode", (Document)dom);
        XMLAssert.assertXpathExists((String)"//kml/Folder/LookAt/range", (Document)dom);
    }

    public void testEncodeAsOverlay() throws Exception {
        XpathEngine xpath = XMLUnit.newXpathEngine();
        WMS wms = this.mockData.getWMS();
        KMLNetworkLinkTransformer transformer = new KMLNetworkLinkTransformer(wms, this.mapContext);
        transformer.setEncodeAsRegion(false);
        transformer.setIndentation(2);
        this.request.setBbox(new Envelope(-1.0, 1.0, -10.0, 10.0));
        Document dom = WMSTestSupport.transform(this.request, (TransformerBase)transformer);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//kml/Folder)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//kml/Folder/NetworkLink)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//kml/Folder/LookAt)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"geos:TestPoints", (String)"//kml/Folder/NetworkLink/name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"//kml/Folder/NetworkLink/open", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"//kml/Folder/NetworkLink/visibility", (Document)dom);
        Map<String, String> expectedKvp = KMLReflectorTest.toKvp("http://geoserver.org:8181/geoserver/wms?format_options=relLinks%3Atrue%3B&service=wms&srs=EPSG%3A4326&width=512&styles=Default+Style&height=256&transparent=false&request=GetMap&layers=geos%3ATestPoints&format=application%2Fvnd.google-earth.kmz&version=1.1.1");
        Map<String, String> actualKvp = KMLReflectorTest.toKvp(xpath.evaluate("//kml/Folder/NetworkLink/Url/href", dom));
        KMLReflectorTest.assertMapsEqual(expectedKvp, actualKvp);
        XMLAssert.assertXpathEvaluatesTo((String)"onStop", (String)"//kml/Folder/NetworkLink/Url/viewRefreshMode", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"//kml/Folder/NetworkLink/Url/viewRefreshTime", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"180.0", (String)"//kml/Folder/LookAt/longitude", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"0.0", (String)"//kml/Folder/LookAt/latitude", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"//kml/Folder/LookAt/altitude", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"//kml/Folder/LookAt/tilt", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"//kml/Folder/LookAt/heading", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"clampToGround", (String)"//kml/Folder/LookAt/altitudeMode", (Document)dom);
        XMLAssert.assertXpathExists((String)"//kml/Folder/LookAt/range", (Document)dom);
    }

    public void testKmltitleFormatOption() throws Exception {
        WMS wms = this.mockData.getWMS();
        KMLNetworkLinkTransformer transformer = new KMLNetworkLinkTransformer(wms, this.mapContext);
        transformer.setEncodeAsRegion(false);
        transformer.setIndentation(2);
        this.request.setBbox(new Envelope(-1.0, 1.0, -10.0, 10.0));
        HashMap<String, String> formatOptions = new HashMap<String, String>();
        formatOptions.put("kmltitle", "myCustomLayerTitle");
        this.request.setFormatOptions(formatOptions);
        Document dom = WMSTestSupport.transform(this.request, (TransformerBase)transformer);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//kml/Folder/name)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"myCustomLayerTitle", (String)"//kml/Folder/name", (Document)dom);
    }
}

