/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses.map.georss;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.transform.TransformerException;
import org.geoserver.platform.ServiceException;
import org.geoserver.wms.WMS;
import org.vfny.geoserver.wms.GetMapProducer;
import org.vfny.geoserver.wms.WMSMapContext;
import org.vfny.geoserver.wms.WmsException;
import org.vfny.geoserver.wms.requests.GetMapRequest;
import org.vfny.geoserver.wms.responses.map.georss.GeoRSSTransformerBase;
import org.vfny.geoserver.wms.responses.map.georss.RSSGeoRSSTransformer;

public class RSSGeoRSSMapProducer
implements GetMapProducer {
    private static String MIME_TYPE = "application/xml";
    public static final Set<String> FORMAT_NAMES;
    WMSMapContext map;
    private String outputFormat = "application/rss+xml";

    @Override
    public String getContentType() throws IllegalStateException {
        return MIME_TYPE;
    }

    @Override
    public void produceMap() throws WmsException {
    }

    @Override
    public void writeTo(OutputStream out) throws ServiceException, IOException {
        RSSGeoRSSTransformer tx = new RSSGeoRSSTransformer();
        GetMapRequest request = this.map.getRequest();
        String geometryEncoding = (String)request.getFormatOptions().get("encoding");
        if ("gml".equals(geometryEncoding)) {
            tx.setGeometryEncoding(GeoRSSTransformerBase.GeometryEncoding.GML);
        } else if ("latlong".equals(geometryEncoding)) {
            tx.setGeometryEncoding(GeoRSSTransformerBase.GeometryEncoding.LATLONG);
        } else {
            tx.setGeometryEncoding(GeoRSSTransformerBase.GeometryEncoding.SIMPLE);
        }
        WMS wms = request.getWMS();
        Charset encoding = wms.getCharSet();
        tx.setEncoding(encoding);
        try {
            tx.transform((Object)this.map, out);
        }
        catch (TransformerException e) {
            throw (IOException)new IOException().initCause(e);
        }
    }

    @Override
    public void abort() {
    }

    @Override
    public String getContentDisposition() {
        return "inline; filename=geoserver.xml";
    }

    @Override
    public WMSMapContext getMapContext() {
        return this.map;
    }

    @Override
    public void setMapContext(WMSMapContext mapContext) {
        this.map = mapContext;
    }

    @Override
    public String getOutputFormat() {
        return this.outputFormat;
    }

    @Override
    public void setOutputFormat(String format) {
        if (!FORMAT_NAMES.contains(format)) {
            throw new IllegalArgumentException(format + " is not supported by " + this.getClass().getSimpleName());
        }
        this.outputFormat = format;
    }

    @Override
    public Set<String> getOutputFormatNames() {
        return FORMAT_NAMES;
    }

    static {
        String[] FORMATS = new String[]{"application/rss+xml", "rss", "application/rss xml"};
        TreeSet<String> names = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        names.addAll(Arrays.asList(FORMATS));
        FORMAT_NAMES = Collections.unmodifiableSet(names);
    }
}

