/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses.map.metatile;

import com.vividsolutions.jts.geom.Envelope;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.awt.image.RenderedImage;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.geoserver.config.ConfigurationListener;
import org.geoserver.config.ConfigurationListenerAdapter;
import org.geoserver.config.GeoServer;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.config.ServiceInfo;
import org.geoserver.wfs.TransactionEvent;
import org.geoserver.wfs.TransactionListener;
import org.geoserver.wfs.WFSException;
import org.geotools.util.CanonicalSet;
import org.geotools.util.SoftValueHashMap;
import org.vfny.geoserver.wms.requests.GetMapRequest;

public class QuickTileCache
implements TransactionListener {
    private static final Set ignoredParameters = new HashSet();
    private CanonicalSet<MetaTileKey> metaTileKeys = CanonicalSet.newInstance(MetaTileKey.class);
    private SoftValueHashMap tileCache = new SoftValueHashMap(0);

    public QuickTileCache(GeoServer geoServer) {
        geoServer.addListener((ConfigurationListener)new ConfigurationListenerAdapter(){

            public void handleGlobalChange(GeoServerInfo global, List<String> propertyNames, List<Object> oldValues, List<Object> newValues) {
                QuickTileCache.this.tileCache.clear();
            }

            public void handleServiceChange(ServiceInfo service, List<String> propertyNames, List<Object> oldValues, List<Object> newValues) {
                QuickTileCache.this.tileCache.clear();
            }

            public void reloaded() {
                QuickTileCache.this.tileCache.clear();
            }
        });
    }

    QuickTileCache() {
    }

    public MetaTileKey getMetaTileKey(GetMapRequest request) {
        String mapDefinition = this.buildMapDefinition(request.getHttpServletRequest());
        Envelope bbox = request.getBbox();
        Point2D origin = request.getTilesOrigin();
        MapKey mapKey = new MapKey(mapDefinition, QuickTileCache.normalize(bbox.getWidth() / (double)request.getWidth()), origin);
        Point tileCoords = this.getTileCoordinates(bbox, origin);
        Point metaTileCoords = this.getMetaTileCoordinates(tileCoords);
        Envelope metaTileEnvelope = this.getMetaTileEnvelope(request, tileCoords, metaTileCoords);
        MetaTileKey key = new MetaTileKey(mapKey, metaTileCoords, metaTileEnvelope);
        return (MetaTileKey)this.metaTileKeys.unique((Object)key);
    }

    private Envelope getMetaTileEnvelope(GetMapRequest request, Point tileCoords, Point metaTileCoords) {
        Envelope bbox = request.getBbox();
        double minx = bbox.getMinX() + (double)(metaTileCoords.x - tileCoords.x) * bbox.getWidth();
        double miny = bbox.getMinY() + (double)(metaTileCoords.y - tileCoords.y) * bbox.getHeight();
        double maxx = minx + bbox.getWidth() * 3.0;
        double maxy = miny + bbox.getHeight() * 3.0;
        return new Envelope(minx, maxx, miny, maxy);
    }

    Point getMetaTileCoordinates(Point tileCoords) {
        int mtx;
        int x = tileCoords.x;
        int y = tileCoords.y;
        int rx = x % 3;
        int ry = y % 3;
        int n = rx == 0 ? x : (mtx = x >= 0 ? x - rx : x - 3 - rx);
        int mty = ry == 0 ? y : (y >= 0 ? y - ry : y - 3 - ry);
        return new Point(mtx, mty);
    }

    Point getTileCoordinates(Envelope env, Point2D origin) {
        double centerx = env.getMinX() + env.getWidth() / 2.0;
        double centery = env.getMinY() + env.getHeight() / 2.0;
        int x = (int)Math.floor((centerx - origin.getX()) / env.getWidth());
        int y = (int)Math.floor((centery - origin.getY()) / env.getWidth());
        return new Point(x, y);
    }

    static double normalize(double d) {
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            return d;
        }
        return (double)Math.round(d * 1.0E7) / 1.0E7;
    }

    private String buildMapDefinition(HttpServletRequest request) {
        StringBuffer sb = new StringBuffer();
        Enumeration en = request.getParameterNames();
        while (en.hasMoreElements()) {
            String paramName = (String)en.nextElement();
            if (ignoredParameters.contains(paramName.toUpperCase())) continue;
            sb.append(paramName).append('=').append(request.getParameter(paramName));
            if (!en.hasMoreElements()) continue;
            sb.append('&');
        }
        return sb.toString();
    }

    public synchronized RenderedImage getTile(MetaTileKey key, GetMapRequest request) {
        CacheElement ce = (CacheElement)this.tileCache.get((Object)key);
        if (ce == null) {
            return null;
        }
        return this.getTile(key, request, ce.tiles);
    }

    public RenderedImage getTile(MetaTileKey key, GetMapRequest request, RenderedImage[] tiles) {
        Point tileCoord = this.getTileCoordinates(request.getBbox(), key.mapKey.origin);
        Point metaCoord = key.metaTileCoords;
        return tiles[tileCoord.x - metaCoord.x + (tileCoord.y - metaCoord.y) * key.getMetaFactor()];
    }

    public synchronized void storeTiles(MetaTileKey key, RenderedImage[] tiles) {
        this.tileCache.put((Object)key, (Object)new CacheElement(tiles));
    }

    public void dataStoreChange(TransactionEvent event) throws WFSException {
        this.tileCache.clear();
    }

    static {
        ignoredParameters.add("REQUEST");
        ignoredParameters.add("TILED");
        ignoredParameters.add("BBOX");
        ignoredParameters.add("WIDTH");
        ignoredParameters.add("HEIGHT");
        ignoredParameters.add("SERVICE");
        ignoredParameters.add("VERSION");
        ignoredParameters.add("EXCEPTIONS");
    }

    class CacheElement {
        RenderedImage[] tiles;

        public CacheElement(RenderedImage[] tiles) {
            this.tiles = tiles;
        }
    }

    static class MetaTileKey {
        MapKey mapKey;
        Point metaTileCoords;
        Envelope metaTileEnvelope;

        public MetaTileKey(MapKey mapKey, Point metaTileCoords, Envelope metaTileEnvelope) {
            this.mapKey = mapKey;
            this.metaTileCoords = metaTileCoords;
            this.metaTileEnvelope = metaTileEnvelope;
        }

        public Envelope getMetaTileEnvelope() {
            return this.metaTileEnvelope;
        }

        public int hashCode() {
            return new HashCodeBuilder().append((Object)this.mapKey).append((Object)this.metaTileCoords).toHashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof MetaTileKey)) {
                return false;
            }
            MetaTileKey other = (MetaTileKey)obj;
            return new EqualsBuilder().append((Object)this.mapKey, (Object)other.mapKey).append((Object)this.metaTileCoords, (Object)other.metaTileCoords).isEquals();
        }

        public int getMetaFactor() {
            return 3;
        }

        public int getTileSize() {
            return 256;
        }

        public String toString() {
            return this.mapKey + "\nmtc:" + this.metaTileCoords.x + "," + this.metaTileCoords.y;
        }
    }

    static class MapKey {
        String mapDefinition;
        double resolution;
        Point2D origin;

        public MapKey(String mapDefinition, double resolution, Point2D origin) {
            this.mapDefinition = mapDefinition;
            this.resolution = resolution;
            this.origin = origin;
        }

        public int hashCode() {
            return new HashCodeBuilder().append((Object)this.mapDefinition).append(this.resolution).append(this.resolution).append((Object)this.origin).toHashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof MapKey)) {
                return false;
            }
            MapKey other = (MapKey)obj;
            return new EqualsBuilder().append((Object)this.mapDefinition, (Object)other.mapDefinition).append(this.resolution, other.resolution).append((Object)this.origin, (Object)other.origin).isEquals();
        }

        public String toString() {
            return this.mapDefinition + "\nw:" + "\nresolution:" + this.resolution + "\norig:" + this.origin.getX() + "," + this.origin.getY();
        }
    }
}

