/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses.map;

import com.vividsolutions.jts.geom.Envelope;
import java.awt.Color;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import junit.framework.Test;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.security.decorators.DecoratingFeatureSource;
import org.geoserver.test.OneTimeSetupTest;
import org.geoserver.wms.WMS;
import org.geoserver.wms.WMSTestSupport;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.filter.IllegalFilterException;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.FeatureSourceMapLayer;
import org.geotools.map.MapLayer;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.styling.Style;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.TransformException;
import org.vfny.geoserver.wms.WMSMapContext;
import org.vfny.geoserver.wms.WmsException;
import org.vfny.geoserver.wms.requests.GetMapRequest;
import org.vfny.geoserver.wms.responses.DefaultRasterMapProducer;

public class DefaultRasterMapProducerTest
extends WMSTestSupport {
    private static final int SHOW_TIMEOUT = 200;
    private static final boolean INTERACTIVE = false;
    private static final Logger LOGGER = Logging.getLogger((String)DefaultRasterMapProducerTest.class.getPackage().getName());
    private static final Color BG_COLOR = Color.white;
    private DefaultRasterMapProducer rasterMapProducer;

    public static Test suite() {
        return new OneTimeSetupTest.OneTimeTestSetup((OneTimeSetupTest)new DefaultRasterMapProducerTest());
    }

    public void setUpInternal() throws Exception {
        super.setUpInternal();
        this.rasterMapProducer = this.getProducerInstance();
    }

    protected DefaultRasterMapProducer getProducerInstance() {
        return new DummyRasterMapProducer(this.getWMS());
    }

    public void tearDownInternal() throws Exception {
        this.rasterMapProducer = null;
        super.tearDownInternal();
    }

    public void testSimpleGetMapQuery() throws Exception {
        String mapFormat = "image/gif";
        Catalog catalog = this.getCatalog();
        FeatureSource fs = catalog.getFeatureTypeByName(MockData.BASIC_POLYGONS.getPrefix(), MockData.BASIC_POLYGONS.getLocalPart()).getFeatureSource(null, null);
        ReferencedEnvelope env = fs.getBounds();
        LOGGER.info("about to create map ctx for BasicPolygons with bounds " + env);
        WMSMapContext map = new WMSMapContext();
        map.setAreaOfInterest((Envelope)env);
        map.setMapWidth(300);
        map.setMapHeight(300);
        map.setBgColor(Color.red);
        map.setTransparent(false);
        map.setRequest(new GetMapRequest(this.getWMS()));
        StyleInfo styleByName = catalog.getStyleByName("Default");
        Style basicStyle = styleByName.getStyle();
        map.addLayer(fs, basicStyle);
        this.rasterMapProducer.setOutputFormat("image/gif");
        this.rasterMapProducer.setMapContext(map);
        this.rasterMapProducer.produceMap();
        this.assertNotBlank("testSimpleGetMapQuery", this.rasterMapProducer);
    }

    public void testDefaultStyle() throws Exception {
        List typeInfos = this.getCatalog().getFeatureTypes();
        for (FeatureTypeInfo info : typeInfos) {
            if (!info.getQualifiedName().getNamespaceURI().equals(MockData.CITE_URI) || info.getFeatureType().getGeometryDescriptor() == null) continue;
            this.testDefaultStyle(info.getFeatureSource(null, null));
        }
    }

    public void testBlueLake() throws IOException, IllegalFilterException, Exception {
        Catalog catalog = this.getCatalog();
        FeatureTypeInfo typeInfo = catalog.getFeatureTypeByName(MockData.LAKES.getNamespaceURI(), MockData.LAKES.getLocalPart());
        ReferencedEnvelope env = typeInfo.getFeatureSource(null, null).getBounds();
        double shift = env.getWidth() / 6.0;
        env = new Envelope(env.getMinX() - shift, env.getMaxX() + shift, env.getMinY() - shift, env.getMaxY() + shift);
        WMSMapContext map = new WMSMapContext();
        int w = 400;
        int h = (int)Math.round(env.getHeight() * (double)w / env.getWidth());
        map.setMapWidth(w);
        map.setMapHeight(h);
        map.setBgColor(BG_COLOR);
        map.setTransparent(true);
        map.setRequest(new GetMapRequest(this.getWMS()));
        this.addToMap(map, MockData.FORESTS);
        this.addToMap(map, MockData.LAKES);
        this.addToMap(map, MockData.STREAMS);
        this.addToMap(map, MockData.NAMED_PLACES);
        this.addToMap(map, MockData.ROAD_SEGMENTS);
        this.addToMap(map, MockData.PONDS);
        this.addToMap(map, MockData.BUILDINGS);
        this.addToMap(map, MockData.DIVIDED_ROUTES);
        this.addToMap(map, MockData.BRIDGES);
        this.addToMap(map, MockData.MAP_NEATLINE);
        map.setAreaOfInterest((Envelope)env);
        this.rasterMapProducer.setOutputFormat("image/gif");
        this.rasterMapProducer.setMapContext(map);
        this.rasterMapProducer.produceMap();
        this.assertNotBlank("testBlueLake", this.rasterMapProducer);
    }

    private void addToMap(WMSMapContext map, QName typeName) throws IOException {
        FeatureTypeInfo ftInfo = this.getCatalog().getFeatureTypeByName(typeName.getNamespaceURI(), typeName.getLocalPart());
        List layers = this.getCatalog().getLayers((ResourceInfo)ftInfo);
        StyleInfo defaultStyle = ((LayerInfo)layers.get(0)).getDefaultStyle();
        Style style = defaultStyle.getStyle();
        map.addLayer((MapLayer)new FeatureSourceMapLayer(ftInfo.getFeatureSource(null, null), style));
    }

    protected void assertNotBlank(String testName, DefaultRasterMapProducer producer) {
        BufferedImage image = (BufferedImage)producer.getImage();
        this.assertNotBlank(testName, image, BG_COLOR);
        this.showImage(testName, image);
    }

    protected void showImage(String frameName, BufferedImage image) {
        this.showImage(frameName, 200L, image);
    }

    protected void showImage(String frameName, long timeOut, BufferedImage image) {
        int width = image.getWidth();
        int height = image.getHeight();
        if (System.getProperty("java.awt.headless") == null || !System.getProperty("java.awt.headless").equals("true")) {
            // empty if block
        }
    }

    private void testDefaultStyle(FeatureSource fSource) throws Exception {
        Catalog catalog = this.getCatalog();
        Style style = catalog.getStyleByName("Default").getStyle();
        FeatureTypeInfo typeInfo = catalog.getFeatureTypeByName(MockData.LAKES.getNamespaceURI(), MockData.LAKES.getLocalPart());
        ReferencedEnvelope env = typeInfo.getFeatureSource(null, null).getBounds();
        env.expandToInclude((Envelope)fSource.getBounds());
        int w = 400;
        int h = (int)Math.round(env.getHeight() * (double)w / env.getWidth());
        double shift = env.getWidth() / 6.0;
        env = new Envelope(env.getMinX() - shift, env.getMaxX() + shift, env.getMinY() - shift, env.getMaxY() + shift);
        WMSMapContext map = new WMSMapContext();
        map.setRequest(new GetMapRequest(this.getWMS()));
        map.addLayer(fSource, style);
        map.setAreaOfInterest((Envelope)env);
        map.setMapWidth(w);
        map.setMapHeight(h);
        map.setBgColor(BG_COLOR);
        map.setTransparent(false);
        this.rasterMapProducer.setOutputFormat("image/gif");
        this.rasterMapProducer.setMapContext(map);
        this.rasterMapProducer.produceMap();
        RenderedImage image = this.rasterMapProducer.getImage();
        String typeName = fSource.getSchema().getName().getLocalPart();
        this.assertNotBlank("testDefaultStyle " + typeName, this.rasterMapProducer);
    }

    public void testRenderingErrorsHandling() throws Exception {
        DefaultRasterMapProducerTest.assertNotNull((Object)this.forceRenderingError((Exception)new TransformException("fake transform exception")));
        DefaultRasterMapProducerTest.assertNotNull((Object)this.forceRenderingError(new NoninvertibleTransformException("fake non invertible exception")));
        DefaultRasterMapProducerTest.assertNotNull((Object)this.forceRenderingError((Exception)new IllegalAttributeException("non illegal attribute exception")));
        DefaultRasterMapProducerTest.assertNotNull((Object)this.forceRenderingError((Exception)new FactoryException("fake factory exception")));
        try {
            this.forceRenderingError(new RuntimeException("fake runtime exception"));
            DefaultRasterMapProducerTest.fail((String)"Expected WMSException");
        }
        catch (WmsException e) {
            DefaultRasterMapProducerTest.assertTrue((boolean)true);
        }
        try {
            this.forceRenderingError(new IOException("fake IO exception"));
            DefaultRasterMapProducerTest.fail((String)"Expected WMSException");
        }
        catch (WmsException e) {
            DefaultRasterMapProducerTest.assertTrue((boolean)true);
        }
        try {
            this.forceRenderingError(new IllegalArgumentException("fake IAE exception"));
            DefaultRasterMapProducerTest.fail((String)"Expected WMSException");
        }
        catch (WmsException e) {
            DefaultRasterMapProducerTest.assertTrue((boolean)true);
        }
    }

    private RenderedImage forceRenderingError(final Exception renderExceptionToThrow) throws Exception {
        WMSMapContext map = new WMSMapContext();
        map.setMapWidth(100);
        map.setMapHeight(100);
        map.setRequest(new GetMapRequest(this.getWMS()));
        ReferencedEnvelope bounds = new ReferencedEnvelope(-180.0, 180.0, -90.0, 90.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        map.setAreaOfInterest(bounds);
        FeatureTypeInfo ftInfo = this.getCatalog().getFeatureTypeByName(MockData.STREAMS.getNamespaceURI(), MockData.STREAMS.getLocalPart());
        FeatureSource featureSource = ftInfo.getFeatureSource(null, null);
        DecoratingFeatureSource<SimpleFeatureType, SimpleFeature> source = new DecoratingFeatureSource<SimpleFeatureType, SimpleFeature>(featureSource){

            public FeatureCollection<SimpleFeatureType, SimpleFeature> getFeatures(Query query) throws IOException {
                throw new RuntimeException(renderExceptionToThrow);
            }
        };
        StyleInfo someStyle = (StyleInfo)this.getCatalog().getStyles().get(0);
        map.addLayer((FeatureSource)source, someStyle.getStyle());
        this.rasterMapProducer.setOutputFormat("image/gif");
        this.rasterMapProducer.setMapContext(map);
        this.rasterMapProducer.produceMap();
        return this.rasterMapProducer.getImage();
    }

    private static class DummyRasterMapProducer
    extends DefaultRasterMapProducer {
        public DummyRasterMapProducer(WMS wms) {
            super("image/gif", new String[]{"image/gif"}, wms);
        }

        public void formatImageOutputStream(RenderedImage image, OutputStream outStream) throws WmsException, IOException {
        }

        public String getContentDisposition() {
            return null;
        }
    }
}

