/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses.map.kml;

import com.mockrunner.mock.web.MockHttpServletRequest;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Point;
import java.io.File;
import java.util.Collections;
import java.util.Map;
import junit.framework.Test;
import org.custommonkey.xmlunit.XMLAssert;
import org.custommonkey.xmlunit.XMLUnit;
import org.custommonkey.xmlunit.XpathEngine;
import org.geoserver.data.test.TestData;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.test.GeoServerAbstractTestSupport;
import org.geoserver.test.OneTimeSetupTest;
import org.geoserver.wms.MapLayerInfo;
import org.geoserver.wms.WMSMockData;
import org.geoserver.wms.WMSTestSupport;
import org.geotools.xml.transform.TransformerBase;
import org.vfny.geoserver.wms.WMSMapContext;
import org.vfny.geoserver.wms.requests.GetMapRequest;
import org.vfny.geoserver.wms.responses.map.kml.KMLNetworkLinkTransformer;
import org.vfny.geoserver.wms.responses.map.kml.KMLReflectorTest;
import org.w3c.dom.Document;

public class KMLNetworkLinkTransformerTest
extends GeoServerAbstractTestSupport {
    private WMSMockData mockData;
    private GetMapRequest request;

    public static Test suite() {
        return new OneTimeSetupTest.OneTimeTestSetup((OneTimeSetupTest)new KMLNetworkLinkTransformerTest());
    }

    protected TestData buildTestData() throws Exception {
        return new TestData(){

            public File getDataDirectoryRoot() {
                return null;
            }

            public boolean isTestDataAvailable() {
                return false;
            }

            public void setUp() throws Exception {
            }

            public void tearDown() throws Exception {
            }
        };
    }

    protected void setUpInternal() throws Exception {
        this.mockData = new WMSMockData();
        this.mockData.setUp();
        MapLayerInfo layer = this.mockData.addFeatureTypeLayer("TestPoints", Point.class);
        WMSMapContext mapContext = new WMSMapContext();
        this.request = this.mockData.createRequest();
        this.request.setLayers(new MapLayerInfo[]{layer});
        this.request.setFormatOptions(Collections.singletonMap("relLinks", "true"));
        MockHttpServletRequest httpreq = (MockHttpServletRequest)this.request.getHttpServletRequest();
        httpreq.setScheme("http");
        httpreq.setServerName("geoserver.org");
        httpreq.setServerPort(8181);
        httpreq.setContextPath("/geoserver");
        mapContext.setRequest(this.request);
    }

    protected void tearDownInternal() throws Exception {
        new GeoServerExtensions().setApplicationContext(null);
    }

    public void testEncodeAsRegion() throws Exception {
        XpathEngine xpath = XMLUnit.newXpathEngine();
        KMLNetworkLinkTransformer transformer = new KMLNetworkLinkTransformer();
        transformer.setEncodeAsRegion(true);
        transformer.setIndentation(2);
        this.request.setBbox(new Envelope(-1.0, 1.0, -10.0, 10.0));
        Document dom = WMSTestSupport.transform(this.request, (TransformerBase)transformer);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//kml/Folder)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//kml/Folder/NetworkLink)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//kml/Folder/LookAt)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"geos:TestPoints", (String)"//kml/Folder/NetworkLink/name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"//kml/Folder/NetworkLink/open", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"//kml/Folder/NetworkLink/visibility", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"10.0", (String)"//kml/Folder/NetworkLink/Region/LatLonAltBox/north", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"-10.0", (String)"//kml/Folder/NetworkLink/Region/LatLonAltBox/south", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1.0", (String)"//kml/Folder/NetworkLink/Region/LatLonAltBox/east", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"-1.0", (String)"//kml/Folder/NetworkLink/Region/LatLonAltBox/west", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"256", (String)"//kml/Folder/NetworkLink/Region/Lod/minLodPixels", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"-1", (String)"//kml/Folder/NetworkLink/Region/Lod/maxLodPixels", (Document)dom);
        Map<String, String> expectedKvp = KMLReflectorTest.toKvp("http://geoserver.org:8181/geoserver/wms?format_options=relLinks%3Atrue%3B&service=wms&srs=EPSG%3A4326&width=512&styles=Default+Style&height=256&transparent=false&bbox=-1.0%2C-10.0%2C1.0%2C10.0&request=GetMap&layers=geos%3ATestPoints&format=image%2Fdummy&version=1.1.1");
        Map<String, String> actualKvp = KMLReflectorTest.toKvp(xpath.evaluate("//kml/Folder/NetworkLink/Link/href", dom));
        KMLReflectorTest.assertMapsEqual(expectedKvp, actualKvp);
        XMLAssert.assertXpathEvaluatesTo((String)"onRegion", (String)"//kml/Folder/NetworkLink/Link/viewRefreshMode", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"180.0", (String)"//kml/Folder/LookAt/longitude", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"0.0", (String)"//kml/Folder/LookAt/latitude", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"//kml/Folder/LookAt/altitude", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"//kml/Folder/LookAt/tilt", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"//kml/Folder/LookAt/heading", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"clampToGround", (String)"//kml/Folder/LookAt/altitudeMode", (Document)dom);
        XMLAssert.assertXpathExists((String)"//kml/Folder/LookAt/range", (Document)dom);
    }

    public void testEncodeAsOverlay() throws Exception {
        XpathEngine xpath = XMLUnit.newXpathEngine();
        KMLNetworkLinkTransformer transformer = new KMLNetworkLinkTransformer();
        transformer.setEncodeAsRegion(false);
        transformer.setIndentation(2);
        this.request.setBbox(new Envelope(-1.0, 1.0, -10.0, 10.0));
        Document dom = WMSTestSupport.transform(this.request, (TransformerBase)transformer);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//kml/Folder)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//kml/Folder/NetworkLink)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//kml/Folder/LookAt)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"geos:TestPoints", (String)"//kml/Folder/NetworkLink/name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"//kml/Folder/NetworkLink/open", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"//kml/Folder/NetworkLink/visibility", (Document)dom);
        Map<String, String> expectedKvp = KMLReflectorTest.toKvp("http://geoserver.org:8181/geoserver/wms?format_options=relLinks%3Atrue%3B&service=wms&srs=EPSG%3A4326&width=512&styles=Default+Style&height=256&transparent=false&request=GetMap&layers=geos%3ATestPoints&format=image%2Fdummy&version=1.1.1");
        Map<String, String> actualKvp = KMLReflectorTest.toKvp(xpath.evaluate("//kml/Folder/NetworkLink/Url/href", dom));
        KMLReflectorTest.assertMapsEqual(expectedKvp, actualKvp);
        XMLAssert.assertXpathEvaluatesTo((String)"onStop", (String)"//kml/Folder/NetworkLink/Url/viewRefreshMode", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"//kml/Folder/NetworkLink/Url/viewRefreshTime", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"180.0", (String)"//kml/Folder/LookAt/longitude", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"0.0", (String)"//kml/Folder/LookAt/latitude", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"//kml/Folder/LookAt/altitude", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"//kml/Folder/LookAt/tilt", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"//kml/Folder/LookAt/heading", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"clampToGround", (String)"//kml/Folder/LookAt/altitudeMode", (Document)dom);
        XMLAssert.assertXpathExists((String)"//kml/Folder/LookAt/range", (Document)dom);
    }
}

