/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses.map.kml;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.zip.ZipFile;
import javax.xml.namespace.QName;
import junit.framework.Test;
import org.geoserver.data.test.MockData;
import org.geoserver.test.OneTimeSetupTest;
import org.geoserver.wms.WMSTestSupport;
import org.vfny.geoserver.wms.WMSMapContext;
import org.vfny.geoserver.wms.requests.GetMapRequest;
import org.vfny.geoserver.wms.responses.map.kml.KMZMapProducer;

public class KMZMapProducerTest
extends WMSTestSupport {
    KMZMapProducer mapProducer;

    public static Test suite() {
        return new OneTimeSetupTest.OneTimeTestSetup((OneTimeSetupTest)new KMZMapProducerTest());
    }

    protected void setUpInternal() throws Exception {
        super.setUpInternal();
        WMSMapContext mapContext = new WMSMapContext();
        mapContext.addLayer(this.createMapLayer(MockData.BASIC_POLYGONS));
        mapContext.addLayer(this.createMapLayer(MockData.BUILDINGS));
        mapContext.setMapHeight(256);
        mapContext.setMapWidth(256);
        GetMapRequest getMapRequest = this.createGetMapRequest(new QName[]{MockData.BASIC_POLYGONS, MockData.BUILDINGS});
        mapContext.setRequest(getMapRequest);
        this.mapProducer = new KMZMapProducer(this.getWMS());
        this.mapProducer.setMapContext(mapContext);
        this.mapProducer.produceMap();
    }

    public void test() throws Exception {
        File temp = File.createTempFile("test", "kmz");
        temp.delete();
        temp.mkdir();
        temp.deleteOnExit();
        File zip = new File(temp, "kmz.zip");
        zip.deleteOnExit();
        FileOutputStream output = new FileOutputStream(zip);
        this.mapProducer.writeTo((OutputStream)output);
        output.flush();
        output.close();
        KMZMapProducerTest.assertTrue((boolean)zip.exists());
        ZipFile zipFile = new ZipFile(zip);
        KMZMapProducerTest.assertNotNull((Object)zipFile.getEntry("wms.kml"));
        KMZMapProducerTest.assertNotNull((Object)zipFile.getEntry("layer_0.png"));
        KMZMapProducerTest.assertNotNull((Object)zipFile.getEntry("layer_1.png"));
        zipFile.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAbort() throws Exception {
        this.mapProducer.abort();
        FileOutputStream output = null;
        try {
            File temp = File.createTempFile("test", "kmz");
            temp.delete();
            temp.mkdir();
            temp.deleteOnExit();
            File zip = new File(temp, "kmz.zip");
            output = new FileOutputStream(zip);
            this.mapProducer.writeTo((OutputStream)output);
        }
        catch (NullPointerException we) {
            return;
        }
        finally {
            if (output != null) {
                output.close();
            }
        }
        KMZMapProducerTest.fail();
    }

    public void testContentDisposition() {
        String contentDisposition = this.mapProducer.getContentDisposition();
        KMZMapProducerTest.assertTrue((boolean)contentDisposition.startsWith("attachment; filename="));
        KMZMapProducerTest.assertTrue((boolean)contentDisposition.endsWith(".kmz"));
    }
}

