/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses.palette;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import junit.framework.TestCase;
import org.vfny.geoserver.wms.responses.palette.CustomPaletteBuilder;

public class CustomPaletteBuilderTest
extends TestCase {
    public void testOneColorBug() {
        BufferedImage image = new BufferedImage(256, 256, 6);
        CustomPaletteBuilder builder = new CustomPaletteBuilder((RenderedImage)image, 256, 1, 1, 1);
        builder.buildPalette();
        RenderedImage indexed = builder.getIndexedImage();
        CustomPaletteBuilderTest.assertTrue((boolean)(indexed.getColorModel() instanceof IndexColorModel));
        IndexColorModel icm = (IndexColorModel)indexed.getColorModel();
        CustomPaletteBuilderTest.assertEquals((int)2, (int)icm.getMapSize());
    }

    public void testFourColor() {
        BufferedImage image = new BufferedImage(256, 256, 6);
        Graphics g = image.getGraphics();
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, 10, 10);
        g.setColor(Color.RED);
        g.fillRect(10, 0, 10, 10);
        g.setColor(Color.BLUE);
        g.fillRect(20, 0, 10, 10);
        g.setColor(Color.GREEN);
        g.fillRect(30, 0, 10, 10);
        g.dispose();
        CustomPaletteBuilder builder = new CustomPaletteBuilder((RenderedImage)image, 256, 1, 1, 1);
        builder.buildPalette();
        RenderedImage indexed = builder.getIndexedImage();
        CustomPaletteBuilderTest.assertTrue((boolean)(indexed.getColorModel() instanceof IndexColorModel));
        IndexColorModel icm = (IndexColorModel)indexed.getColorModel();
        CustomPaletteBuilderTest.assertEquals((int)5, (int)icm.getMapSize());
    }
}

