/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses;

import org.custommonkey.xmlunit.XMLAssert;
import org.custommonkey.xmlunit.XMLUnit;
import org.custommonkey.xmlunit.XpathEngine;
import org.geoserver.catalog.AttributionInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.wms.WMSTestSupport;
import org.w3c.dom.Document;

public class GetCapabilitiesTest
extends WMSTestSupport {
    protected void populateDataDirectory(MockData dataDirectory) throws Exception {
        super.populateDataDirectory(dataDirectory);
        dataDirectory.disableDataStore(MockData.CITE_PREFIX);
    }

    public void testGet() throws Exception {
        Document doc = this.getAsDOM("wms?service=WMS&request=getCapabilities", true);
        GetCapabilitiesTest.assertEquals((String)"WMT_MS_Capabilities", (String)doc.getDocumentElement().getNodeName());
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"count(//Name[text()='cite:Buildings'])", (Document)doc);
    }

    public void testAttribution() throws Exception {
        Document doc = this.getAsDOM("wms?service=WMS&request=getCapabilities", true);
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"count(//Attribution)", (Document)doc);
        LayerInfo points = this.getCatalog().getLayerByName(MockData.POINTS.getLocalPart());
        AttributionInfo attr = points.getAttribution();
        attr.setTitle("Point Provider");
        this.getCatalog().save(points);
        doc = this.getAsDOM("wms?service=WMS&request=getCapabilities", true);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//Attribution)", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//Attribution/Title)", (Document)doc);
        attr = points.getAttribution();
        attr.setHref("http://example.com/points/provider");
        this.getCatalog().save(points);
        doc = this.getAsDOM("wms?service=WMS&request=getCapabilities", true);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//Attribution)", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//Attribution/Title)", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//Attribution/OnlineResource)", (Document)doc);
        attr = points.getAttribution();
        attr.setLogoURL("http://example.com/points/logo");
        attr.setLogoType("image/logo");
        attr.setLogoHeight(50);
        attr.setLogoWidth(50);
        this.getCatalog().save(points);
        doc = this.getAsDOM("wms?service=WMS&request=getCapabilities", true);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//Attribution)", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//Attribution/Title)", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//Attribution/LogoURL)", (Document)doc);
    }

    public void testAlternateStyles() throws Exception {
        StyleInfo pointStyle = this.getCatalog().getStyleByName("point");
        LayerInfo layer = this.getCatalog().getLayerByName("Fifteen");
        layer.getStyles().add(pointStyle);
        this.getCatalog().save(layer);
        Document doc = this.getAsDOM("wms?service=WMS&request=getCapabilities", true);
        this.print(doc);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//Layer[Name='cdf:Fifteen'])", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"2", (String)"count(//Layer[Name='cdf:Fifteen']/Style)", (Document)doc);
        XpathEngine xpath = XMLUnit.newXpathEngine();
        String href = xpath.evaluate("//Layer[Name='cdf:Fifteen']/Style[Name='Default']/LegendURL/OnlineResource/@xlink:href", doc);
        GetCapabilitiesTest.assertTrue((boolean)href.contains("GetLegendGraphic"));
        GetCapabilitiesTest.assertTrue((boolean)href.contains("layer=Fifteen"));
        GetCapabilitiesTest.assertFalse((boolean)href.contains("style"));
        href = xpath.evaluate("//Layer[Name='cdf:Fifteen']/Style[Name='point']/LegendURL/OnlineResource/@xlink:href", doc);
        GetCapabilitiesTest.assertTrue((boolean)href.contains("GetLegendGraphic"));
        GetCapabilitiesTest.assertTrue((boolean)href.contains("layer=Fifteen"));
        GetCapabilitiesTest.assertTrue((boolean)href.contains("style=point"));
    }
}

