/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses.helpers;

import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import org.custommonkey.xmlunit.NamespaceContext;
import org.custommonkey.xmlunit.SimpleNamespaceContext;
import org.custommonkey.xmlunit.XMLAssert;
import org.custommonkey.xmlunit.XMLUnit;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.test.GeoServerTestSupport;
import org.w3c.dom.Document;

public class ProxyTest
extends GeoServerTestSupport {
    private static final String baseUrl = "http://localhost/geoserver";
    private static final Set<String> mapFormats = Collections.singleton("image/png");
    private static final Set<String> legendFormats = Collections.singleton("image/png");

    protected void setUpInternal() throws Exception {
        HashMap<String, String> namespaces = new HashMap<String, String>();
        namespaces.put("xlink", "http://www.w3.org/1999/xlink");
        XMLUnit.setXpathNamespaceContext((NamespaceContext)new SimpleNamespaceContext(namespaces));
    }

    public void testProxyBaseUrl() throws Exception {
        String proxyBaseUrl = "http://localhost/proxy";
        GeoServerInfo gs = this.getGeoServer().getGlobal();
        gs.setProxyBaseUrl("http://localhost/proxy");
        this.getGeoServer().save(gs);
        Document dom = this.getAsDOM("wms?request=GetCapabilities");
        this.print(dom);
        String serviceOnlineRes = "/WMT_MS_Capabilities/Service/OnlineResource/@xlink:href";
        XMLAssert.assertXpathEvaluatesTo((String)"http://localhost/proxy/wms", (String)serviceOnlineRes, (Document)dom);
        String getCapsGet = "/WMT_MS_Capabilities/Capability/Request/GetCapabilities/DCPType/HTTP/Get/OnlineResource/@xlink:href";
        XMLAssert.assertXpathEvaluatesTo((String)"http://localhost/proxy/wms?SERVICE=WMS&", (String)getCapsGet, (Document)dom);
        String getCapsPost = "/WMT_MS_Capabilities/Capability/Request/GetCapabilities/DCPType/HTTP/Post/OnlineResource/@xlink:href";
        XMLAssert.assertXpathEvaluatesTo((String)"http://localhost/proxy/wms?SERVICE=WMS&", (String)getCapsPost, (Document)dom);
        String getMapGet = "/WMT_MS_Capabilities/Capability/Request/GetMap/DCPType/HTTP/Get/OnlineResource/@xlink:href";
        XMLAssert.assertXpathEvaluatesTo((String)"http://localhost/proxy/wms?SERVICE=WMS&", (String)getMapGet, (Document)dom);
        String getFeatureInfoGet = "/WMT_MS_Capabilities/Capability/Request/GetFeatureInfo/DCPType/HTTP/Get/OnlineResource/@xlink:href";
        XMLAssert.assertXpathEvaluatesTo((String)"http://localhost/proxy/wms?SERVICE=WMS&", (String)getFeatureInfoGet, (Document)dom);
        String getFeatureInfoPost = "/WMT_MS_Capabilities/Capability/Request/GetFeatureInfo/DCPType/HTTP/Post/OnlineResource/@xlink:href";
        XMLAssert.assertXpathEvaluatesTo((String)"http://localhost/proxy/wms?SERVICE=WMS&", (String)getFeatureInfoPost, (Document)dom);
        String describeLayerGet = "/WMT_MS_Capabilities/Capability/Request/DescribeLayer/DCPType/HTTP/Get/OnlineResource/@xlink:href";
        XMLAssert.assertXpathEvaluatesTo((String)"http://localhost/proxy/wms?SERVICE=WMS&", (String)describeLayerGet, (Document)dom);
        String getLegentGet = "/WMT_MS_Capabilities/Capability/Request/GetLegendGraphic/DCPType/HTTP/Get/OnlineResource/@xlink:href";
        XMLAssert.assertXpathEvaluatesTo((String)"http://localhost/proxy/wms?SERVICE=WMS&", (String)getLegentGet, (Document)dom);
    }
}

