/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.demo;

import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Polygon;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JToolBar;
import org.geotools.data.FeatureSource;
import org.geotools.data.FileDataStore;
import org.geotools.data.FileDataStoreFinder;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.DefaultMapContext;
import org.geotools.map.FeatureLayer;
import org.geotools.map.Layer;
import org.geotools.map.MapContext;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.Graphic;
import org.geotools.styling.LineSymbolizer;
import org.geotools.styling.Mark;
import org.geotools.styling.Rule;
import org.geotools.styling.Stroke;
import org.geotools.styling.Style;
import org.geotools.styling.StyleFactory;
import org.geotools.swing.JMapFrame;
import org.geotools.swing.data.JFileDataStoreChooser;
import org.geotools.swing.event.MapMouseEvent;
import org.geotools.swing.tool.CursorTool;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.identity.FeatureId;
import org.opengis.filter.spatial.Intersects;
import org.opengis.style.Fill;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectionLab {
    private StyleFactory sf = CommonFactoryFinder.getStyleFactory(null);
    private FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2(null);
    private static final Color LINE_COLOUR = Color.BLUE;
    private static final Color FILL_COLOUR = Color.CYAN;
    private static final Color SELECTED_COLOUR = Color.YELLOW;
    private static final float OPACITY = 1.0f;
    private static final float LINE_WIDTH = 1.0f;
    private static final float POINT_SIZE = 10.0f;
    private JMapFrame mapFrame;
    private SimpleFeatureSource featureSource;
    private String geometryAttributeName;
    private GeomType geometryType;

    public static void main(String[] args) throws Exception {
        SelectionLab me = new SelectionLab();
        File file = JFileDataStoreChooser.showOpenFile((String)"shp", null);
        if (file == null) {
            return;
        }
        me.displayShapefile(file);
    }

    public void displayShapefile(File file) throws Exception {
        FileDataStore store = FileDataStoreFinder.getDataStore((File)file);
        this.featureSource = store.getFeatureSource();
        this.setGeometry();
        DefaultMapContext map = new DefaultMapContext();
        map.setTitle("Feature selection tool example");
        Style style = this.createDefaultStyle();
        map.addLayer((FeatureSource)this.featureSource, style);
        this.mapFrame = new JMapFrame((MapContext)map);
        this.mapFrame.enableToolBar(true);
        this.mapFrame.enableStatusBar(true);
        JToolBar toolBar = this.mapFrame.getToolBar();
        JButton btn = new JButton("Select");
        toolBar.addSeparator();
        toolBar.add(btn);
        btn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SelectionLab.this.mapFrame.getMapPane().setCursorTool(new CursorTool(){

                    public void onMouseClicked(MapMouseEvent ev) {
                        SelectionLab.this.selectFeatures(ev);
                    }
                });
            }
        });
        this.mapFrame.setSize(600, 600);
        this.mapFrame.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void selectFeatures(MapMouseEvent ev) {
        System.out.println("Mouse click at: " + ev.getMapPosition());
        Point screenPos = ev.getPoint();
        Rectangle screenRect = new Rectangle(screenPos.x - 2, screenPos.y - 2, 5, 5);
        AffineTransform screenToWorld = this.mapFrame.getMapPane().getScreenToWorldTransform();
        Rectangle2D worldRect = screenToWorld.createTransformedShape(screenRect).getBounds2D();
        ReferencedEnvelope bbox = new ReferencedEnvelope(worldRect, this.mapFrame.getMapContext().getCoordinateReferenceSystem());
        Intersects filter = this.ff.intersects((Expression)this.ff.property(this.geometryAttributeName), (Expression)this.ff.literal((Object)bbox));
        try {
            SimpleFeatureCollection selectedFeatures = this.featureSource.getFeatures((Filter)filter);
            SimpleFeatureIterator iter = selectedFeatures.features();
            HashSet<FeatureId> IDs = new HashSet<FeatureId>();
            try {
                while (iter.hasNext()) {
                    SimpleFeature feature = (SimpleFeature)iter.next();
                    IDs.add(feature.getIdentifier());
                    System.out.println("   " + feature.getIdentifier());
                }
            }
            finally {
                iter.close();
            }
            if (IDs.isEmpty()) {
                System.out.println("   no feature selected");
            }
            this.displaySelectedFeatures(IDs);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return;
        }
    }

    public void displaySelectedFeatures(Set<FeatureId> IDs) {
        Style style = IDs.isEmpty() ? this.createDefaultStyle() : this.createSelectedStyle(IDs);
        Layer layer = (Layer)this.mapFrame.getMapContext().layers().get(0);
        ((FeatureLayer)layer).setStyle(style);
        this.mapFrame.getMapPane().repaint();
    }

    private Style createDefaultStyle() {
        Rule rule = this.createRule(LINE_COLOUR, FILL_COLOUR);
        FeatureTypeStyle fts = this.sf.createFeatureTypeStyle();
        fts.rules().add(rule);
        Style style = this.sf.createStyle();
        style.featureTypeStyles().add(fts);
        return style;
    }

    private Style createSelectedStyle(Set<FeatureId> IDs) {
        Rule selectedRule = this.createRule(SELECTED_COLOUR, SELECTED_COLOUR);
        selectedRule.setFilter((Filter)this.ff.id(IDs));
        Rule otherRule = this.createRule(LINE_COLOUR, FILL_COLOUR);
        otherRule.setElseFilter(true);
        FeatureTypeStyle fts = this.sf.createFeatureTypeStyle();
        fts.rules().add(selectedRule);
        fts.rules().add(otherRule);
        Style style = this.sf.createStyle();
        style.featureTypeStyles().add(fts);
        return style;
    }

    private Rule createRule(Color outlineColor, Color fillColor) {
        LineSymbolizer symbolizer = null;
        org.geotools.styling.Fill fill = null;
        Stroke stroke = this.sf.createStroke((Expression)this.ff.literal((Object)outlineColor), (Expression)this.ff.literal(1.0f));
        switch (this.geometryType) {
            case POLYGON: {
                fill = this.sf.createFill((Expression)this.ff.literal((Object)fillColor), (Expression)this.ff.literal(1.0f));
                symbolizer = this.sf.createPolygonSymbolizer(stroke, fill, this.geometryAttributeName);
                break;
            }
            case LINE: {
                symbolizer = this.sf.createLineSymbolizer(stroke, this.geometryAttributeName);
                break;
            }
            case POINT: {
                fill = this.sf.createFill((Expression)this.ff.literal((Object)fillColor), (Expression)this.ff.literal(1.0f));
                Mark mark = this.sf.getCircleMark();
                mark.setFill((Fill)fill);
                mark.setStroke((org.opengis.style.Stroke)stroke);
                Graphic graphic = this.sf.createDefaultGraphic();
                graphic.graphicalSymbols().clear();
                graphic.graphicalSymbols().add(mark);
                graphic.setSize((Expression)this.ff.literal(10.0f));
                symbolizer = this.sf.createPointSymbolizer(graphic, this.geometryAttributeName);
            }
        }
        Rule rule = this.sf.createRule();
        rule.symbolizers().add(symbolizer);
        return rule;
    }

    private void setGeometry() {
        GeometryDescriptor geomDesc = ((SimpleFeatureType)this.featureSource.getSchema()).getGeometryDescriptor();
        this.geometryAttributeName = geomDesc.getLocalName();
        Class clazz = geomDesc.getType().getBinding();
        this.geometryType = Polygon.class.isAssignableFrom(clazz) || MultiPolygon.class.isAssignableFrom(clazz) ? GeomType.POLYGON : (LineString.class.isAssignableFrom(clazz) || MultiLineString.class.isAssignableFrom(clazz) ? GeomType.LINE : GeomType.POINT);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum GeomType {
        POINT,
        LINE,
        POLYGON;

    }
}

