/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.demo.filter;

import java.net.URL;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.data.FeatureSource;
import org.geotools.data.FileDataStore;
import org.geotools.data.FileDataStoreFinder;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.map.DefaultMapContext;
import org.geotools.map.MapContext;
import org.geotools.styling.Fill;
import org.geotools.styling.PolygonSymbolizer;
import org.geotools.styling.SLD;
import org.geotools.styling.Stroke;
import org.geotools.styling.Style;
import org.geotools.styling.StyleFactory;
import org.geotools.styling.Symbolizer;
import org.geotools.swing.JMapFrame;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Function;

public class InterpolateFunctionExample {
    private StyleFactory sf = CommonFactoryFinder.getStyleFactory(null);
    private FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2(null);
    private JMapFrame frame;
    private AbstractGridCoverage2DReader reader;

    public static void main(String[] args) throws Exception {
        InterpolateFunctionExample me = new InterpolateFunctionExample();
        me.displayShapefile();
    }

    private void displayShapefile() throws Exception {
        URL url = this.getClass().getResource("/data/shapefiles/countries.shp");
        FileDataStore store = FileDataStoreFinder.getDataStore((URL)url);
        SimpleFeatureSource featureSource = store.getFeatureSource();
        DefaultMapContext map = new DefaultMapContext();
        map.setTitle("Interpolated polygon fill color");
        map.addLayer((FeatureSource)featureSource, this.createInterpolatedStyle());
        JMapFrame.showMap((MapContext)map);
    }

    private Style createInterpolatedStyle() {
        Expression[] params = new Expression[]{this.ff.property("POP_CNTRY"), this.ff.literal(0), this.ff.literal((Object)"#0000ff"), this.ff.literal(1.0E7), this.ff.literal((Object)"#00ff00"), this.ff.literal(1.0E9), this.ff.literal((Object)"#ff0000"), this.ff.literal((Object)"linear"), this.ff.literal((Object)"color")};
        Function fn = this.ff.function("Interpolate", params);
        Fill fill = this.sf.createFill((Expression)fn);
        Stroke stroke = this.sf.createStroke((Expression)this.ff.literal((Object)"#000000"), (Expression)this.ff.literal(1.0));
        PolygonSymbolizer sym = this.sf.createPolygonSymbolizer(stroke, fill, null);
        return SLD.wrapSymbolizers((Symbolizer[])new Symbolizer[]{sym});
    }
}

