/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.demo.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.io.IOException;
import java.net.URL;
import java.util.Random;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.Timer;
import org.geotools.data.FeatureSource;
import org.geotools.data.FileDataStore;
import org.geotools.data.FileDataStoreFinder;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.geometry.DirectPosition2D;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.DefaultMapContext;
import org.geotools.map.MapContext;
import org.geotools.renderer.GTRenderer;
import org.geotools.renderer.lite.StreamingRenderer;
import org.geotools.styling.SLD;
import org.geotools.styling.Style;
import org.geotools.swing.JMapPane;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class FlyingSaucer
extends JMapPane {
    private static final Random rand = new Random();
    private static final Image SPRITE_IMAGE = new ImageIcon(FlyingSaucer.class.getResource("/images/compass_100.png")).getImage();
    private double movementDistance = 3.0;
    private int xdir = 1;
    private int ydir = 1;
    private ReferencedEnvelope spriteEnv;
    private Raster spriteBackground;
    private boolean firstDisplay = true;
    private Timer animationTimer = new Timer(200, new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            FlyingSaucer.this.drawSprite();
        }
    });

    protected void paintComponent(Graphics g) {
        this.animationTimer.stop();
        super.paintComponent(g);
    }

    public void onRenderingCompleted() {
        super.onRenderingCompleted();
        this.spriteBackground = null;
        this.animationTimer.start();
    }

    private void drawSprite() {
        if (this.firstDisplay) {
            this.setSpritePosition();
            this.firstDisplay = false;
        }
        Graphics2D gr2D = (Graphics2D)this.getGraphics();
        this.eraseSprite(gr2D);
        this.moveSprite();
        this.paintSprite(gr2D);
    }

    private void eraseSprite(Graphics2D gr2D) {
        if (this.spriteBackground != null) {
            Rectangle rect = this.spriteBackground.getBounds();
            BufferedImage image = new BufferedImage(rect.width, rect.height, 2);
            Raster child = this.spriteBackground.createChild(rect.x, rect.y, rect.width, rect.height, 0, 0, null);
            image.setData(child);
            gr2D.setBackground(this.getBackground());
            gr2D.clearRect(rect.x, rect.y, rect.width, rect.height);
            gr2D.drawImage((Image)image, rect.x, rect.y, null);
            this.spriteBackground = null;
        }
    }

    private void moveSprite() {
        ReferencedEnvelope displayArea = this.getDisplayArea();
        DirectPosition2D lower = new DirectPosition2D();
        DirectPosition2D upper = new DirectPosition2D();
        double xdelta = 0.0;
        double ydelta = 0.0;
        boolean done = false;
        while (!done) {
            lower.setLocation(this.spriteEnv.getLowerCorner());
            upper.setLocation(this.spriteEnv.getUpperCorner());
            xdelta = (double)this.xdir * this.movementDistance;
            ydelta = (double)this.ydir * this.movementDistance;
            lower.setLocation(lower.getX() + xdelta, lower.getY() + ydelta);
            upper.setLocation(upper.getX() + xdelta, upper.getY() + ydelta);
            boolean lowerIn = displayArea.contains((DirectPosition)lower);
            boolean upperIn = displayArea.contains((DirectPosition)upper);
            if (lowerIn && upperIn) {
                done = true;
                continue;
            }
            if (!lowerIn) {
                if (lower.x < displayArea.getMinX()) {
                    this.xdir = -this.xdir;
                    continue;
                }
                if (!(lower.y < displayArea.getMinY())) continue;
                this.ydir = -this.ydir;
                continue;
            }
            if (upperIn) continue;
            if (upper.x > displayArea.getMaxX()) {
                this.xdir = -this.xdir;
                continue;
            }
            if (!(upper.y > displayArea.getMaxY())) continue;
            this.ydir = -this.ydir;
        }
        this.spriteEnv.translate(xdelta, ydelta);
    }

    private void paintSprite(Graphics2D gr2D) {
        Rectangle bounds = this.getSpriteScreenPos();
        this.spriteBackground = this.getBaseImage().getData(bounds);
        gr2D.drawImage(SPRITE_IMAGE, bounds.x, bounds.y, null);
    }

    private void setSpritePosition() {
        ReferencedEnvelope worldBounds = null;
        try {
            worldBounds = this.getMapContext().getLayerBounds();
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
        CoordinateReferenceSystem crs = worldBounds.getCoordinateReferenceSystem();
        Rectangle screenBounds = this.getVisibleRect();
        int w = SPRITE_IMAGE.getWidth(null);
        int h = SPRITE_IMAGE.getHeight(null);
        int x = screenBounds.x + rand.nextInt(screenBounds.width - w);
        int y = screenBounds.y + rand.nextInt(screenBounds.height - h);
        Rectangle r = new Rectangle(x, y, w, h);
        AffineTransform tr = this.getScreenToWorldTransform();
        Rectangle2D rworld = tr.createTransformedShape(r).getBounds2D();
        this.spriteEnv = new ReferencedEnvelope(rworld, crs);
    }

    private Rectangle getSpriteScreenPos() {
        AffineTransform tr = this.getWorldToScreenTransform();
        Point2D.Double lowerCorner = new Point2D.Double(this.spriteEnv.getMinX(), this.spriteEnv.getMinY());
        Point2D.Double upperCorner = new Point2D.Double(this.spriteEnv.getMaxX(), this.spriteEnv.getMaxY());
        Point2D p0 = tr.transform(lowerCorner, null);
        Point2D p1 = tr.transform(upperCorner, null);
        Rectangle r = new Rectangle();
        r.setFrameFromDiagonal(p0, p1);
        return r;
    }

    public static void main(String[] args) throws Exception {
        JFrame frame = new JFrame("Animation example");
        FlyingSaucer mapPane = new FlyingSaucer();
        frame.getContentPane().add((Component)((Object)mapPane));
        frame.setSize(800, 500);
        URL url = FlyingSaucer.class.getResource("/data/shapefiles/countries.shp");
        FileDataStore store = FileDataStoreFinder.getDataStore((URL)url);
        SimpleFeatureSource featureSource = store.getFeatureSource();
        DefaultMapContext map = new DefaultMapContext();
        Style style = SLD.createPolygonStyle((Color)Color.BLACK, (Color)Color.CYAN, (float)1.0f);
        map.addLayer((FeatureSource)featureSource, style);
        mapPane.setMapContext((MapContext)map);
        mapPane.setRenderer((GTRenderer)new StreamingRenderer());
        frame.setDefaultCloseOperation(3);
        frame.setVisible(true);
    }
}

