/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.demo;

import com.vividsolutions.jts.geom.Geometry;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.Serializable;
import java.util.HashMap;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JToolBar;
import org.geotools.data.DataStore;
import org.geotools.data.DefaultQuery;
import org.geotools.data.DefaultTransaction;
import org.geotools.data.FeatureSource;
import org.geotools.data.FeatureStore;
import org.geotools.data.FeatureWriter;
import org.geotools.data.FileDataStore;
import org.geotools.data.FileDataStoreFinder;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.geotools.data.shapefile.ShapefileDataStoreFactory;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.JTS;
import org.geotools.map.DefaultMapContext;
import org.geotools.map.MapContext;
import org.geotools.referencing.CRS;
import org.geotools.swing.JMapFrame;
import org.geotools.swing.ProgressWindow;
import org.geotools.swing.action.SafeAction;
import org.geotools.swing.data.JFileDataStoreChooser;
import org.jdesktop.swingworker.SwingWorker;
import org.opengis.feature.Feature;
import org.opengis.feature.FeatureVisitor;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.FeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.util.ProgressListener;

public class CRSLab {
    private File sourceFile;
    private FeatureSource<SimpleFeatureType, SimpleFeature> featureSource;
    private MapContext map;
    private int numInvalidGeometries = 0;

    public static void main(String[] args) throws Exception {
        CRSLab lab = new CRSLab();
        lab.displayShapefile();
    }

    private void displayShapefile() throws Exception {
        this.sourceFile = JFileDataStoreChooser.showOpenFile((String)"shp", null);
        if (this.sourceFile == null) {
            return;
        }
        FileDataStore store = FileDataStoreFinder.getDataStore((File)this.sourceFile);
        this.featureSource = store.getFeatureSource();
        this.map = new DefaultMapContext();
        this.map.addLayer(this.featureSource, null);
        JMapFrame mapFrame = new JMapFrame(this.map);
        mapFrame.enableTool(new JMapFrame.Tool[]{JMapFrame.Tool.NONE});
        mapFrame.enableStatusBar(true);
        JToolBar toolbar = mapFrame.getToolBar();
        toolbar.add(new JButton((Action)((Object)new ValidateGeometryAction())));
        toolbar.add(new JButton((Action)((Object)new ExportShapefileAction())));
        mapFrame.setSize(800, 600);
        mapFrame.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportToShapefile() throws Exception {
        SimpleFeatureType schema = (SimpleFeatureType)this.featureSource.getSchema();
        JFileDataStoreChooser chooser = new JFileDataStoreChooser("shp");
        chooser.setDialogTitle("Save reprojected shapefile");
        chooser.setSaveFile(this.sourceFile);
        int returnVal = chooser.showSaveDialog(null);
        if (returnVal != 0) {
            return;
        }
        File file = chooser.getSelectedFile();
        if (file.equals(this.sourceFile)) {
            JOptionPane.showMessageDialog(null, "Cannot replace " + file);
            return;
        }
        CoordinateReferenceSystem dataCRS = schema.getCoordinateReferenceSystem();
        CoordinateReferenceSystem worldCRS = this.map.getCoordinateReferenceSystem();
        boolean lenient = true;
        MathTransform transform = CRS.findMathTransform((CoordinateReferenceSystem)dataCRS, (CoordinateReferenceSystem)worldCRS, (boolean)lenient);
        FeatureCollection featureCollection = this.featureSource.getFeatures();
        ShapefileDataStoreFactory factory = new ShapefileDataStoreFactory();
        HashMap<String, Serializable> create = new HashMap<String, Serializable>();
        create.put("url", file.toURI().toURL());
        create.put("create spatial index", Boolean.TRUE);
        DataStore newDataStore = factory.createNewDataStore(create);
        SimpleFeatureType featureType = SimpleFeatureTypeBuilder.retype((SimpleFeatureType)schema, (CoordinateReferenceSystem)worldCRS);
        newDataStore.createSchema((FeatureType)featureType);
        DefaultTransaction transaction = new DefaultTransaction("Reproject");
        FeatureWriter writer = newDataStore.getFeatureWriterAppend(featureType.getTypeName(), (Transaction)transaction);
        FeatureIterator iterator = featureCollection.features();
        try {
            while (iterator.hasNext()) {
                SimpleFeature feature = (SimpleFeature)iterator.next();
                SimpleFeature copy = (SimpleFeature)writer.next();
                copy.setAttributes(feature.getAttributes());
                Geometry geometry = (Geometry)feature.getDefaultGeometry();
                Geometry geometry2 = JTS.transform((Geometry)geometry, (MathTransform)transform);
                copy.setDefaultGeometry((Object)geometry2);
                writer.write();
            }
            transaction.commit();
            JOptionPane.showMessageDialog(null, "Export to shapefile complete");
        }
        catch (Exception problem) {
            problem.printStackTrace();
            transaction.rollback();
            JOptionPane.showMessageDialog(null, "Export to shapefile failed");
        }
        finally {
            writer.close();
            iterator.close();
            transaction.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportToShapefile2() throws Exception {
        FeatureType schema = this.featureSource.getSchema();
        String typeName = schema.getName().getLocalPart();
        JFileDataStoreChooser chooser = new JFileDataStoreChooser("shp");
        chooser.setDialogTitle("Save reprojected shapefile");
        chooser.setSaveFile(this.sourceFile);
        int returnVal = chooser.showSaveDialog(null);
        if (returnVal != 0) {
            return;
        }
        File file = chooser.getSelectedFile();
        if (file.equals(this.sourceFile)) {
            JOptionPane.showMessageDialog(null, "Cannot replace " + file, "File warning", 2);
            return;
        }
        DefaultQuery query = new DefaultQuery();
        query.setTypeName(typeName);
        query.setCoordinateSystemReproject(this.map.getCoordinateReferenceSystem());
        FeatureCollection featureCollection = this.featureSource.getFeatures((Query)query);
        ShapefileDataStoreFactory factory = new ShapefileDataStoreFactory();
        HashMap<String, Serializable> create = new HashMap<String, Serializable>();
        create.put("url", file.toURI().toURL());
        create.put("create spatial index", Boolean.TRUE);
        DataStore newDataStore = factory.createNewDataStore(create);
        newDataStore.createSchema(featureCollection.getSchema());
        DefaultTransaction transaction = new DefaultTransaction("Reproject");
        FeatureStore featureStore = (FeatureStore)newDataStore.getFeatureSource(typeName);
        featureStore.setTransaction((Transaction)transaction);
        try {
            featureStore.addFeatures(featureCollection);
            transaction.commit();
            JOptionPane.showMessageDialog(null, "Export to shapefile complete", "Export", 1);
        }
        catch (Exception problem) {
            problem.printStackTrace();
            transaction.rollback();
            JOptionPane.showMessageDialog(null, "Export to shapefile failed", "Export", 0);
        }
        finally {
            transaction.close();
        }
    }

    private void validateFeatureGeometry() throws Exception {
        FeatureCollection featureCollection = this.featureSource.getFeatures();
        FeatureVisitor visitor = new FeatureVisitor(){

            public void visit(Feature feature) {
                Geometry geom = (Geometry)feature.getDefaultGeometryProperty().getValue();
                if (geom != null && !geom.isValid()) {
                    CRSLab.this.numInvalidGeometries++;
                    System.out.println("Invalid Geoemtry: " + feature.getIdentifier());
                }
            }
        };
        ProgressWindow progress = new ProgressWindow(null);
        progress.setTitle("Validating feature geometry");
        this.numInvalidGeometries = 0;
        featureCollection.accepts(visitor, (ProgressListener)progress);
    }

    class ValidateGeometryAction
    extends SafeAction {
        ValidateGeometryAction() {
            super("Validate geometry");
            this.putValue("ShortDescription", "Check the geometry of each feature");
        }

        public void action(ActionEvent e) throws Throwable {
            SwingWorker<String, Object> worker = new SwingWorker<String, Object>(){

                protected String doInBackground() throws Exception {
                    CRSLab.this.validateFeatureGeometry();
                    if (CRSLab.this.numInvalidGeometries == 0) {
                        return "All feature geometries are valid";
                    }
                    StringBuilder sb = new StringBuilder();
                    sb.append(CRSLab.this.numInvalidGeometries);
                    sb.append(" feature");
                    if (CRSLab.this.numInvalidGeometries > 1) {
                        sb.append("s");
                    }
                    sb.append(" with invalid geometries (see console output)");
                    return sb.toString();
                }

                protected void done() {
                    try {
                        JOptionPane.showMessageDialog(null, this.get(), "Geometry results", 1);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            };
            worker.execute();
        }
    }

    class ExportShapefileAction
    extends SafeAction {
        ExportShapefileAction() {
            super("Export...");
            this.putValue("ShortDescription", "Export features in the current projection");
        }

        public void action(ActionEvent e) throws Throwable {
            CRSLab.this.exportToShapefile();
        }
    }
}

