/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.demo;

import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Polygon;
import java.awt.Color;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JOptionPane;
import org.geotools.data.FeatureSource;
import org.geotools.data.FileDataStore;
import org.geotools.data.FileDataStoreFinder;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.visitor.UniqueVisitor;
import org.geotools.filter.FunctionExpressionImpl;
import org.geotools.map.DefaultMapContext;
import org.geotools.map.MapContext;
import org.geotools.styling.Graphic;
import org.geotools.styling.Mark;
import org.geotools.styling.PolygonSymbolizer;
import org.geotools.styling.SLD;
import org.geotools.styling.Stroke;
import org.geotools.styling.Style;
import org.geotools.styling.StyleFactory;
import org.geotools.styling.Symbolizer;
import org.geotools.swing.JMapFrame;
import org.geotools.swing.data.JFileDataStoreChooser;
import org.opengis.feature.FeatureVisitor;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.feature.type.PropertyDescriptor;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.Expression;
import org.opengis.style.Fill;

public class StyleFunctionLab {
    public static void main(String[] args) throws Exception {
        File file = JFileDataStoreChooser.showOpenFile((String)"shp", null);
        if (file == null) {
            return;
        }
        StyleFunctionLab me = new StyleFunctionLab();
        me.displayShapefile(file);
    }

    private void displayShapefile(File file) throws Exception {
        FileDataStore store = FileDataStoreFinder.getDataStore((File)file);
        FeatureSource featureSource = store.getFeatureSource();
        DefaultMapContext map = new DefaultMapContext();
        map.setTitle("Style Function Lab");
        FeatureType type = featureSource.getSchema();
        GeometryDescriptor geomDesc = type.getGeometryDescriptor();
        ArrayList<String> attributeNames = new ArrayList<String>();
        for (PropertyDescriptor desc : type.getDescriptors()) {
            if (desc.equals(geomDesc)) continue;
            attributeNames.add(desc.getName().getLocalPart());
        }
        Object selection = JOptionPane.showInputDialog(null, "Unique values of the attribute will be used to create a colour lookup table", "Select feature attribute", -1, null, attributeNames.toArray(), null);
        if (selection != null) {
            Style style = this.createStyle(featureSource, (String)selection);
            map.addLayer(featureSource, style);
            JMapFrame.showMap((MapContext)map);
        }
    }

    private Style createStyle(FeatureSource featureSource, String attributeName) throws Exception {
        FilterFactory2 filterFactory = CommonFactoryFinder.getFilterFactory2(null);
        StyleFactory styleFactory = CommonFactoryFinder.getStyleFactory(null);
        ColorLookupFunction colourFn = new ColorLookupFunction(featureSource.getFeatures(), (Expression)filterFactory.property(attributeName));
        Stroke stroke = styleFactory.createStroke((Expression)colourFn, (Expression)filterFactory.literal(1.0f), (Expression)filterFactory.literal(1.0f));
        org.geotools.styling.Fill fill = styleFactory.createFill((Expression)colourFn, (Expression)filterFactory.literal(1.0f));
        Class geomClass = featureSource.getSchema().getGeometryDescriptor().getType().getBinding();
        PolygonSymbolizer sym = null;
        if (Polygon.class.isAssignableFrom(geomClass) || MultiPolygon.class.isAssignableFrom(geomClass)) {
            sym = styleFactory.createPolygonSymbolizer(stroke, fill, null);
        } else if (LineString.class.isAssignableFrom(geomClass) || MultiLineString.class.isAssignableFrom(geomClass)) {
            sym = styleFactory.createLineSymbolizer(stroke, null);
        } else {
            Graphic gr = styleFactory.createDefaultGraphic();
            gr.graphicalSymbols().clear();
            Mark mark = styleFactory.getCircleMark();
            mark.setFill((Fill)fill);
            mark.setStroke((org.opengis.style.Stroke)stroke);
            gr.graphicalSymbols().add(mark);
            gr.setSize((Expression)filterFactory.literal(10.0f));
            sym = styleFactory.createPointSymbolizer(gr, null);
        }
        Style style = SLD.wrapSymbolizers((Symbolizer[])new Symbolizer[]{sym});
        return style;
    }

    static class ColorLookupFunction
    extends FunctionExpressionImpl {
        private static final float INITIAL_HUE = 0.1f;
        private final FeatureCollection collection;
        Map<Object, Color> lookup;
        private int numColours;
        private float hue;
        private float hueIncr;
        private float saturation = 0.7f;
        private float brightness = 0.7f;

        public ColorLookupFunction(FeatureCollection collection, Expression colourAttribute) {
            super("UniqueColour");
            this.collection = collection;
            this.params.add(colourAttribute);
            this.fallback = CommonFactoryFinder.getFilterFactory2(null).literal((Object)Color.WHITE);
        }

        public int getArgCount() {
            return 1;
        }

        public Object evaluate(Object feature) {
            Object key;
            Color color;
            if (this.lookup == null) {
                this.createLookup();
            }
            if ((color = this.lookup.get(key = ((Expression)this.params.get(0)).evaluate(feature))) == null) {
                color = this.addColor(key);
            }
            return color;
        }

        private void createLookup() {
            this.lookup = new HashMap<Object, Color>();
            try {
                UniqueVisitor visitor = new UniqueVisitor((Expression)this.params.get(0));
                this.collection.accepts((FeatureVisitor)visitor, null);
                this.numColours = visitor.getUnique().size();
                this.hue = 0.1f;
                this.hueIncr = (1.0f - this.hue) / (float)this.numColours;
            }
            catch (Exception ex) {
                throw new IllegalStateException("Problem creating colour lookup", ex);
            }
        }

        private Color addColor(Object key) {
            Color c = new Color(Color.HSBtoRGB(this.hue, this.saturation, this.brightness));
            this.hue += this.hueIncr;
            this.lookup.put(key, c);
            return c;
        }
    }
}

