/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.demo.process;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.geotools.coverage.CoverageFactoryFinder;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.NameImpl;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.DefaultMapContext;
import org.geotools.map.MapContext;
import org.geotools.process.Process;
import org.geotools.process.Processors;
import org.geotools.process.raster.RasterToVectorFactory;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.styling.SLD;
import org.geotools.styling.Style;
import org.geotools.swing.JMapFrame;
import org.geotools.swing.ProgressWindow;
import org.jdesktop.swingworker.SwingWorker;
import org.opengis.feature.type.Name;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.util.ProgressListener;

public class ProcessAPI {
    public static void main(String[] args) throws Exception {
        new ProcessAPI().demo();
    }

    private void demo() throws Exception {
        ReferencedEnvelope env = new ReferencedEnvelope(0.0, 8.0, 0.0, 8.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        GridCoverage2D cov = this.createChessboardCoverage(256, 256, 4, env);
        final HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(RasterToVectorFactory.RASTER.key, cov);
        params.put(RasterToVectorFactory.BAND.key, 0);
        params.put(RasterToVectorFactory.BOUNDS.key, env);
        params.put(RasterToVectorFactory.OUTSIDE.key, Collections.singleton(0.0));
        final Process r2v = Processors.createProcess((Name)new NameImpl("gt", "RasterToVectorProcess"));
        SwingWorker<Map<String, Object>, Void> worker = new SwingWorker<Map<String, Object>, Void>(){

            protected Map<String, Object> doInBackground() throws Exception {
                ProgressWindow pw = new ProgressWindow(null);
                pw.setTitle("Vectorizing coverage");
                return r2v.execute(params, (ProgressListener)pw);
            }

            protected void done() {
                Map vectorizingResults = null;
                try {
                    vectorizingResults = (Map)this.get();
                }
                catch (Exception ignore) {
                    // empty catch block
                }
                if (vectorizingResults != null) {
                    FeatureCollection fc = (FeatureCollection)vectorizingResults.get(RasterToVectorFactory.RESULT_FEATURES.key);
                    DefaultMapContext map = new DefaultMapContext();
                    map.setTitle("raster to vector conversion");
                    Style style = SLD.createPolygonStyle((Color)Color.BLUE, (Color)Color.CYAN, (float)1.0f);
                    map.addLayer(fc, style);
                    JMapFrame.showMap((MapContext)map);
                }
            }
        };
        worker.execute();
    }

    private GridCoverage2D createChessboardCoverage(int imgWidth, int imgHeight, int squareWidth, ReferencedEnvelope env) {
        GridCoverageFactory factory = CoverageFactoryFinder.getGridCoverageFactory(null);
        GridCoverage2D cov = factory.create((CharSequence)"chessboard", this.createChessboardImage(imgWidth, imgHeight, squareWidth), (Envelope)env);
        return cov;
    }

    private RenderedImage createChessboardImage(int imgWidth, int imgHeight, int squareWidth) {
        BufferedImage img = new BufferedImage(imgWidth, imgHeight, 12);
        WritableRaster raster = img.getRaster();
        for (int y = 0; y < imgHeight; ++y) {
            boolean oddRow = y / squareWidth % 2 == 1;
            for (int x = 0; x < imgWidth; ++x) {
                boolean oddCol = x / squareWidth % 2 == 1;
                raster.setSample(x, y, 0, oddCol == oddRow ? 1 : 0);
            }
        }
        return img;
    }
}

