/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.demo.referencing;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateFilter;
import org.geotools.geometry.GeneralDirectPosition;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public class TransformationCoordinateFilter
implements CoordinateFilter {
    private MathTransform transform;

    public TransformationCoordinateFilter(MathTransform transform) {
        this.transform = transform;
    }

    public void filter(Coordinate coordinate) {
        GeneralDirectPosition point = new GeneralDirectPosition(coordinate.x, coordinate.y);
        try {
            point = this.transform.transform((DirectPosition)point, (DirectPosition)point);
        }
        catch (TransformException e) {
            System.out.println("Error in transformation: " + (Object)((Object)e));
        }
        coordinate.x = point.getOrdinate(0);
        coordinate.y = point.getOrdinate(1);
    }
}

