/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.complex.filter;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.xml.namespace.QName;
import junit.framework.TestCase;
import org.geotools.data.ComplexTestData;
import org.geotools.data.complex.filter.XPath;
import org.geotools.feature.type.AttributeDescriptorImpl;
import org.geotools.feature.type.FeatureTypeFactoryImpl;
import org.geotools.gml3.GMLSchema;
import org.geotools.xlink.XLINK;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.FeatureTypeFactory;
import org.opengis.feature.type.Name;
import org.xml.sax.helpers.NamespaceSupport;

public class XPathTest
extends TestCase {
    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testSteps() throws Exception {
        FeatureType complexType = ComplexTestData.createExample01MultiValuedComplexProperty((FeatureTypeFactory)new FeatureTypeFactoryImpl());
        Name name = complexType.getName();
        AttributeDescriptorImpl descriptor = new AttributeDescriptorImpl((AttributeType)complexType, name, 0, Integer.MAX_VALUE, true, null);
        NamespaceSupport namespaces = new NamespaceSupport();
        namespaces.declarePrefix("wq", name.getNamespaceURI());
        try {
            XPath.steps((AttributeDescriptor)descriptor, null, (NamespaceSupport)namespaces);
            XPathTest.fail((String)"passed null");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        String xpath = "/";
        XPathTest.assertEquals((int)1, (int)XPath.steps((AttributeDescriptor)descriptor, (String)xpath, (NamespaceSupport)namespaces).size());
        XPath.Step step = (XPath.Step)XPath.steps((AttributeDescriptor)descriptor, (String)xpath, (NamespaceSupport)namespaces).get(0);
        QName rootQName = new QName(name.getNamespaceURI(), name.getLocalPart());
        XPathTest.assertEquals((Object)rootQName, (Object)step.getName());
        List<XPath.Step> expected = Collections.singletonList(new XPath.Step(rootQName, 1));
        xpath = "wq_plus";
        XPathTest.assertEquals(expected, (Object)XPath.steps((AttributeDescriptor)descriptor, (String)xpath, (NamespaceSupport)namespaces));
        expected = Collections.singletonList(new XPath.Step(rootQName, 1));
        xpath = "/wq_plus";
        XPathTest.assertEquals(expected, (Object)XPath.steps((AttributeDescriptor)descriptor, (String)xpath, (NamespaceSupport)namespaces));
        expected = Collections.singletonList(new XPath.Step(rootQName, 1));
        xpath = "wq_plus/measurement/result/../../measurement/determinand_description/../..";
        XPathTest.assertEquals(expected, (Object)XPath.steps((AttributeDescriptor)descriptor, (String)xpath, (NamespaceSupport)namespaces));
        expected = Arrays.asList(new XPath.Step(new QName(rootQName.getNamespaceURI(), "measurement"), 2), new XPath.Step(new QName(rootQName.getNamespaceURI(), "result"), 1));
        xpath = "wq_plus/measurement/result/../../measurement[2]/result";
        XPathTest.assertEquals(expected, (Object)XPath.steps((AttributeDescriptor)descriptor, (String)xpath, (NamespaceSupport)namespaces));
        expected = Arrays.asList(new XPath.Step(new QName(rootQName.getNamespaceURI(), "measurement"), 1), new XPath.Step(new QName(rootQName.getNamespaceURI(), "result"), 1));
        xpath = "wq_plus/measurement/result/../result/.";
        XPathTest.assertEquals(expected, (Object)XPath.steps((AttributeDescriptor)descriptor, (String)xpath, (NamespaceSupport)namespaces));
        expected = Arrays.asList(new XPath.Step(new QName(rootQName.getNamespaceURI(), "measurement"), 5));
        xpath = "measurement/result/../../measurement[5]";
        XPathTest.assertEquals(expected, (Object)XPath.steps((AttributeDescriptor)descriptor, (String)xpath, (NamespaceSupport)namespaces));
    }

    public void testStepsWithXmlAttribute() throws Exception {
        FeatureType complexType = ComplexTestData.createExample01MultiValuedComplexProperty((FeatureTypeFactory)new FeatureTypeFactoryImpl());
        Name name = complexType.getName();
        AttributeDescriptorImpl descriptor = new AttributeDescriptorImpl((AttributeType)complexType, name, 0, Integer.MAX_VALUE, true, null);
        QName rootQName = new QName(name.getNamespaceURI(), name.getLocalPart());
        NamespaceSupport namespaces = new NamespaceSupport();
        namespaces.declarePrefix("wq", name.getNamespaceURI());
        namespaces.declarePrefix("xlink", "http://www.w3.org/1999/xlink");
        XPath.StepList steps = XPath.steps((AttributeDescriptor)descriptor, (String)"wq_plus/measurement[2]/@xlink:href", (NamespaceSupport)namespaces);
        XPathTest.assertNotNull((Object)steps);
        XPathTest.assertEquals((String)steps.toString(), (int)2, (int)steps.size());
        XPath.Step step1 = new XPath.Step(new QName(rootQName.getNamespaceURI(), "measurement"), 2, false);
        XPath.Step step2 = new XPath.Step(XLINK.HREF, 1, true);
        XPathTest.assertEquals((Object)step1, (Object)steps.get(0));
        XPathTest.assertEquals((Object)step2, (Object)steps.get(1));
    }

    public void testStepEquals() {
        XPath.Step step1 = new XPath.Step(XLINK.FROM, 1);
        XPath.Step step2 = new XPath.Step(XLINK.HREF, 1, false);
        XPath.Step step3 = new XPath.Step(XLINK.HREF, 1, false);
        XPath.Step step4 = new XPath.Step(XLINK.HREF, 1, true);
        XPath.Step step5 = new XPath.Step(XLINK.HREF, 2, false);
        XPathTest.assertFalse((boolean)step1.equals(null));
        XPathTest.assertFalse((boolean)step1.equals(new Object()));
        XPathTest.assertFalse((boolean)step1.equals((Object)step2));
        XPathTest.assertTrue((boolean)step2.equals((Object)step3));
        XPathTest.assertFalse((boolean)step2.equals((Object)step4));
        XPathTest.assertFalse((boolean)step2.equals((Object)step5));
    }

    public void testIsSimpleContentType() {
        XPathTest.assertTrue((boolean)XPath.isSimpleContentType((AttributeType)GMLSchema.CODETYPE_TYPE));
        XPathTest.assertTrue((boolean)XPath.isSimpleContentType((AttributeType)GMLSchema.MEASURETYPE_TYPE));
        XPathTest.assertFalse((boolean)XPath.isSimpleContentType((AttributeType)GMLSchema.POINTTYPE_TYPE));
        XPathTest.assertFalse((boolean)XPath.isSimpleContentType((AttributeType)GMLSchema.POINTPROPERTYTYPE_TYPE));
        XPathTest.assertFalse((boolean)XPath.isSimpleContentType((AttributeType)GMLSchema.ABSTRACTFEATURETYPE_TYPE));
        XPathTest.assertFalse((boolean)XPath.isSimpleContentType((AttributeType)GMLSchema.ABSTRACTFEATURECOLLECTIONTYPE_TYPE));
    }
}

