/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.complex;

import com.vividsolutions.jts.util.Stopwatch;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.geotools.data.DataAccess;
import org.geotools.data.DataAccessFinder;
import org.geotools.data.FeatureSource;
import org.geotools.data.complex.DataAccessRegistry;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.Types;
import org.geotools.filter.FilterFactoryImpl;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.opengis.feature.Feature;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.PropertyName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolymorphicChainingTest {
    static final String EX_NS = "urn:example:xmlns:ArtifactML:1.0";
    static final Name ARTIFACT = Types.typeName((String)"urn:example:xmlns:ArtifactML:1.0", (String)"Artifact");
    static FilterFactory ff = new FilterFactoryImpl(null);
    private static final String schemaBase = "/test-data/";
    private static FeatureSource<FeatureType, Feature> artifactSource;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        Stopwatch sw = new Stopwatch();
        sw.start();
        PolymorphicChainingTest.loadDataAccesses();
        sw.stop();
        System.out.println("Set up time: " + sw.getTimeString());
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        DataAccessRegistry.unregisterAll();
    }

    @Test
    public void testSimpleFilter() throws Exception {
        PropertyName property = ff.property("ex:seqId");
        PropertyIsEqualTo filter = ff.equals((Expression)property, (Expression)ff.literal(101));
        FeatureCollection filteredResults = artifactSource.getFeatures((Filter)filter);
        List<Feature> retVal = this.getFeatures((FeatureCollection<FeatureType, Feature>)filteredResults);
        Assert.assertEquals((long)1L, (long)retVal.size());
        Feature feature = retVal.get(0);
        PolymorphicChainingTest.assertId("a.101", feature);
    }

    @Test
    public void testMultiMappedFilter() throws Exception {
        PropertyName property = ff.property("ex:attributes/ex:Attribute/ex:key");
        PropertyIsEqualTo filter = ff.equals((Expression)property, (Expression)ff.literal((Object)"stringKey1"));
        FeatureCollection filteredResults = artifactSource.getFeatures((Filter)filter);
        List<Feature> retVal = this.getFeatures((FeatureCollection<FeatureType, Feature>)filteredResults);
        Assert.assertEquals((long)0L, (long)retVal.size());
        property = ff.property("ex:attributes/ex:StringAttribute/ex:key");
        filter = ff.equals((Expression)property, (Expression)ff.literal((Object)"stringKey1"));
        filteredResults = artifactSource.getFeatures((Filter)filter);
        retVal = this.getFeatures((FeatureCollection<FeatureType, Feature>)filteredResults);
        Assert.assertEquals((long)2L, (long)retVal.size());
        Feature feature = retVal.get(0);
        PolymorphicChainingTest.assertId("a.101", feature);
        feature = retVal.get(1);
        PolymorphicChainingTest.assertId("a.102", feature);
        property = ff.property("ex:attributes/ex:GeoAttribute/ex:key");
        filter = ff.equals((Expression)property, (Expression)ff.literal((Object)"stringKey1"));
        filteredResults = artifactSource.getFeatures((Filter)filter);
        retVal = this.getFeatures((FeatureCollection<FeatureType, Feature>)filteredResults);
        Assert.assertEquals((long)0L, (long)retVal.size());
    }

    protected static void assertId(String expected, Feature f) {
        String actual = f.getIdentifier().toString();
        Assert.assertEquals((String)("Incorrect id: " + actual), (Object)expected, (Object)actual);
    }

    private static void loadDataAccesses() throws Exception {
        HashMap<String, String> dsParams = new HashMap<String, String>();
        URL url = PolymorphicChainingTest.class.getResource("/test-data/artifact_mapping.xml");
        Assert.assertNotNull((Object)url);
        dsParams.put("dbtype", "app-schema");
        dsParams.put("url", url.toExternalForm());
        DataAccess mfDataAccess = DataAccessFinder.getDataStore(dsParams);
        Assert.assertNotNull((Object)mfDataAccess);
        FeatureType mappedFeatureType = mfDataAccess.getSchema(ARTIFACT);
        Assert.assertNotNull((Object)mappedFeatureType);
        artifactSource = mfDataAccess.getFeatureSource(ARTIFACT);
    }

    protected List<Feature> getFeatures(FeatureCollection<FeatureType, Feature> features) {
        FeatureIterator iterator = features.features();
        ArrayList<Feature> retVal = new ArrayList<Feature>();
        while (iterator.hasNext()) {
            retVal.add(iterator.next());
        }
        iterator.close();
        return retVal;
    }
}

