/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.complex;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.geotools.data.DataAccess;
import org.geotools.data.DataAccessFactory;
import org.geotools.data.DataStore;
import org.geotools.data.DataUtilities;
import org.geotools.data.complex.AppSchemaDataAccess;
import org.geotools.data.complex.config.AppSchemaDataAccessConfigurator;
import org.geotools.data.complex.config.AppSchemaDataAccessDTO;
import org.geotools.data.complex.config.XMLConfigDigester;
import org.opengis.feature.Feature;
import org.opengis.feature.type.FeatureType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppSchemaDataAccessFactory
implements DataAccessFactory {
    public static final String DBTYPE_STRING = "app-schema";
    public static final DataAccessFactory.Param DBTYPE = new DataAccessFactory.Param("dbtype", String.class, "Fixed value 'app-schema'", true, (Object)"app-schema");
    public static final DataAccessFactory.Param URL = new DataAccessFactory.Param("url", URL.class, "URL to an application schema datastore XML configuration file", true);

    public DataAccess<FeatureType, Feature> createDataStore(Map params) throws IOException {
        URL configFileUrl = (URL)URL.lookUp(params);
        XMLConfigDigester configReader = new XMLConfigDigester();
        AppSchemaDataAccessDTO config = configReader.parse(configFileUrl);
        List<String> includes = config.getIncludes();
        Iterator<String> it = includes.iterator();
        while (it.hasNext()) {
            String parentLocation = DataUtilities.urlToFile((URL)configFileUrl).getParent();
            File includedConfig = new File(parentLocation, it.next());
            if (!includedConfig.exists()) {
                throw new RuntimeException("Please check that the includedTypes location is correct: \n '" + includedConfig.getPath() + "' doesn't exist!");
            }
            URL relatedConfigURL = DataUtilities.fileToURL((File)includedConfig);
            params.put("url", relatedConfigURL);
            this.createDataStore(params);
        }
        Set mappings = AppSchemaDataAccessConfigurator.buildMappings(config);
        AppSchemaDataAccess dataStore = new AppSchemaDataAccess(mappings);
        dataStore.register();
        return dataStore;
    }

    public DataStore createNewDataStore(Map params) throws IOException {
        throw new UnsupportedOperationException();
    }

    public String getDisplayName() {
        return "Application Schema DataAccess";
    }

    public String getDescription() {
        return "Application Schema DataStore allows mapping of FeatureTypes to externally defined Output Schemas";
    }

    public DataAccessFactory.Param[] getParametersInfo() {
        return new DataAccessFactory.Param[]{DBTYPE, URL};
    }

    public boolean canProcess(Map params) {
        try {
            Object dbType = DBTYPE.lookUp(params);
            Object configUrl = URL.lookUp(params);
            return DBTYPE_STRING.equals(dbType) && configUrl != null;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean isAvailable() {
        return true;
    }

    public Map getImplementationHints() {
        return Collections.EMPTY_MAP;
    }
}

