/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.complex;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.data.complex.AbstractMappingFeatureIterator;
import org.geotools.data.complex.AppSchemaDataAccess;
import org.geotools.data.complex.AttributeCreateOrderList;
import org.geotools.data.complex.AttributeMapping;
import org.geotools.data.complex.FeatureTypeMapping;
import org.geotools.data.complex.PathAttributeList;
import org.geotools.data.complex.TreeAttributeMapping;
import org.geotools.data.complex.filter.XPath;
import org.geotools.data.complex.xml.XmlFeatureCollection;
import org.geotools.data.complex.xml.XmlFeatureSource;
import org.geotools.data.complex.xml.XmlResponse;
import org.geotools.feature.AttributeBuilder;
import org.geotools.feature.FeatureCollection;
import org.geotools.filter.LiteralExpressionImpl;
import org.geotools.util.XmlXpathUtilites;
import org.jdom.Element;
import org.opengis.feature.Attribute;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.Name;
import org.opengis.filter.expression.Expression;
import org.xml.sax.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlMappingFeatureIterator
extends AbstractMappingFeatureIterator {
    private static final String XPATH_SEPARATOR = "/";
    private static final String XPATH_LEFT_INDEX_BRACKET = "[";
    private static final String XPATH_RIGHT_INDEX_BRACKET = "]";
    protected XmlResponse xmlResponse;
    private List<Element> sources;
    private FeatureSource<SimpleFeatureType, SimpleFeature> mappedSource;
    private FeatureCollection<SimpleFeatureType, SimpleFeature> sourceFeatures;
    private AttributeCreateOrderList attOrderedTypeList = null;
    private List<TreeAttributeMapping> setterAttributes = new ArrayList<TreeAttributeMapping>();
    private TreeAttributeMapping rootAttribute;
    private int count = 0;
    private int indexCounter = 1;
    private String idXpath = this.featureFidMapping.toString();
    private static Query cachedQuery = null;
    protected static XmlResponse cachedXmlResponse = null;

    public XmlMappingFeatureIterator(AppSchemaDataAccess store, FeatureTypeMapping mapping, Query query) throws IOException {
        super(store, mapping, query);
        List<Integer> ls = this.xmlResponse.getValidFeatureIndex();
        this.count = ls.size();
    }

    protected Iterator<Element> getSourceFeatureIterator() {
        return null;
    }

    @Override
    protected boolean isSourceFeatureIteratorNull() {
        return this.xmlResponse == null;
    }

    protected void setSourceFeatureIterator(Iterator<Element> xmlSourceFeatureIterator) {
    }

    @Override
    protected void initialiseSourceFeatures(FeatureTypeMapping mapping, Query query) throws IOException {
        this.mappedSource = mapping.getSource();
        if (cachedQuery == null || !cachedQuery.equals(query)) {
            this.sourceFeatures = this.mappedSource.getFeatures(query);
            XmlFeatureSource xmlFeatureSource = (XmlFeatureSource)this.mappedSource;
            xmlFeatureSource.setNamespaces(mapping.getNamespaces());
            xmlFeatureSource.setItemXpath(mapping.getItemXpath());
            this.xmlResponse = ((XmlFeatureCollection)this.sourceFeatures).xmlResponse();
            cachedQuery = query;
            cachedXmlResponse = this.xmlResponse;
        } else {
            this.xmlResponse = cachedXmlResponse;
            cachedXmlResponse = null;
            cachedQuery = null;
        }
    }

    @Override
    protected String extractIdForFeature() {
        return XmlXpathUtilites.getSingleXPathValue(this.mapping.getNamespaces(), this.createIndexedItemXpathString() + XPATH_SEPARATOR + this.idXpath, this.xmlResponse.getDoc());
    }

    private String createIndexedItemXpathString() {
        return this.mapping.itemXpath + XPATH_LEFT_INDEX_BRACKET + this.xmlResponse.getValidFeatureIndex().get(this.indexCounter - 1) + XPATH_RIGHT_INDEX_BRACKET;
    }

    @Override
    protected String extractIdForAttribute(Expression idExpression, Object sourceInstance) {
        String value = (String)idExpression.evaluate(sourceInstance, String.class);
        return value;
    }

    @Override
    protected Feature populateFeatureData(String id) throws IOException {
        AttributeDescriptor targetNode = this.mapping.getTargetFeature();
        AttributeBuilder builder = new AttributeBuilder(this.attf);
        builder.setDescriptor(targetNode);
        Feature target = (Feature)builder.build(id);
        if (this.attOrderedTypeList == null) {
            this.initialiseAttributeLists(this.mapping.getAttributeMappings());
        }
        PathAttributeList elements = this.populateAttributeList(target);
        this.setAttributeValues(elements);
        ++this.indexCounter;
        return target;
    }

    private void setAttributeValues(PathAttributeList elements) {
        for (TreeAttributeMapping attMapping : this.setterAttributes) {
            Expression sourceExpression = attMapping.getSourceExpression();
            List<PathAttributeList.Pair> ls = elements.get(attMapping.getParentLabel());
            if (ls == null) continue;
            for (int i = 0; i < ls.size(); ++i) {
                PathAttributeList.Pair parentPair = ls.get(i);
                Attribute setterTarget = parentPair.getAttribute();
                StringBuffer usedXpath = new StringBuffer();
                List<String> values = this.getValue(parentPair.getXpath(), sourceExpression, usedXpath);
                this.setValues(attMapping, setterTarget, usedXpath, values);
            }
        }
    }

    private void setValues(TreeAttributeMapping attMapping, Attribute setterTarget, StringBuffer usedXpath, List<String> values) {
        for (int j = 0; j < values.size(); ++j) {
            String value = values.get(j);
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("setting target=" + setterTarget.getName() + ", targetXpath=" + (Object)((Object)attMapping.getTargetXPath()) + ", value=" + value);
            }
            Attribute subFeature = this.xpathAttributeBuilder.set(setterTarget, attMapping.getTargetXPath(), value, null, null, false);
            this.setClientProperties(subFeature, j == 0 ? usedXpath : usedXpath.append(this.bracketedIndex(j)), attMapping.getClientProperties());
        }
    }

    private String bracketedIndex(int j) {
        return XPATH_LEFT_INDEX_BRACKET + Integer.toString(j + 1) + XPATH_RIGHT_INDEX_BRACKET;
    }

    private PathAttributeList populateAttributeList(Feature target) {
        PathAttributeList elements = new PathAttributeList();
        elements.put(this.rootAttribute.getLabel(), this.createIndexedItemXpathString(), (Attribute)target);
        Iterator<TreeAttributeMapping> it = this.attOrderedTypeList.iterator();
        while (it.hasNext()) {
            TreeAttributeMapping attMapping = it.next();
            Expression sourceExpression = attMapping.getIdentifierExpression();
            List<PathAttributeList.Pair> ls = elements.get(attMapping.getParentLabel());
            if (ls == null) continue;
            for (int i = 0; i < ls.size(); ++i) {
                PathAttributeList.Pair parentAttribute = ls.get(i);
                int count = 1;
                String countXpath = null;
                if (attMapping.getInstanceXpath() != null) {
                    countXpath = parentAttribute.getXpath() + XPATH_SEPARATOR + attMapping.getInstanceXpath();
                    count = XmlXpathUtilites.countXPathNodes(this.mapping.getNamespaces(), countXpath, this.xmlResponse.getDoc());
                }
                this.createSubFeaturesAndAddToAttributeList(elements, attMapping, sourceExpression, parentAttribute, count, countXpath);
            }
        }
        return elements;
    }

    private void createSubFeaturesAndAddToAttributeList(PathAttributeList elements, TreeAttributeMapping attMapping, Expression sourceExpression, PathAttributeList.Pair parentAttribute, int count, String countXpath) {
        for (int j = 0; j < count; ++j) {
            String bracketIndex = this.bracketedIndex(j);
            String xpath = this.setFeatureXpath(attMapping, sourceExpression, parentAttribute, bracketIndex);
            List<String> featureIdList = this.getValue(xpath);
            String featureId = null;
            if (!featureIdList.isEmpty()) {
                featureId = featureIdList.get(0);
            }
            XPath.StepList sl = attMapping.getTargetXPath();
            this.setPathIndex(j, sl);
            Attribute subFeature = this.xpathAttributeBuilder.set(parentAttribute.getAttribute(), sl, null, featureId, attMapping.getTargetNodeInstance(), false);
            elements.put(attMapping.getLabel(), countXpath + bracketIndex, subFeature);
        }
    }

    private String setFeatureXpath(TreeAttributeMapping attMapping, Expression sourceExpression, PathAttributeList.Pair parentAttribute, String bracketIndex) {
        String xpath = attMapping.getInstanceXpath() == null ? parentAttribute.getXpath() + XPATH_SEPARATOR + sourceExpression.toString() : parentAttribute.getXpath() + XPATH_SEPARATOR + attMapping.getInstanceXpath() + bracketIndex + XPATH_SEPARATOR + sourceExpression.toString();
        return xpath;
    }

    private void setPathIndex(int j, XPath.StepList sl) {
        if (j > 0) {
            XPath.Step st = (XPath.Step)sl.get(sl.size() - 1);
            XPath.Step st2 = new XPath.Step(st.getName(), j + 1, st.isXmlAttribute());
            sl.remove(sl.size() - 1);
            sl.add(st2);
        }
    }

    @Override
    protected boolean unprocessedFeatureExists() {
        return this.indexCounter <= this.count;
    }

    @Override
    protected boolean sourceFeatureIteratorHasNext() {
        return this.indexCounter <= this.count;
    }

    @Override
    protected boolean isNextSourceFeatureNull() {
        return this.indexCounter > this.count;
    }

    @Override
    protected List<String> getValue(Expression expression, Object data) {
        return this.getValue(((StringBuffer)data).toString(), expression, new StringBuffer());
    }

    protected List<String> getValue(String xpathPrefix, Expression node, StringBuffer usedXpath) {
        boolean isUnsetNode;
        String EMPTY_STRING = "";
        String expressionValue = node.toString();
        boolean bl = isUnsetNode = Expression.NIL.equals(node) || expressionValue.equals("''");
        if (isUnsetNode || expressionValue.startsWith("'") || node instanceof LiteralExpressionImpl) {
            usedXpath.append(xpathPrefix);
            String editedValue = "";
            ArrayList<String> ls = new ArrayList<String>(1);
            if (!isUnsetNode) {
                editedValue = expressionValue.replace("'", "");
            }
            ls.add(editedValue);
            return ls;
        }
        expressionValue = xpathPrefix + XPATH_SEPARATOR + expressionValue;
        usedXpath.append(expressionValue);
        return this.getValue(expressionValue);
    }

    protected List<String> getValue(String expressionValue) {
        return XmlXpathUtilites.getXPathValues(this.mapping.getNamespaces(), expressionValue, this.xmlResponse.getDoc());
    }

    protected void setAttributeValueFromSources(Feature target, AttributeMapping attMapping) throws IOException {
        for (Element source : this.sources) {
            this.setAttributeValue(target, source, attMapping);
        }
    }

    @Override
    protected void closeSourceFeatures() {
        if (this.sourceFeatures != null) {
            this.xmlResponse = null;
            this.sourceFeatures = null;
        }
    }

    private void initialiseAttributeLists(List<AttributeMapping> mappings) {
        TreeAttributeMapping treeAttMapping;
        for (AttributeMapping attMapping : mappings) {
            if (!attMapping.isTreeAttribute() || (treeAttMapping = (TreeAttributeMapping)attMapping).getLabel() == null || treeAttMapping.getParentLabel() != null || attMapping.getTargetNodeInstance() != null) continue;
            this.rootAttribute = treeAttMapping;
            break;
        }
        this.attOrderedTypeList = new AttributeCreateOrderList(this.rootAttribute.getLabel());
        for (AttributeMapping attMapping : mappings) {
            if (!attMapping.isTreeAttribute()) continue;
            treeAttMapping = (TreeAttributeMapping)attMapping;
            if (treeAttMapping.getLabel() == null) {
                this.setterAttributes.add(treeAttMapping);
                continue;
            }
            if (treeAttMapping.getParentLabel() == null) continue;
            this.attOrderedTypeList.put(treeAttMapping);
        }
    }

    protected void setAttributeValue(Feature target, Feature source, XPath.StepList xpath, String id) throws IOException {
        this.xpathAttributeBuilder.set((Attribute)target, xpath, source, id, (AttributeType)source.getType(), false);
    }

    protected void setAttributeValue(Feature target, Object source, AttributeMapping attMapping) throws IOException {
        Expression sourceExpression = attMapping.getSourceExpression();
        Object value = this.getValue(sourceExpression, source);
        String id = null;
        if (Expression.NIL != attMapping.getIdentifierExpression()) {
            id = this.extractIdForAttribute(attMapping.getIdentifierExpression(), source);
        }
        AttributeType targetNodeType = attMapping.getTargetNodeInstance();
        XPath.StepList xpath = attMapping.getTargetXPath();
        Attribute instance = this.xpathAttributeBuilder.set((Attribute)target, xpath, value, id, targetNodeType, attMapping.isMultiValued());
        Map<Name, Expression> clientPropsMappings = attMapping.getClientProperties();
        this.setClientProperties(instance, source, clientPropsMappings);
    }

    @Override
    protected void setClientProperties(Attribute target, Object source, Map<Name, Expression> clientProperties) {
        if (clientProperties.size() == 0) {
            return;
        }
        HashMap<Name, String> targetAttributes = new HashMap<Name, String>();
        for (Map.Entry<Name, Expression> entry : clientProperties.entrySet()) {
            Name propName = entry.getKey();
            Expression propExpr = entry.getValue();
            String propValue = "";
            Object ls = this.getValue(propExpr, source);
            if (!ls.isEmpty()) {
                propValue = (String)ls.get(0);
            }
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("setting target=" + target.getName() + ", property Name=" + propName + ", value=" + propValue);
            }
            targetAttributes.put(propName, propValue);
        }
        target.getUserData().put(Attributes.class, targetAttributes);
    }
}

